/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.dependencies;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.jps.model.resolver.JpsDependencyResolverConfiguration;
import com.intellij.platform.jps.model.resolver.JpsDependencyResolverConfigurationService;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.SmartHashSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.aether.Retry;
import org.jetbrains.idea.maven.aether.RetryProvider;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.dependencies.DependencyAuthenticationDataProvider;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsRepositoryLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsChecksumUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public final class DependencyResolvingBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance(DependencyResolvingBuilder.class);
    private static final String MAVEN_REPOSITORY_PATH_VAR = "MAVEN_REPOSITORY";
    private static final String DEFAULT_MAVEN_REPOSITORY_PATH = ".m2/repository";
    private static final Key<Pair<ArtifactRepositoryManager, Map<String, ArtifactRepositoryManager>>> MANAGERS_KEY = GlobalContextKey.create("_artifact_repository_manager_");
    private static final Key<Exception> RESOLVE_ERROR_KEY = Key.create((String)"_artifact_repository_resolve_error_");
    public static final String RESOLUTION_PARALLELISM_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.parallelism";
    public static final String RESOLUTION_RETRY_ENABLED_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.retry.enabled";
    public static final String RESOLUTION_RETRY_MAX_ATTEMPTS_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.retry.max.attempts";
    public static final String RESOLUTION_RETRY_DELAY_MS_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.retry.delay.ms";
    public static final String RESOLUTION_RETRY_BACKOFF_LIMIT_MS_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.retry.backoff.limit.ms";
    public static final String RESOLUTION_SHA256_CHECKSUM_IGNORE_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.sha256.checksum.ignored";
    public static final String RESOLUTION_BIND_REPOSITORY_IGNORE_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.bind.repository.ignored";
    public static final String RESOLUTION_RETRY_DOWNLOAD_CORRUPTED_ZIP_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.retry.download.corrupted.zip";
    public static final String RESOLUTION_RETRY_DOWNLOAD_CORRUPTED_ZIP_LEGACY_PROPERTY = "org.jetbrains.idea.maven.aether.strictValidation";
    public static final String RESOLUTION_REPORT_CORRUPTED_ZIP_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.report.corrupted.zip";
    public static final String RESOLUTION_REPORT_INVALID_SHA256_CHECKSUM_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.report.invalid.sha256.checksum";
    public static final String RESOLUTION_CORRUPTED_ARTIFACTS_REPORTS_DIRECTORY_PROPERTY = "org.jetbrains.jps.incremental.dependencies.resolution.corrupted.artifacts.directory";

    public DependencyResolvingBuilder() {
        super(BuilderCategory.INITIAL);
    }

    @Override
    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return DependencyResolvingBuilder.getBuilderName();
    }

    @Override
    public void buildStarted(CompileContext context) {
        JpsLibraryResolveGuard.init(context);
    }

    @Override
    public void chunkBuildStarted(CompileContext context, ModuleChunk chunk) {
        try {
            DependencyResolvingBuilder.resolveMissingDependencies(context, chunk.getModules(), BuildTargetChunk.forModulesChunk(chunk));
        }
        catch (Exception e) {
            context.putUserData(RESOLVE_ERROR_KEY, e);
        }
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        Exception error = (Exception)context.getUserData(RESOLVE_ERROR_KEY);
        if (error != null) {
            return DependencyResolvingBuilder.reportError(context, chunk.getPresentableShortName(), error);
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    @NotNull
    static ModuleLevelBuilder.ExitCode reportError(CompileContext context, String placePresentableName, Exception error) {
        @Nls StringBuilder builder = new StringBuilder().append(JpsBuildBundle.message("build.message.error.resolving.dependencies.for", placePresentableName));
        HashSet<Exception> processed = new HashSet<Exception>();
        HashSet<String> detailsMessage = new HashSet<String>();
        for (Throwable th = error; th != null && processed.add((Exception)th); th = th.getCause()) {
            String details = th.getMessage();
            if (th instanceof UnknownHostException) {
                details = JpsBuildBundle.message("build.message.unknown.host.0", details);
            }
            if (details == null || !detailsMessage.add(details)) continue;
            builder.append(":\n").append(details);
        }
        String msg = builder.toString();
        LOG.info(msg, (Throwable)error);
        context.processMessage(new CompilerMessage(DependencyResolvingBuilder.getBuilderName(), BuildMessage.Kind.ERROR, msg));
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.ABORT;
        if (exitCode == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(1);
        }
        return exitCode;
    }

    static void resolveMissingDependencies(CompileContext context, Collection<? extends JpsModule> modules, BuildTargetChunk currentTargets) throws Exception {
        Collection<JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>> libs = DependencyResolvingBuilder.getRepositoryLibraries(modules);
        if (!libs.isEmpty()) {
            JpsDependencyResolverConfiguration resolverConfiguration = JpsDependencyResolverConfigurationService.getInstance().getOrCreateDependencyResolverConfiguration(context.getProjectDescriptor().getProject());
            boolean ignoreChecksums = SystemProperties.getBooleanProperty((String)RESOLUTION_SHA256_CHECKSUM_IGNORE_PROPERTY, (boolean)false);
            boolean ignoreBindRepository = SystemProperties.getBooleanProperty((String)RESOLUTION_BIND_REPOSITORY_IGNORE_PROPERTY, (boolean)false);
            boolean verifySha256Checksums = !ignoreChecksums && resolverConfiguration.isSha256ChecksumVerificationEnabled();
            boolean useBindRepositories = !ignoreBindRepository && resolverConfiguration.isBindRepositoryEnabled();
            DependencyResolvingBuilder.resolveMissingDependencies(libs, lib -> {
                try {
                    DependencyResolvingBuilder.resolveMissingDependency(context, currentTargets, (JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>)lib, verifySha256Checksums, useBindRepositories);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveMissingDependencies(Collection<? extends JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>> libs, Consumer<? super JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>> resolveAction) throws Exception {
        int parallelism = SystemProperties.getIntProperty((String)RESOLUTION_PARALLELISM_PROPERTY, (int)1);
        if (parallelism < 2 || libs.size() < 2) {
            libs.forEach(resolveAction);
        } else {
            ExecutorService executorService = Executors.newFixedThreadPool(parallelism);
            try {
                List futures = ContainerUtil.map(libs, lib -> executorService.submit(() -> resolveAction.accept((JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>)lib)));
                for (Future future : futures) {
                    future.get();
                }
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    private static void resolveMissingDependency(CompileContext context, BuildTargetChunk currentTargets, JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>> lib, boolean verifySha256Checksums, boolean useBindRepositories) throws Exception {
        JpsMavenRepositoryLibraryDescriptor descriptor = (JpsMavenRepositoryLibraryDescriptor)((JpsSimpleElement)lib.getProperties()).getData();
        List compiledRoots = lib.getFiles(JpsOrderRootType.COMPILED);
        JpsLibraryResolveGuard.performUnderGuard(context, descriptor, compiledRoots, () -> {
            try {
                List required = ContainerUtil.filter((Collection)compiledRoots, root -> !DependencyResolvingBuilder.verifyLibraryArtifact(context, lib.getName(), descriptor, root));
                ArtifactRepositoryManager effectiveRepoManager = DependencyResolvingBuilder.getRepositoryManager(context, descriptor, lib.getName(), useBindRepositories);
                if (!required.isEmpty()) {
                    context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.resolving.0.library", lib.getName()), currentTargets));
                    LOG.debug("Downloading missing files for " + lib.getName() + " library: " + required);
                    Collection resolved = effectiveRepoManager.resolveDependency(descriptor.getGroupId(), descriptor.getArtifactId(), descriptor.getVersion(), descriptor.isIncludeTransitiveDependencies(), descriptor.getExcludedDependencies());
                    if (!resolved.isEmpty()) {
                        DependencyResolvingBuilder.syncPaths(required, resolved);
                    } else {
                        LOG.info("No artifacts were resolved for repository dependency " + descriptor.getMavenId());
                    }
                }
                DependencyResolvingBuilder.verifyLibraryRootsChecksums(context, lib.getName(), descriptor, compiledRoots, verifySha256Checksums);
            }
            catch (TransferCancelledException e) {
                context.checkCanceled();
            }
        });
    }

    private static void syncPaths(Collection<? extends File> required, @NotNull Collection<? extends File> resolved) throws Exception {
        if (resolved == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(2);
        }
        Set libFiles = FileCollectionFactory.createCanonicalFileSet();
        libFiles.addAll(required);
        libFiles.removeAll(resolved);
        if (!libFiles.isEmpty()) {
            Map nameToArtifactMap = CollectionFactory.createFilePathMap();
            for (File file : resolved) {
                File prev = nameToArtifactMap.put(file.getName(), file);
                if (prev == null) continue;
                throw new Exception("Ambiguous artifacts with the same name: " + prev.getPath() + " and " + file.getPath());
            }
            for (File file : libFiles) {
                File resolvedArtifact = (File)nameToArtifactMap.get(file.getName());
                if (resolvedArtifact == null) continue;
                FileUtil.copy((File)resolvedArtifact, (File)file);
            }
        }
    }

    private static ArtifactRepositoryManager getRepositoryManager(@NotNull CompileContext context, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull String libraryName, boolean useBindRepositories) throws RemoteRepositoryNotFoundException {
        if (context == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(4);
        }
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(5);
        }
        if (!useBindRepositories) {
            return DependencyResolvingBuilder.getRepositoryManager(context);
        }
        String repositoryId = descriptor.getJarRepositoryId();
        if (repositoryId == null) {
            throw new RemoteRepositoryNotFoundException(JpsBuildBundle.message("build.message.error.bind.repository.missing", libraryName));
        }
        return DependencyResolvingBuilder.getRepositoryManager(context, repositoryId);
    }

    private static boolean verifyLibraryArtifact(@NotNull CompileContext context, @NotNull String libraryName, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull File artifact) {
        boolean zipCheckEnabled;
        if (context == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(6);
        }
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(8);
        }
        if (artifact == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(9);
        }
        if (!artifact.exists()) {
            return false;
        }
        boolean bl = zipCheckEnabled = SystemProperties.getBooleanProperty((String)RESOLUTION_RETRY_DOWNLOAD_CORRUPTED_ZIP_PROPERTY, (boolean)false) || SystemProperties.getBooleanProperty((String)RESOLUTION_RETRY_DOWNLOAD_CORRUPTED_ZIP_LEGACY_PROPERTY, (boolean)false);
        if (zipCheckEnabled && (artifact.getName().endsWith(".jar") || artifact.getName().endsWith(".zip"))) {
            long entriesCount = -1L;
            try (ZipFile zip2 = new ZipFile(artifact);){
                entriesCount = zip2.size();
            }
            catch (IOException zip2) {
                // empty catch block
            }
            if (entriesCount <= 0L) {
                try {
                    Path compiledRootPath = artifact.toPath();
                    DependencyResolvingBuilder.reportCorruptedArtifactZip(libraryName, descriptor, compiledRootPath);
                    context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.removing.invalid.artifact", libraryName, artifact)));
                    Files.deleteIfExists(compiledRootPath);
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete invalid zip: " + artifact, e);
                }
            }
        }
        return true;
    }

    private static void verifyLibraryRootsChecksums(@NotNull CompileContext context, @NotNull String libraryName, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull List<File> compiledRoots, boolean verifySha256Checksums) throws ArtifactVerificationException {
        if (context == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(10);
        }
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(11);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(12);
        }
        if (compiledRoots == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(13);
        }
        boolean bl = verifySha256Checksums = verifySha256Checksums && DependencyResolvingBuilder.isLibraryVersionFixed(descriptor);
        if (verifySha256Checksums && !DependencyResolvingBuilder.isAllCompiledRootsVerificationPresent(descriptor, compiledRoots)) {
            throw new ArtifactVerificationException(JpsBuildBundle.message("build.message.error.compile.roots.verification.mismatch", libraryName));
        }
        Map<String, JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> absolutePathToVerificationMetadata = descriptor.getArtifactsVerification().stream().collect(Collectors.toMap(it -> JpsPathUtil.urlToFile((String)it.getUrl()).getAbsolutePath(), it -> it));
        for (File compiledRoot : compiledRoots) {
            if (!compiledRoot.exists()) {
                throw new ArtifactVerificationException(JpsBuildBundle.message("build.message.error.missing.artifacts", libraryName, compiledRoot));
            }
            if (!verifySha256Checksums) continue;
            JpsMavenRepositoryLibraryDescriptor.ArtifactVerification verification = absolutePathToVerificationMetadata.get(compiledRoot.getAbsolutePath());
            DependencyResolvingBuilder.checkSha256ChecksumValid(context, descriptor, libraryName, verification);
        }
    }

    private static boolean isLibraryVersionFixed(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor) {
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(14);
        }
        return !"LATEST".equals(descriptor.getVersion()) && !"RELEASE".equals(descriptor.getVersion()) && !descriptor.getVersion().endsWith("-SNAPSHOT");
    }

    private static boolean isAllCompiledRootsVerificationPresent(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull List<File> compiledRootsFiles) {
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(15);
        }
        if (compiledRootsFiles == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(16);
        }
        if (compiledRootsFiles.size() != descriptor.getArtifactsVerification().size()) {
            return false;
        }
        Set compiledRootsPaths = compiledRootsFiles.stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        Set verifiableArtifactsPaths = descriptor.getArtifactsVerification().stream().map(JpsMavenRepositoryLibraryDescriptor.ArtifactVerification::getUrl).map(it -> JpsPathUtil.urlToFile((String)it).getAbsolutePath()).collect(Collectors.toSet());
        return compiledRootsPaths.equals(verifiableArtifactsPaths);
    }

    private static void checkSha256ChecksumValid(@NotNull CompileContext context, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull String libraryName, @NotNull JpsMavenRepositoryLibraryDescriptor.ArtifactVerification verification) throws ArtifactVerificationException {
        String actualSha256Sum;
        if (context == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(17);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(18);
        }
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(19);
        }
        if (verification == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(20);
        }
        Path path = JpsPathUtil.urlToFile((String)verification.getUrl()).toPath();
        try {
            actualSha256Sum = JpsChecksumUtil.getSha256Checksum((Path)path);
        }
        catch (IOException e) {
            context.processMessage(CompilerMessage.createInternalBuilderError(DependencyResolvingBuilder.getBuilderName(), e));
            throw new RuntimeException(e);
        }
        String expectedSha256Sum = verification.getSha256sum();
        if (!Objects.equals(expectedSha256Sum, actualSha256Sum)) {
            DependencyResolvingBuilder.reportInvalidArtifactChecksum(libraryName, descriptor, path, actualSha256Sum);
            throw new ArtifactVerificationException(JpsBuildBundle.message("build.message.error.invalid.sha256.checksum", libraryName, path, expectedSha256Sum, actualSha256Sum));
        }
    }

    private static void reportCorruptedArtifactZip(@NotNull String libraryName, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull Path artifactFile) {
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(21);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(22);
        }
        if (artifactFile == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(23);
        }
        if (SystemProperties.getBooleanProperty((String)RESOLUTION_REPORT_CORRUPTED_ZIP_PROPERTY, (boolean)false)) {
            String sha256 = "null";
            try {
                sha256 = JpsChecksumUtil.getSha256Checksum((Path)artifactFile);
            }
            catch (IOException e) {
                LOG.error("Failed to compute checksum for corrupted zip: " + artifactFile, (Throwable)e);
            }
            DependencyResolvingBuilder.reportBadArtifact(libraryName, descriptor, artifactFile, sha256, "corrupted_zip");
        }
    }

    private static void reportInvalidArtifactChecksum(@NotNull String libraryName, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull Path artifactFile, @NotNull String sha256sum) {
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(24);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(25);
        }
        if (artifactFile == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(26);
        }
        if (sha256sum == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(27);
        }
        if (SystemProperties.getBooleanProperty((String)RESOLUTION_REPORT_INVALID_SHA256_CHECKSUM_PROPERTY, (boolean)false)) {
            DependencyResolvingBuilder.reportBadArtifact(libraryName, descriptor, artifactFile, sha256sum, "invalid_checksum");
        }
    }

    private static void reportBadArtifact(@NotNull String libraryName, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull Path artifactFile, @NotNull String sha256sum, @NotNull String problemKind) {
        Path artifactCopy;
        String outputDirPath;
        if (libraryName == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(28);
        }
        if (descriptor == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(29);
        }
        if (artifactFile == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(30);
        }
        if (sha256sum == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(31);
        }
        if (problemKind == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(32);
        }
        if ((outputDirPath = System.getProperty(RESOLUTION_CORRUPTED_ARTIFACTS_REPORTS_DIRECTORY_PROPERTY, null)) == null) {
            return;
        }
        Path outputDir = Path.of(outputDirPath, new String[0]);
        Properties description = new Properties();
        description.setProperty("libraryName", libraryName);
        description.setProperty("mavenId", descriptor.getMavenId());
        description.setProperty("problem", problemKind);
        description.setProperty("sha256", sha256sum);
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            String artifactFileFullName = artifactFile.getFileName().toString();
            artifactCopy = Files.createTempFile(outputDir, FileUtilRt.getNameWithoutExtension((String)artifactFileFullName) + "_", "." + FileUtilRt.getExtension((String)artifactFileFullName), new FileAttribute[0]);
            Path artifactCopyDescription = Files.createFile(outputDir.resolve(artifactCopy.getFileName() + ".properties"), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(artifactCopyDescription, new OpenOption[0]);){
                description.store(os, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to report bad artifact", e);
        }
        try {
            Files.copy(artifactFile, artifactCopy, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception e) {
            LOG.error("Unable to copy bad artifact " + artifactFile + " to " + artifactCopy, (Throwable)e);
        }
    }

    @NotNull
    private static Collection<JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>> getRepositoryLibraries(Collection<? extends JpsModule> modules) {
        SmartHashSet result = new SmartHashSet();
        for (JpsModule jpsModule : modules) {
            for (JpsDependencyElement dep : jpsModule.getDependenciesList().getDependencies()) {
                JpsLibrary _lib;
                JpsTypedLibrary lib;
                if (!(dep instanceof JpsLibraryDependency) || (lib = (_lib = ((JpsLibraryDependency)dep).getLibrary()) != null ? _lib.asTyped((JpsLibraryType)JpsRepositoryLibraryType.INSTANCE) : null) == null) continue;
                result.add(lib);
            }
        }
        SmartHashSet smartHashSet = result;
        if (smartHashSet == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(33);
        }
        return smartHashSet;
    }

    public static synchronized ArtifactRepositoryManager getRepositoryManager(CompileContext context) {
        try {
            return DependencyResolvingBuilder.getRepositoryManager(context, null);
        }
        catch (RemoteRepositoryNotFoundException e) {
            LOG.error("RemoteRepositoryNotFoundException should not be thrown here", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static synchronized ArtifactRepositoryManager getRepositoryManager(final CompileContext context, @Nullable String remoteRepositoryId) throws RemoteRepositoryNotFoundException {
        Pair managers = (Pair)MANAGERS_KEY.get((UserDataHolder)context);
        if (managers == null) {
            SmartList repositories = new SmartList();
            for (JpsRemoteRepositoryDescription repo : JpsRemoteRepositoryService.getInstance().getOrCreateRemoteRepositoriesConfiguration(context.getProjectDescriptor().getProject()).getRepositories()) {
                repositories.add(ArtifactRepositoryManager.createRemoteRepository((String)repo.getId(), (String)repo.getUrl(), (ArtifactRepositoryManager.ArtifactAuthenticationData)DependencyResolvingBuilder.obtainAuthenticationData(repo.getUrl())));
            }
            Retry retry = RetryProvider.disabled();
            if (SystemProperties.getBooleanProperty((String)RESOLUTION_RETRY_ENABLED_PROPERTY, (boolean)false)) {
                long retryInitialDelay = SystemProperties.getLongProperty((String)RESOLUTION_RETRY_DELAY_MS_PROPERTY, (long)1000L);
                long retryBackoffLimit = SystemProperties.getLongProperty((String)RESOLUTION_RETRY_BACKOFF_LIMIT_MS_PROPERTY, (long)TimeUnit.MINUTES.toMillis(15L));
                int retryMaxAttempts = SystemProperties.getIntProperty((String)RESOLUTION_RETRY_MAX_ATTEMPTS_PROPERTY, (int)10);
                retry = RetryProvider.withExponentialBackOff((long)retryInitialDelay, (long)retryBackoffLimit, (int)retryMaxAttempts);
            }
            File localRepositoryRoot = DependencyResolvingBuilder.getLocalArtifactRepositoryRoot(context.getProjectDescriptor().getModel().getGlobal());
            ProgressConsumer progressConsumer = new ProgressConsumer(){

                public void consume(@NlsSafe String message) {
                    context.processMessage(new ProgressMessage(message));
                }

                public boolean isCanceled() {
                    return context.getCancelStatus().isCanceled();
                }
            };
            ArtifactRepositoryManager unnamedManager = new ArtifactRepositoryManager(localRepositoryRoot, (List)repositories, progressConsumer, retry);
            HashMap<String, ArtifactRepositoryManager> namedManagers = new HashMap<String, ArtifactRepositoryManager>();
            for (RemoteRepository repository : repositories) {
                namedManagers.put(repository.getId(), new ArtifactRepositoryManager(localRepositoryRoot, Collections.singletonList(repository), progressConsumer, retry));
            }
            managers = Pair.create((Object)unnamedManager, Collections.unmodifiableMap(namedManagers));
            MANAGERS_KEY.set((UserDataHolder)context, (Object)managers);
        }
        if (remoteRepositoryId == null) {
            return (ArtifactRepositoryManager)managers.getFirst();
        }
        ArtifactRepositoryManager namedManager = (ArtifactRepositoryManager)((Map)managers.getSecond()).get(remoteRepositoryId);
        if (namedManager == null) {
            throw new RemoteRepositoryNotFoundException(JpsBuildBundle.message("build.message.error.bind.repository.id.not.found", remoteRepositoryId));
        }
        return namedManager;
    }

    private static ArtifactRepositoryManager.ArtifactAuthenticationData obtainAuthenticationData(String url) {
        for (DependencyAuthenticationDataProvider provider : JpsServiceManager.getInstance().getExtensions(DependencyAuthenticationDataProvider.class)) {
            DependencyAuthenticationDataProvider.AuthenticationData authData = provider.provideAuthenticationData(url);
            if (authData == null) continue;
            return new ArtifactRepositoryManager.ArtifactAuthenticationData(authData.getUserName(), authData.getPassword());
        }
        return null;
    }

    @NotNull
    private static File getLocalArtifactRepositoryRoot(@NotNull JpsGlobal global) {
        JpsPathVariablesConfiguration pvConfig;
        String localRepoPath;
        if (global == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(34);
        }
        String string = localRepoPath = (pvConfig = JpsModelSerializationDataService.getPathVariablesConfiguration((JpsGlobal)global)) != null ? pvConfig.getUserVariableValue(MAVEN_REPOSITORY_PATH_VAR) : null;
        if (localRepoPath != null) {
            return new File(localRepoPath);
        }
        String root = System.getProperty("user.home", null);
        return root != null ? new File(root, DEFAULT_MAVEN_REPOSITORY_PATH) : new File(DEFAULT_MAVEN_REPOSITORY_PATH);
    }

    @NotNull
    @Nls
    private static String getBuilderName() {
        String string = JpsBuildBundle.message("builder.name.maven.dependency.resolver", new Object[0]);
        if (string == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 19: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledRoots";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledRootsFiles";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verification";
                break;
            }
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sha256sum";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemKind";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "global";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reportError";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryLibraries";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "verifyLibraryArtifact";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "verifyLibraryRootsChecksums";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryVersionFixed";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAllCompiledRootsVerificationPresent";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkSha256ChecksumValid";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportCorruptedArtifactZip";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidArtifactChecksum";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reportBadArtifact";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLocalArtifactRepositoryRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JpsLibraryResolveGuard {
        private static final Key<ConcurrentHashMap<Object, Guard>> CONTEXT_KEY = GlobalContextKey.create("_dependency_resolving_builder_guards_");

        private JpsLibraryResolveGuard() {
        }

        private static void init(CompileContext context) {
            context.putUserData(CONTEXT_KEY, new ConcurrentHashMap());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void performUnderGuard(@NotNull CompileContext context, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, @NotNull List<File> roots, @NotNull ThrowingRunnable action) throws Exception {
            if (context == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(2);
            }
            if (action == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(3);
            }
            Stream<Guard> descriptorGuard = Stream.of(JpsLibraryResolveGuard.getDescriptorGuard(context, descriptor));
            Stream<Guard> rootsGuards = roots.stream().map(rootFile -> Path.of(FileUtil.toCanonicalPath((String)rootFile.getAbsolutePath()), new String[0])).sorted().distinct().map(rootAbsolutePath -> JpsLibraryResolveGuard.getRootGuard(context, rootAbsolutePath));
            List guards = Stream.concat(descriptorGuard, rootsGuards).collect(Collectors.toList());
            int lockedGuardsCounter = 0;
            try {
                for (Guard guard : guards) {
                    if (!guard.requestProcessing(context.getCancelStatus())) {
                        return;
                    }
                    ++lockedGuardsCounter;
                }
                action.run();
            }
            finally {
                for (Guard guard : ContainerUtil.reverse(guards.subList(0, lockedGuardsCounter))) {
                    guard.finish();
                }
            }
        }

        private static Guard getDescriptorGuard(@NotNull CompileContext context, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor) {
            if (context == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(5);
            }
            Map map = (Map)context.getUserData(CONTEXT_KEY);
            assert (map != null);
            return map.computeIfAbsent(descriptor, ignored -> new Guard(true));
        }

        private static Guard getRootGuard(@NotNull CompileContext context, @NotNull Path rootPath) {
            if (context == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(6);
            }
            if (rootPath == null) {
                JpsLibraryResolveGuard.$$$reportNull$$$0(7);
            }
            Map map = (Map)context.getUserData(CONTEXT_KEY);
            assert (map != null);
            return map.computeIfAbsent(rootPath, ignored -> new Guard(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder$JpsLibraryResolveGuard";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performUnderGuard";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDescriptorGuard";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRootGuard";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class Guard {
            private static final byte INITIAL = 0;
            private static final byte PROGRESS = 1;
            private static final byte FINISHED = 2;
            private byte myState = 0;
            private final boolean mySingleProcessingGuard;

            private Guard(boolean isSingleProcessingGuard) {
                this.mySingleProcessingGuard = isSingleProcessingGuard;
            }

            private synchronized boolean requestProcessing(CanceledStatus canceledStatus) {
                if (canceledStatus.isCanceled()) {
                    return false;
                }
                if (this.myState == 0) {
                    this.myState = 1;
                    return true;
                }
                while (this.myState == 1 && !canceledStatus.isCanceled()) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.myState == 0 && !canceledStatus.isCanceled();
            }

            private synchronized void finish() {
                if (this.myState != 2) {
                    this.myState = (byte)(this.mySingleProcessingGuard ? 2 : 0);
                    this.notifyAll();
                }
            }
        }

        @FunctionalInterface
        private static interface ThrowingRunnable {
            public void run() throws Exception;
        }
    }

    private static class RemoteRepositoryNotFoundException
    extends ProjectBuildException {
        RemoteRepositoryNotFoundException(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String message) {
            if (message == null) {
                RemoteRepositoryNotFoundException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder$RemoteRepositoryNotFoundException", "<init>"));
        }
    }

    private static class ArtifactVerificationException
    extends ProjectBuildException {
        ArtifactVerificationException(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String message) {
            if (message == null) {
                ArtifactVerificationException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder$ArtifactVerificationException", "<init>"));
        }
    }
}

