/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.AddOrRemove;
import org.jitsi.jicofo.conference.ConferenceMetrics;
import org.jitsi.jicofo.conference.ConferenceUtilKt;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.conference.SourceSignaling;
import org.jitsi.jicofo.conference.SourcesToAddOrRemove;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.ValidationFailedException;
import org.jitsi.jicofo.conference.source.VideoType;
import org.jitsi.jicofo.util.Cancelable;
import org.jitsi.jicofo.util.RateLimit;
import org.jitsi.jicofo.xmpp.Features;
import org.jitsi.jicofo.xmpp.jingle.JingleIqRequestHandler;
import org.jitsi.jicofo.xmpp.jingle.JingleRequestHandler;
import org.jitsi.jicofo.xmpp.jingle.JingleSession;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.jicofo.xmpp.muc.SourceInfo;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeSessionPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.IceStatePacketExtension;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityFullJid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001^BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u00106\u001a\u00020\u0017J\u000e\u00107\u001a\u0002082\u0006\u00100\u001a\u000209J\b\u0010:\u001a\u00020 H\u0016J\u0006\u0010;\u001a\u00020\u0017J\u0006\u0010<\u001a\u00020\u0017J\u0006\u0010=\u001a\u00020\u0017J\u0006\u0010>\u001a\u00020\u0017J\u0006\u0010?\u001a\u00020\u0017J\u0006\u0010@\u001a\u00020\u0017J\u0006\u0010A\u001a\u00020\u0017J\u0006\u0010B\u001a\u00020\u0017J\u0006\u0010C\u001a\u00020\u0017J\u0006\u0010D\u001a\u00020\u0017J\u0006\u0010E\u001a\u00020\u0017J\u000e\u0010F\u001a\u0002082\u0006\u0010G\u001a\u00020\u001dJ\u0006\u0010H\u001a\u000208J\u0016\u0010I\u001a\u0002082\u0006\u0010J\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u0017J\u000e\u0010L\u001a\u0002082\u0006\u00100\u001a\u000209J\u000e\u0010M\u001a\u0002092\u0006\u00100\u001a\u000209J\b\u0010N\u001a\u000208H\u0002J\u0006\u0010O\u001a\u000208J\u0010\u0010P\u001a\u0002082\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0006\u0010Q\u001a\u00020\u0017J\u0006\u0010R\u001a\u00020\u0017J\u0006\u0010S\u001a\u00020\u0017J \u0010T\u001a\u0002082\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010\u00192\u0006\u0010X\u001a\u00020\u0017J\b\u0010Y\u001a\u00020\u0019H\u0016J\u0016\u0010Z\u001a\u00020\u00172\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u000bH\u0002J\u0006\u0010]\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0013\u00104\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001bR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/jitsi/jicofo/conference/Participant;", "", "chatMember", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "jingleIqRequestHandler", "Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "supportedFeatures", "", "Lorg/jitsi/jicofo/xmpp/Features;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;Lorg/jitsi/utils/logging2/Logger;Ljava/util/Set;Ljava/time/Clock;)V", "getChatMember", "()Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "desktopSourceIsMuted", "", "endpointId", "", "getEndpointId", "()Ljava/lang/String;", "inviteRunnable", "Lorg/jitsi/jicofo/util/Cancelable;", "inviteRunnableSyncRoot", "<set-?>", "Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "jingleSession", "getJingleSession", "()Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "logger", "mucJid", "Lorg/jxmpp/jid/EntityFullJid;", "getMucJid", "()Lorg/jxmpp/jid/EntityFullJid;", "restartRequestsRateLimit", "Lorg/jitsi/jicofo/util/RateLimit;", "signalQueuedSourcesTask", "Ljava/util/concurrent/ScheduledFuture;", "signalQueuedSourcesTaskSyncRoot", "sourceSignaling", "Lorg/jitsi/jicofo/conference/SourceSignaling;", "sources", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "getSources", "()Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "statId", "getStatId", "acceptRestartRequest", "addRemoteSources", "", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "createNewJingleSession", "hasAudioMuteSupport", "hasAudioSupport", "hasModeratorRights", "hasOpusRedSupport", "hasRembSupport", "hasRtxSupport", "hasSctpSupport", "hasSourceNameSupport", "hasSsrcRewritingSupport", "hasTccSupport", "hasVideoSupport", "inviteRunnableCompleted", "channelAllocator", "presenceChanged", "remoteDesktopSourceIsMutedChanged", "owner", "muted", "removeRemoteSources", "resetSignaledSources", "scheduleSignalingOfQueuedSources", "sendQueuedRemoteSources", "setInviteRunnable", "shouldSuppressForceMute", "supportsJsonEncodedSources", "supportsReceivingMultipleVideoStreams", "terminateJingleSession", "reason", "Lorg/jitsi/xmpp/extensions/jingle/Reason;", "message", "sendIq", "toString", "updateDesktopSourceIsMuted", "sourceInfos", "Lorg/jitsi/jicofo/xmpp/muc/SourceInfo;", "useSsrcRewriting", "JingleRequestHandlerImpl", "jicofo"})
public class Participant {
    @NotNull
    private final ChatRoomMember chatMember;
    @NotNull
    private final JitsiMeetConferenceImpl conference;
    @NotNull
    private final JingleIqRequestHandler jingleIqRequestHandler;
    @NotNull
    private final Set<Features> supportedFeatures;
    @NotNull
    private final String endpointId;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SourceSignaling sourceSignaling;
    @NotNull
    private final Object inviteRunnableSyncRoot;
    @Nullable
    private Cancelable inviteRunnable;
    @NotNull
    private final RateLimit restartRequestsRateLimit;
    @Nullable
    private JingleSession jingleSession;
    @Nullable
    private ScheduledFuture<?> signalQueuedSourcesTask;
    @NotNull
    private final Object signalQueuedSourcesTaskSyncRoot;
    private boolean desktopSourceIsMuted;
    @NotNull
    private final EntityFullJid mucJid;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @Nullable Logger parentLogger, @NotNull Set<? extends Features> supportedFeatures, @NotNull Clock clock) {
        void $this$logger_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(chatMember, "chatMember");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(jingleIqRequestHandler, "jingleIqRequestHandler");
        Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.chatMember = chatMember;
        this.conference = conference;
        this.jingleIqRequestHandler = jingleIqRequestHandler;
        this.supportedFeatures = supportedFeatures;
        this.endpointId = this.chatMember.getName();
        Logger logger = parentLogger;
        Logger logger2 = logger != null ? logger.createChildLogger("javaClass") : null;
        Logger logger3 = logger2 = logger2 == null ? (Logger)new LoggerImpl("javaClass") : logger2;
        Participant participant = this;
        boolean bl = false;
        $this$logger_u24lambda_u2d0.addContext("participant", this.endpointId);
        participant.logger = logger2;
        this.sourceSignaling = new SourceSignaling(this.hasAudioSupport(), this.hasVideoSupport(), ConferenceConfig.config.stripSimulcast(), this.supportsReceivingMultipleVideoStreams() || !ConferenceConfig.config.getMultiStreamBackwardCompat());
        this.inviteRunnableSyncRoot = new Object();
        this.restartRequestsRateLimit = new RateLimit(null, 0, null, clock, 7, null);
        this.signalQueuedSourcesTaskSyncRoot = new Object();
        this.updateDesktopSourceIsMuted(this.chatMember.getSourceInfos());
        this.mucJid = this.chatMember.getOccupantJid();
    }

    public /* synthetic */ Participant(ChatRoomMember chatRoomMember, JitsiMeetConferenceImpl jitsiMeetConferenceImpl, JingleIqRequestHandler jingleIqRequestHandler, Logger logger, Set set, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            logger = null;
        }
        if ((n & 0x10) != 0) {
            set = Features.Companion.getDefaultFeatures();
        }
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(chatRoomMember, jitsiMeetConferenceImpl, jingleIqRequestHandler, logger, set, clock);
    }

    @NotNull
    public final ChatRoomMember getChatMember() {
        return this.chatMember;
    }

    @NotNull
    public final String getEndpointId() {
        return this.endpointId;
    }

    public final void terminateJingleSession(@NotNull Reason reason, @Nullable String message, boolean sendIq) {
        Intrinsics.checkNotNullParameter((Object)reason, "reason");
        JingleSession jingleSession = this.jingleSession;
        if (jingleSession != null) {
            jingleSession.terminate(reason, message, sendIq);
        }
        this.jingleSession = null;
    }

    @Nullable
    public final JingleSession getJingleSession() {
        return this.jingleSession;
    }

    public final void presenceChanged() {
        if (this.updateDesktopSourceIsMuted(this.chatMember.getSourceInfos())) {
            this.conference.desktopSourceIsMutedChanged(this, this.desktopSourceIsMuted);
        }
    }

    private final boolean updateDesktopSourceIsMuted(Set<SourceInfo> sourceInfos) {
        boolean newValue;
        block4: {
            boolean bl;
            Iterable $this$any$iv = sourceInfos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SourceInfo sourceInfo = (SourceInfo)element$iv;
                    boolean bl2 = false;
                    boolean muted = sourceInfo.component2();
                    VideoType videoType = sourceInfo.component3();
                    if (!(videoType == VideoType.Desktop && muted)) continue;
                    bl = true;
                    break block4;
                }
                bl = newValue = false;
            }
        }
        if (this.desktopSourceIsMuted != newValue) {
            this.desktopSourceIsMuted = newValue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remoteDesktopSourceIsMutedChanged(@NotNull String owner, boolean muted) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        if (this.supportsReceivingMultipleVideoStreams()) {
            return;
        }
        this.sourceSignaling.remoteDesktopSourceIsMutedChanged(owner, muted);
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            boolean bl = false;
            this.scheduleSignalingOfQueuedSources();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInviteRunnable(@Nullable Cancelable inviteRunnable) {
        Object object = this.inviteRunnableSyncRoot;
        synchronized (object) {
            boolean bl = false;
            Cancelable cancelable = this.inviteRunnable;
            if (cancelable != null) {
                Cancelable it = cancelable;
                boolean bl2 = false;
                this.logger.warn("Canceling " + it);
                it.cancel();
            }
            this.inviteRunnable = inviteRunnable;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void inviteRunnableCompleted(@NotNull Cancelable channelAllocator) {
        Intrinsics.checkNotNullParameter(channelAllocator, "channelAllocator");
        Object object = this.inviteRunnableSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (this.inviteRunnable == channelAllocator) {
                this.inviteRunnable = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean hasSourceNameSupport() {
        return this.supportedFeatures.contains((Object)Features.SOURCE_NAMES);
    }

    public final boolean hasSsrcRewritingSupport() {
        return this.supportedFeatures.contains((Object)Features.SSRC_REWRITING_V1);
    }

    public final boolean useSsrcRewriting() {
        return ConferenceConfig.config.getUseSsrcRewriting() && this.hasSsrcRewritingSupport();
    }

    public final boolean supportsJsonEncodedSources() {
        return this.supportedFeatures.contains((Object)Features.JSON_SOURCES);
    }

    public final boolean supportsReceivingMultipleVideoStreams() {
        return this.supportedFeatures.contains((Object)Features.RECEIVE_MULTIPLE_STREAMS);
    }

    public final boolean hasRembSupport() {
        return this.supportedFeatures.contains((Object)Features.REMB);
    }

    public final boolean hasTccSupport() {
        return this.supportedFeatures.contains((Object)Features.TCC);
    }

    public final boolean hasRtxSupport() {
        return this.supportedFeatures.contains((Object)Features.RTX);
    }

    public final boolean hasOpusRedSupport() {
        return this.supportedFeatures.contains((Object)Features.OPUS_RED);
    }

    public final boolean hasAudioSupport() {
        return this.supportedFeatures.contains((Object)Features.AUDIO);
    }

    public final boolean hasVideoSupport() {
        return this.supportedFeatures.contains((Object)Features.VIDEO);
    }

    public final boolean hasAudioMuteSupport() {
        return this.supportedFeatures.contains((Object)Features.AUDIO_MUTE);
    }

    public final boolean hasSctpSupport() {
        return this.supportedFeatures.contains((Object)Features.SCTP);
    }

    public final boolean acceptRestartRequest() {
        return this.restartRequestsRateLimit.accept();
    }

    @Nullable
    public final String getStatId() {
        return this.chatMember.getStatsId();
    }

    @NotNull
    public final EntityFullJid getMucJid() {
        return this.mucJid;
    }

    @NotNull
    public final EndpointSourceSet getSources() {
        EndpointSourceSet endpointSourceSet = this.conference.getSourcesForParticipant(this);
        Intrinsics.checkNotNullExpressionValue(endpointSourceSet, "conference.getSourcesForParticipant(this)");
        return endpointSourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRemoteSources(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        if (this.useSsrcRewriting()) {
            return;
        }
        Object object = this.sourceSignaling;
        synchronized (object) {
            boolean $i$a$-synchronized-Participant$addRemoteSources$32 = false;
            this.sourceSignaling.addSources(sources);
            Unit $i$a$-synchronized-Participant$addRemoteSources$32 = Unit.INSTANCE;
        }
        JingleSession jingleSession = this.jingleSession;
        boolean bl = jingleSession != null ? jingleSession.isActive() : false;
        if (bl) {
            object = this.signalQueuedSourcesTaskSyncRoot;
            synchronized (object) {
                boolean bl2 = false;
                this.scheduleSignalingOfQueuedSources();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ConferenceSourceMap resetSignaledSources(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        SourceSignaling sourceSignaling = this.sourceSignaling;
        synchronized (sourceSignaling) {
            boolean bl = false;
            ConferenceSourceMap conferenceSourceMap = this.sourceSignaling.reset(sources);
            return conferenceSourceMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleSignalingOfQueuedSources() {
        int delayMs = ConferenceConfig.config.getSourceSignalingDelayMs(this.conference.getParticipantCount());
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (this.signalQueuedSourcesTask == null) {
                this.logger.debug("Scheduling a task to signal queued remote sources after " + delayMs + " ms.");
                this.signalQueuedSourcesTask = TaskPools.Companion.getScheduledPool().schedule(() -> Participant.scheduleSignalingOfQueuedSources$lambda-11$lambda-10(this), (long)delayMs, TimeUnit.MILLISECONDS);
                ScheduledFuture<?> scheduledFuture = this.signalQueuedSourcesTask;
                boolean bl2 = scheduledFuture != null ? scheduledFuture.isDone() : false;
                if (bl2) {
                    this.signalQueuedSourcesTask = null;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRemoteSources(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        if (this.useSsrcRewriting()) {
            return;
        }
        Object object = this.sourceSignaling;
        synchronized (object) {
            boolean $i$a$-synchronized-Participant$removeRemoteSources$32 = false;
            this.sourceSignaling.removeSources(sources);
            Unit $i$a$-synchronized-Participant$removeRemoteSources$32 = Unit.INSTANCE;
        }
        JingleSession jingleSession = this.jingleSession;
        boolean bl = jingleSession != null ? jingleSession.isActive() : false;
        if (bl) {
            object = this.signalQueuedSourcesTaskSyncRoot;
            synchronized (object) {
                boolean bl2 = false;
                this.scheduleSignalingOfQueuedSources();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendQueuedRemoteSources() {
        JingleSession jingleSession;
        JingleSession jingleSession2 = jingleSession = this.jingleSession;
        if (!(jingleSession2 != null ? jingleSession2.isActive() : false)) {
            this.logger.warn("Can not signal remote sources, Jingle session not established.");
            return;
        }
        List<SourcesToAddOrRemove> modifiedSources = null;
        SourceSignaling object2 = this.sourceSignaling;
        synchronized (object2) {
            boolean $i$a$-synchronized-Participant$sendQueuedRemoteSources$232 = false;
            modifiedSources = this.sourceSignaling.update();
            Unit $i$a$-synchronized-Participant$sendQueuedRemoteSources$232 = Unit.INSTANCE;
        }
        for (SourcesToAddOrRemove sourcesToAddOrRemove : modifiedSources) {
            AddOrRemove action = sourcesToAddOrRemove.component1();
            ConferenceSourceMap sources = sourcesToAddOrRemove.component2();
            String string = action.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.logger.info("Sending a queued source-" + string + ", sources=" + sources);
            if (action == AddOrRemove.Add) {
                jingleSession.addSource(sources);
                continue;
            }
            if (action != AddOrRemove.Remove) continue;
            jingleSession.removeSource(sources);
        }
    }

    public final boolean shouldSuppressForceMute() {
        return this.chatMember.isJigasi() && !this.hasAudioMuteSupport() || this.chatMember.isJibri();
    }

    public final boolean hasModeratorRights() {
        return MemberRoleKt.hasModeratorRights(this.chatMember.getRole());
    }

    @NotNull
    public String toString() {
        return "Participant[" + this.mucJid + "]";
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u2d15 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u2d15).put("id", this.endpointId);
        ((Map)$this$_get_debugState__u24lambda_u2d15).put("source_signaling", this.sourceSignaling.getDebugState());
        ((Map)$this$_get_debugState__u24lambda_u2d15).put("invite_runnable", this.inviteRunnable != null ? "Running" : "Not running");
        Map map = $this$_get_debugState__u24lambda_u2d15;
        String string = "jingle_session";
        Object object = this.jingleSession;
        if (object == null || (object = ((JingleSession)object).debugState()) == null) {
            object = "null";
        }
        Object object2 = object;
        map.put(string, object2);
        ((Map)$this$_get_debugState__u24lambda_u2d15).put("chatMember", this.chatMember.getDebugState());
        return orderedJsonObject;
    }

    @NotNull
    public JingleSession createNewJingleSession() {
        JingleSession jingleSession;
        JingleSession jingleSession2 = this.jingleSession;
        if (jingleSession2 != null) {
            JingleSession it = jingleSession2;
            boolean bl = false;
            this.logger.info("Terminating existing jingle session");
            it.terminate(Reason.UNDEFINED, null, false);
        }
        String string = JingleIQ.generateSID();
        Intrinsics.checkNotNullExpressionValue(string, "generateSID()");
        JingleSession it = jingleSession = new JingleSession(string, this.mucJid, this.jingleIqRequestHandler, this.chatMember.getChatRoom().getXmppProvider().getXmppConnection(), new JingleRequestHandlerImpl(), ConferenceConfig.config.getUseJsonEncodedSources() && this.supportsJsonEncodedSources());
        boolean bl = false;
        this.jingleSession = it;
        return jingleSession;
    }

    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @Nullable Logger parentLogger, @NotNull Set<? extends Features> supportedFeatures) {
        Intrinsics.checkNotNullParameter(chatMember, "chatMember");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(jingleIqRequestHandler, "jingleIqRequestHandler");
        Intrinsics.checkNotNullParameter(supportedFeatures, "supportedFeatures");
        this(chatMember, conference, jingleIqRequestHandler, parentLogger, supportedFeatures, null, 32, null);
    }

    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @Nullable Logger parentLogger) {
        Intrinsics.checkNotNullParameter(chatMember, "chatMember");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(jingleIqRequestHandler, "jingleIqRequestHandler");
        this(chatMember, conference, jingleIqRequestHandler, parentLogger, null, null, 48, null);
    }

    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler) {
        Intrinsics.checkNotNullParameter(chatMember, "chatMember");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(jingleIqRequestHandler, "jingleIqRequestHandler");
        this(chatMember, conference, jingleIqRequestHandler, null, null, null, 56, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleSignalingOfQueuedSources$lambda-11$lambda-10(Participant this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Object object = this$0.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            boolean bl = false;
            this$0.sendQueuedRemoteSources();
            this$0.signalQueuedSourcesTask = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/jicofo/conference/Participant$JingleRequestHandlerImpl;", "Lorg/jitsi/jicofo/xmpp/jingle/JingleRequestHandler;", "(Lorg/jitsi/jicofo/conference/Participant;)V", "checkJingleSession", "Lorg/jivesoftware/smack/packet/StanzaError;", "jingleSession", "Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "onAddSource", "contents", "", "Lorg/jitsi/xmpp/extensions/jingle/ContentPacketExtension;", "onRemoveSource", "onSessionAccept", "onSessionInfo", "iq", "Lorg/jitsi/xmpp/extensions/jingle/JingleIQ;", "onSessionOrTransportAccept", "action", "Lorg/jitsi/xmpp/extensions/jingle/JingleAction;", "onSessionTerminate", "onTransportAccept", "onTransportInfo", "onTransportReject", "", "jicofo"})
    private final class JingleRequestHandlerImpl
    implements JingleRequestHandler {
        private final StanzaError checkJingleSession(JingleSession jingleSession) {
            return !Intrinsics.areEqual(Participant.this.getJingleSession(), jingleSession) ? StanzaError.from(StanzaError.Condition.item_not_found, "jingle session no longer active").build() : null;
        }

        @Override
        @Nullable
        public StanzaError onAddSource(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(contents, "contents");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            if (Participant.this.getChatMember().getRole() == MemberRole.VISITOR) {
                return StanzaError.from(StanzaError.Condition.forbidden, "add-source not allowed for visitors").build();
            }
            EndpointSourceSet sourcesAdvertised = EndpointSourceSet.Companion.fromJingle(contents);
            Participant.this.logger.debug(() -> JingleRequestHandlerImpl.onAddSource$lambda-1(sourcesAdvertised));
            if (sourcesAdvertised.isEmpty()) {
                Participant.this.logger.warn("Received source-add with empty sources, ignoring");
                return null;
            }
            try {
                Participant.this.conference.addSource(Participant.this, sourcesAdvertised);
            }
            catch (JitsiMeetConferenceImpl.SenderCountExceededException e) {
                Participant.this.logger.warn("Rejecting source-add: " + e.getMessage());
                return StanzaError.from(StanzaError.Condition.resource_constraint, e.getMessage()).build();
            }
            catch (ValidationFailedException e) {
                Participant.this.logger.warn("Rejecting source-add: " + e.getMessage());
                return StanzaError.from(StanzaError.Condition.bad_request, e.getMessage()).build();
            }
            return null;
        }

        @Override
        @Nullable
        public StanzaError onRemoveSource(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(contents, "contents");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            EndpointSourceSet sources = EndpointSourceSet.Companion.fromJingle(contents);
            if (sources.isEmpty()) {
                Participant.this.logger.info("Ignoring source-remove with no sources specified.");
                return null;
            }
            try {
                Participant.this.conference.removeSources(Participant.this, sources);
            }
            catch (ValidationFailedException e) {
                return StanzaError.from(StanzaError.Condition.bad_request, e.getMessage()).build();
            }
            return null;
        }

        @Override
        @Nullable
        public StanzaError onSessionAccept(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(contents, "contents");
            return this.onSessionOrTransportAccept(jingleSession, contents, JingleAction.SESSION_ACCEPT);
        }

        private final StanzaError onSessionOrTransportAccept(JingleSession jingleSession, List<? extends ContentPacketExtension> contents, JingleAction action) {
            if (Participant.this.getJingleSession() != null && !Intrinsics.areEqual(Participant.this.getJingleSession(), jingleSession)) {
                Participant.this.logger.error("Rejecting " + action + " for a session that has been replaced.");
                return StanzaError.from(StanzaError.Condition.gone, "session has been replaced").build();
            }
            Participant.this.logger.info("Received " + action);
            EndpointSourceSet sourcesAdvertised = EndpointSourceSet.Companion.fromJingle(contents);
            if (!sourcesAdvertised.isEmpty() && Participant.this.getChatMember().getRole() == MemberRole.VISITOR) {
                return StanzaError.from(StanzaError.Condition.forbidden, "sources not allowed for visitors").build();
            }
            try {
                Participant.this.conference.acceptSession(Participant.this, sourcesAdvertised, ConferenceUtilKt.getTransport(contents));
            }
            catch (ValidationFailedException e) {
                return StanzaError.from(StanzaError.Condition.bad_request, e.getMessage()).build();
            }
            return null;
        }

        @Override
        @Nullable
        public StanzaError onSessionInfo(@NotNull JingleSession jingleSession, @NotNull JingleIQ iq) {
            String iceState;
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(iq, "iq");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            IceStatePacketExtension iceStatePacketExtension = iq.getExtension(IceStatePacketExtension.class);
            String string = iceState = iceStatePacketExtension != null ? iceStatePacketExtension.getText() : null;
            if (!StringsKt.equals(iceState, "failed", true)) {
                Participant.this.logger.info("Ignored unknown ice-state: " + iceState);
                return null;
            }
            ConferenceMetrics.participantsIceFailed.inc();
            BridgeSessionPacketExtension bridgeSessionPacketExtension = iq.getExtension(BridgeSessionPacketExtension.class);
            String bridgeSessionId = bridgeSessionPacketExtension != null ? bridgeSessionPacketExtension.getId() : null;
            Participant.this.conference.iceFailed(Participant.this, bridgeSessionId);
            return null;
        }

        @Override
        @Nullable
        public StanzaError onSessionTerminate(@NotNull JingleSession jingleSession, @NotNull JingleIQ iq) {
            String bridgeSessionId;
            BridgeSessionPacketExtension bridgeSessionPacketExtension;
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(iq, "iq");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            BridgeSessionPacketExtension bridgeSessionPacketExtension2 = bridgeSessionPacketExtension = iq.getExtension(BridgeSessionPacketExtension.class);
            Boolean bl = bridgeSessionPacketExtension2 != null ? bridgeSessionPacketExtension2.isRestart() : null;
            boolean restartRequested = bl == null ? false : bl;
            BridgeSessionPacketExtension bridgeSessionPacketExtension3 = bridgeSessionPacketExtension;
            String string = bridgeSessionId = bridgeSessionPacketExtension3 != null ? bridgeSessionPacketExtension3.getId() : null;
            if (restartRequested) {
                ConferenceMetrics.participantsRequestedRestart.inc();
            }
            boolean reinvite = restartRequested && Participant.this.acceptRestartRequest();
            Participant.this.logger.info("Received session-terminate, bsId=" + bridgeSessionId + ", restartRequested=" + restartRequested);
            try {
                BridgeSessionPacketExtension bridgeSessionPacketExtension4 = bridgeSessionPacketExtension;
                Participant.this.conference.terminateSession(Participant.this, bridgeSessionPacketExtension4 != null ? bridgeSessionPacketExtension4.getId() : null, reinvite);
            }
            catch (JitsiMeetConferenceImpl.InvalidBridgeSessionIdException e) {
                return StanzaError.from(StanzaError.Condition.item_not_found, e.getMessage()).build();
            }
            if (restartRequested && !reinvite) {
                Participant.this.logger.warn("Rate limiting restart request.");
                return StanzaError.from(StanzaError.Condition.resource_constraint, "rate-limited").build();
            }
            return null;
        }

        @Override
        @Nullable
        public StanzaError onTransportInfo(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(contents, "contents");
            Participant.this.logger.info("Received transport-info");
            if (Participant.this.getChatMember().isJigasi()) {
                if (Participant.this.getJingleSession() != null && !Intrinsics.areEqual(Participant.this.getJingleSession(), jingleSession)) {
                    Participant.this.logger.warn("Accepting transport-info for a different (new?) jingle session");
                }
            } else {
                StanzaError stanzaError = this.checkJingleSession(jingleSession);
                if (stanzaError != null) {
                    StanzaError stanzaError2 = stanzaError;
                    Participant participant = Participant.this;
                    StanzaError it = stanzaError2;
                    boolean bl = false;
                    participant.logger.warn("Received an early or stale transport-info from non-jigasi.");
                }
            }
            IceUdpTransportPacketExtension iceUdpTransportPacketExtension = ConferenceUtilKt.getTransport(contents);
            if (iceUdpTransportPacketExtension == null) {
                return StanzaError.from(StanzaError.Condition.bad_request, "missing transport").build();
            }
            IceUdpTransportPacketExtension transport = iceUdpTransportPacketExtension;
            Participant.this.conference.updateTransport(Participant.this, transport);
            return null;
        }

        @Override
        @Nullable
        public StanzaError onTransportAccept(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(contents, "contents");
            return this.onSessionOrTransportAccept(jingleSession, contents, JingleAction.TRANSPORT_ACCEPT);
        }

        @Override
        public void onTransportReject(@NotNull JingleSession jingleSession, @NotNull JingleIQ iq) {
            Intrinsics.checkNotNullParameter(jingleSession, "jingleSession");
            Intrinsics.checkNotNullParameter(iq, "iq");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return;
            }
            Participant.this.logger.warn("Received transport-reject: " + iq.toXML());
        }

        private static final String onAddSource$lambda-1(EndpointSourceSet $sourcesAdvertised) {
            Intrinsics.checkNotNullParameter($sourcesAdvertised, "$sourcesAdvertised");
            return "Received source-add: " + $sourcesAdvertised;
        }
    }
}

