/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.videobridge.ReceiveSsrc;
import org.jitsi.videobridge.RtpState;
import org.jitsi.videobridge.SsrcCacheKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/videobridge/SendSsrc;", "", "ssrc", "", "(J)V", "sequenceNumberDelta", "", "getSsrc", "()J", "state", "Lorg/jitsi/videobridge/RtpState;", "timestampDelta", "tl0IndexDelta", "rewriteRtcp", "", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "rewriteRtp", "Lorg/jitsi/rtp/rtp/RtpPacket;", "sending", "", "recv", "Lorg/jitsi/videobridge/ReceiveSsrc;", "toString", "", "jitsi-videobridge"})
public final class SendSsrc {
    private final long ssrc;
    @NotNull
    private final RtpState state;
    private int sequenceNumberDelta;
    private long timestampDelta;
    private int tl0IndexDelta;

    public SendSsrc(long ssrc2) {
        this.ssrc = ssrc2;
        this.state = new RtpState();
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final void rewriteRtp(@NotNull RtpPacket packet, boolean sending, @NotNull ReceiveSsrc recv) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(recv, "recv");
        if (sending) {
            int tl0Index = SsrcCacheKt.access$getTl0Index(packet);
            if (!recv.getHasDeltas()) {
                if (this.state.getValid()) {
                    if (recv.getState().getValid()) {
                        this.sequenceNumberDelta = RtpUtils.Companion.getSequenceNumberDelta(this.state.getLastSequenceNumber(), recv.getState().getLastSequenceNumber());
                        this.timestampDelta = RtpUtils.Companion.getTimestampDiff(this.state.getLastTimestamp(), recv.getState().getLastTimestamp());
                        this.tl0IndexDelta = this.state.getLastTl0Index() != -1 && recv.getState().getLastTl0Index() != 1 ? SsrcCacheKt.access$byteMinus(this.state.getLastTl0Index(), recv.getState().getLastTl0Index()) : 0;
                    } else {
                        int prevSequenceNumber = RtpUtils.Companion.applySequenceNumberDelta(packet.getSequenceNumber(), -1);
                        long prevTimestamp = RtpUtils.Companion.applyTimestampDelta(packet.getTimestamp(), -960L);
                        this.sequenceNumberDelta = RtpUtils.Companion.getSequenceNumberDelta(this.state.getLastSequenceNumber(), prevSequenceNumber);
                        this.timestampDelta = RtpUtils.Companion.getTimestampDiff(this.state.getLastTimestamp(), prevTimestamp);
                        this.tl0IndexDelta = this.state.getLastTl0Index() != -1 && tl0Index != -1 ? SsrcCacheKt.access$byteMinus(this.state.getLastTl0Index(), tl0Index - 1) : 0;
                    }
                }
                recv.setHasDeltas(true);
            }
            recv.getState().update(packet);
            packet.setSsrc(this.ssrc);
            packet.setSequenceNumber(RtpUtils.Companion.applySequenceNumberDelta(packet.getSequenceNumber(), this.sequenceNumberDelta));
            packet.setTimestamp(RtpUtils.Companion.applyTimestampDelta(packet.getTimestamp(), this.timestampDelta));
            if (tl0Index != -1) {
                SsrcCacheKt.access$setTl0Index(packet, SsrcCacheKt.access$bytePlus(tl0Index, this.tl0IndexDelta));
            }
            this.state.update(packet);
        } else {
            recv.getState().update(packet);
        }
    }

    public final void rewriteRtcp(@NotNull RtcpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        packet.setSenderSsrc(this.ssrc);
        if (packet instanceof RtcpSrPacket) {
            ((RtcpSrPacket)packet).getSenderInfo().setRtpTimestamp(RtpUtils.Companion.applyTimestampDelta(((RtcpSrPacket)packet).getSenderInfo().getRtpTimestamp(), this.timestampDelta));
        }
    }

    @NotNull
    public String toString() {
        return this.ssrc + "{" + this.state + ",\u2206=" + this.sequenceNumberDelta + "/" + this.timestampDelta + "/" + this.tl0IndexDelta + "}";
    }
}

