/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.websocket;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.jitsi.utils.logging2.LogContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class ColibriWebSocket
extends WebSocketAdapter {
    private final Logger logger;
    private final EventHandler eventHandler;

    public ColibriWebSocket(String id, EventHandler eventHandler) {
        this.logger = new LoggerImpl(this.getClass().getName(), new LogContext(Map.of("id", id)));
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
    }

    @Override
    public void onWebSocketText(String message) {
        this.logger.debug(() -> "Received text: " + message);
        this.eventHandler.webSocketTextReceived(this, message);
    }

    @Override
    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        this.eventHandler.webSocketConnected(this);
    }

    @Override
    public void onWebSocketClose(int statusCode, String reason2) {
        this.eventHandler.webSocketClosed(this, statusCode, reason2);
    }

    @Override
    public void onWebSocketError(Throwable cause) {
        this.eventHandler.webSocketError(this, cause);
    }

    public static interface EventHandler {
        public void webSocketClosed(ColibriWebSocket var1, int var2, String var3);

        public void webSocketConnected(ColibriWebSocket var1);

        public void webSocketTextReceived(ColibriWebSocket var1, String var2);

        public void webSocketError(ColibriWebSocket var1, Throwable var2);
    }
}

