/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.stats.DelayStats;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.stats.BucketStats;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;
import org.jitsi.xmpp.extensions.colibri.ForcefulShutdownIQ;
import org.jitsi.xmpp.extensions.colibri.GracefulShutdownIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.health.HealthCheckIQ;
import org.jitsi.xmpp.mucclient.IQListener;
import org.jitsi.xmpp.mucclient.MucClient;
import org.jitsi.xmpp.mucclient.MucClientConfiguration;
import org.jitsi.xmpp.mucclient.MucClientManager;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 32\u00020\u0001:\u0003234B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J7\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001e0\"H\u0002\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020(J\u0006\u0010,\u001a\u00020(J\u0014\u0010-\u001a\u00020\u0012*\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u0014\u00100\u001a\u00020\u0018*\u00020\u00182\u0006\u00101\u001a\u00020\u0018H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection;", "Lorg/jitsi/xmpp/mucclient/IQListener;", "()V", "eventHandler", "Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;", "getEventHandler", "()Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;", "setEventHandler", "(Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "mucClientManager", "Lorg/jitsi/xmpp/mucclient/MucClientManager;", "getMucClientManager", "()Lorg/jitsi/xmpp/mucclient/MucClientManager;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addMucClient", "", "jsonObject", "Lorg/json/simple/JSONObject;", "getMucClientIds", "", "handleIq", "Lorg/jivesoftware/smack/packet/IQ;", "iq", "mucClient", "Lorg/jitsi/xmpp/mucclient/MucClient;", "handleIqRequest", "measureDelay", "T", "delayStats", "Lorg/jitsi/nlj/stats/DelayStats;", "context", "Lkotlin/Function0;", "", "block", "(Lorg/jitsi/nlj/stats/DelayStats;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "removeMucClient", "setPresenceExtension", "", "extension", "Lorg/jivesoftware/smack/packet/ExtensionElement;", "start", "stop", "matches", "Lorg/jitsi/xmpp/mucclient/MucClientConfiguration;", "other", "setResponseTo", "request", "ColibriRequest", "Companion", "EventHandler", "jitsi-videobridge"})
public final class XmppConnection
implements IQListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    @NotNull
    private final MucClientManager mucClientManager = new MucClientManager(FEATURES);
    @NotNull
    private final AtomicBoolean running = new AtomicBoolean(false);
    @Nullable
    private EventHandler eventHandler;
    @NotNull
    private static final String[] FEATURES;
    @NotNull
    private static final List<Long> delayThresholds;
    @NotNull
    private static final DelayStats colibriProcessingDelayStats;
    @NotNull
    private static final DelayStats colibriDelayStats;
    @NotNull
    private static final DelayStats healthDelayStats;
    @NotNull
    private static final DelayStats versionDelayStats;

    @NotNull
    public final MucClientManager getMucClientManager() {
        return this.mucClientManager;
    }

    @Nullable
    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public final void setEventHandler(@Nullable EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final void start() {
        if (this.running.compareAndSet(false, true)) {
            MucClientManager mucClientManager;
            MucClientManager $this$start_u24lambda_u2d0 = mucClientManager = this.mucClientManager;
            boolean bl = false;
            $this$start_u24lambda_u2d0.registerIQ(new HealthCheckIQ());
            $this$start_u24lambda_u2d0.registerIQ(new Version());
            $this$start_u24lambda_u2d0.registerIQ(new ForcefulShutdownIQ());
            $this$start_u24lambda_u2d0.registerIQ(new GracefulShutdownIQ());
            $this$start_u24lambda_u2d0.registerIQ("conference-modify", "jitsi:colibri2", false);
            $this$start_u24lambda_u2d0.setIQListener(this);
            Iterable $this$forEach$iv = XmppClientConnectionConfig.config.getClientConfigs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MucClientConfiguration cfg = (MucClientConfiguration)element$iv;
                boolean bl2 = false;
                this.mucClientManager.addMucClient(cfg);
            }
        } else {
            this.logger.info("Already started");
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.mucClientManager.stop();
        }
    }

    public final void setPresenceExtension(@NotNull ExtensionElement extension) {
        Intrinsics.checkNotNullParameter(extension, "extension");
        this.mucClientManager.setPresenceExtension(extension);
    }

    public final boolean addMucClient(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        if (!(jsonObject.get("id") instanceof String)) {
            return false;
        }
        Object v = jsonObject.get("id");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        MucClientConfiguration config = new MucClientConfiguration((String)v);
        for (Object key : jsonObject.keySet()) {
            Object value2 = jsonObject.get(key);
            if (!(key instanceof String) || !(value2 instanceof String) || Intrinsics.areEqual(key, "id")) continue;
            config.setProperty((String)key, (String)value2);
        }
        if (!config.isComplete()) {
            this.logger.info("Not adding a MucClient, configuration incomplete.");
            return false;
        }
        MucClient mucClient = this.mucClientManager.getMucClient(config.getId());
        if (mucClient != null) {
            MucClient existingMucClient = mucClient;
            boolean bl = false;
            MucClientConfiguration mucClientConfiguration = existingMucClient.getConfig();
            Intrinsics.checkNotNullExpressionValue(mucClientConfiguration, "existingMucClient.config");
            if (!this.matches(mucClientConfiguration, config)) {
                this.logger.warn("Config for " + config.getId() + " has changed, removing the old MucClient. Existing config=" + existingMucClient.getConfig() + ", new config=" + config);
                this.mucClientManager.removeMucClient(config.getId());
            } else {
                this.logger.info("Ignoring request to add a MucClient that matches an existing one. Existing config=" + existingMucClient.getConfig() + ", new config=" + config);
            }
        }
        this.mucClientManager.addMucClient(config);
        return true;
    }

    private final boolean matches(MucClientConfiguration $this$matches, MucClientConfiguration other) {
        return Intrinsics.areEqual($this$matches.getHostname(), other.getHostname()) && Intrinsics.areEqual($this$matches.getPort(), other.getPort()) && Intrinsics.areEqual($this$matches.getDomain(), other.getDomain()) && Intrinsics.areEqual($this$matches.getUsername(), other.getUsername());
    }

    @NotNull
    public final String getMucClientIds() {
        JSONArray jSONArray;
        JSONArray $this$getMucClientIds_u24lambda_u2d3 = jSONArray = new JSONArray();
        boolean bl = false;
        $this$getMucClientIds_u24lambda_u2d3.addAll((Collection)this.mucClientManager.getMucClientIds());
        String string = jSONArray.toJSONString();
        Intrinsics.checkNotNullExpressionValue(string, "JSONArray().apply { addA\u2026ientIds) }.toJSONString()");
        return string;
    }

    public final boolean removeMucClient(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        if (!(jsonObject.get("id") instanceof String)) {
            return false;
        }
        Object v = jsonObject.get("id");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return this.mucClientManager.removeMucClient((String)v);
    }

    @Override
    @Nullable
    public IQ handleIq(@Nullable IQ iq, @NotNull MucClient mucClient) {
        IQ iQ;
        Intrinsics.checkNotNullParameter(mucClient, "mucClient");
        if (iq == null) {
            return null;
        }
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("RECV: " + iq.toXML());
        }
        IQ.Type type2 = iq.getType();
        switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: 
            case 2: {
                IQ iQ2 = this.handleIqRequest(iq, mucClient);
                if (iQ2 != null) {
                    IQ iQ3;
                    IQ it = iQ3 = iQ2;
                    boolean bl = false;
                    Logger $this$cdebug$iv2 = this.logger;
                    boolean $i$f$cdebug2 = false;
                    if ($this$cdebug$iv2.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv2;
                        boolean bl2 = false;
                        logger.debug("SENT: " + it.toXML());
                    }
                    iQ = iQ3;
                    break;
                }
                iQ = null;
                break;
            }
            default: {
                iQ = null;
            }
        }
        return iQ;
    }

    private final IQ handleIqRequest(IQ iq, MucClient mucClient) {
        IQ response2;
        IQ iQ;
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler == null) {
            return ErrorUtilKt.createError$default(iq, StanzaError.Condition.service_unavailable, "Service unavailable", null, 8, null);
        }
        EventHandler handler = eventHandler;
        IQ iQ2 = iq;
        if (iQ2 instanceof Version) {
            iQ = (IQ)this.measureDelay(versionDelayStats, (Function0<? extends CharSequence>)new Function0<CharSequence>(iq){
                final /* synthetic */ IQ $iq;
                {
                    this.$iq = $iq;
                    super(0);
                }

                @NotNull
                public final CharSequence invoke() {
                    CharSequence charSequence = this.$iq.toXML();
                    Intrinsics.checkNotNullExpressionValue(charSequence, "iq.toXML()");
                    return charSequence;
                }
            }, (Function0)new Function0<IQ>(handler, iq){
                final /* synthetic */ EventHandler $handler;
                final /* synthetic */ IQ $iq;
                {
                    this.$handler = $handler;
                    this.$iq = $iq;
                    super(0);
                }

                @NotNull
                public final IQ invoke() {
                    return this.$handler.versionIqReceived((Version)this.$iq);
                }
            });
        } else if (iQ2 instanceof ConferenceModifyIQ) {
            handler.colibriRequestReceived(new ColibriRequest((ConferenceModifyIQ)iq, colibriDelayStats, colibriProcessingDelayStats, 0L, new Function1<IQ, Unit>(this, iq, mucClient){
                final /* synthetic */ XmppConnection this$0;
                final /* synthetic */ IQ $iq;
                final /* synthetic */ MucClient $mucClient;
                {
                    this.this$0 = $receiver;
                    this.$iq = $iq;
                    this.$mucClient = $mucClient;
                    super(1);
                }

                public final void invoke(@NotNull IQ response2) {
                    Intrinsics.checkNotNullParameter(response2, "response");
                    XmppConnection.access$setResponseTo(this.this$0, response2, this.$iq);
                    XmppConnection.access$getLogger$p(this.this$0).debug(() -> handleIqRequest.response.3.invoke$lambda-0(response2));
                    this.$mucClient.sendStanza(response2);
                }

                private static final String invoke$lambda-0(IQ $response) {
                    Intrinsics.checkNotNullParameter($response, "$response");
                    return "SENT: " + $response.toXML();
                }
            }, 8, null));
            iQ = null;
        } else {
            iQ = iQ2 instanceof HealthCheckIQ ? (IQ)this.measureDelay(healthDelayStats, (Function0<? extends CharSequence>)new Function0<CharSequence>(iq){
                final /* synthetic */ IQ $iq;
                {
                    this.$iq = $iq;
                    super(0);
                }

                @NotNull
                public final CharSequence invoke() {
                    CharSequence charSequence = this.$iq.toXML();
                    Intrinsics.checkNotNullExpressionValue(charSequence, "iq.toXML()");
                    return charSequence;
                }
            }, (Function0)new Function0<IQ>(handler, iq){
                final /* synthetic */ EventHandler $handler;
                final /* synthetic */ IQ $iq;
                {
                    this.$handler = $handler;
                    this.$iq = $iq;
                    super(0);
                }

                @NotNull
                public final IQ invoke() {
                    return this.$handler.healthCheckIqReceived((HealthCheckIQ)this.$iq);
                }
            }) : ErrorUtilKt.createError$default(iq, StanzaError.Condition.service_unavailable, "Unsupported IQ request " + iq.getChildElementName(), null, 8, null);
        }
        IQ iQ3 = response2 = iQ;
        return iQ3 != null ? this.setResponseTo(iQ3, iq) : null;
    }

    private final IQ setResponseTo(IQ $this$setResponseTo, IQ request) {
        IQ iQ;
        IQ $this$setResponseTo_u24lambda_u2d7 = iQ = $this$setResponseTo;
        boolean bl = false;
        $this$setResponseTo_u24lambda_u2d7.setFrom(request.getTo());
        $this$setResponseTo_u24lambda_u2d7.setStanzaId(request.getStanzaId());
        $this$setResponseTo_u24lambda_u2d7.setTo(request.getFrom());
        return iQ;
    }

    private final <T> T measureDelay(DelayStats delayStats, Function0<? extends CharSequence> context, Function0<? extends T> block) {
        long start = System.currentTimeMillis();
        T result2 = block.invoke();
        long delayMs = System.currentTimeMillis() - start;
        delayStats.addDelay(delayMs);
        if (delayMs > 100L) {
            this.logger.warn("Took " + delayMs + " ms to handle IQ: " + context.invoke());
        }
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final OrderedJsonObject getStatsJson() {
        return Companion.getStatsJson();
    }

    public static final /* synthetic */ IQ access$setResponseTo(XmppConnection $this, IQ $receiver, IQ request) {
        return $this.setResponseTo($receiver, request);
    }

    public static final /* synthetic */ Logger access$getLogger$p(XmppConnection $this) {
        return $this.logger;
    }

    static {
        Object[] objectArray = new String[]{"http://jitsi.org/protocol/healthcheck", "urn:xmpp:jingle:apps:dtls:0", "urn:xmpp:jingle:transports:ice-udp:1", "jabber:iq:version"};
        FEATURES = objectArray;
        objectArray = new Long[]{0L, 5L, 50L, 100L, 1000L, Long.MAX_VALUE};
        delayThresholds = CollectionsKt.listOf(objectArray);
        colibriProcessingDelayStats = new DelayStats(delayThresholds);
        colibriDelayStats = new DelayStats(delayThresholds);
        healthDelayStats = new DelayStats(delayThresholds);
        versionDelayStats = new DelayStats(delayThresholds);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;", "", "colibriRequestReceived", "", "request", "Lorg/jitsi/videobridge/xmpp/XmppConnection$ColibriRequest;", "healthCheckIqReceived", "Lorg/jivesoftware/smack/packet/IQ;", "iq", "Lorg/jitsi/xmpp/extensions/health/HealthCheckIQ;", "versionIqReceived", "Lorg/jivesoftware/smackx/iqversion/packet/Version;", "jitsi-videobridge"})
    public static interface EventHandler {
        public void colibriRequestReceived(@NotNull ColibriRequest var1);

        @NotNull
        public IQ versionIqReceived(@NotNull Version var1);

        @NotNull
        public IQ healthCheckIqReceived(@NotNull HealthCheckIQ var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003JG\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection$ColibriRequest;", "", "request", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "totalDelayStats", "Lorg/jitsi/nlj/stats/DelayStats;", "processingDelayStats", "receiveTime", "", "callback", "Lkotlin/Function1;", "Lorg/jivesoftware/smack/packet/IQ;", "", "(Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;Lorg/jitsi/nlj/stats/DelayStats;Lorg/jitsi/nlj/stats/DelayStats;JLkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function1;", "getProcessingDelayStats", "()Lorg/jitsi/nlj/stats/DelayStats;", "getReceiveTime", "()J", "getRequest", "()Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "getTotalDelayStats", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-videobridge"})
    public static final class ColibriRequest {
        @NotNull
        private final ConferenceModifyIQ request;
        @NotNull
        private final DelayStats totalDelayStats;
        @NotNull
        private final DelayStats processingDelayStats;
        private final long receiveTime;
        @NotNull
        private final Function1<IQ, Unit> callback;

        public ColibriRequest(@NotNull ConferenceModifyIQ request, @NotNull DelayStats totalDelayStats, @NotNull DelayStats processingDelayStats, long receiveTime, @NotNull Function1<? super IQ, Unit> callback) {
            Intrinsics.checkNotNullParameter(request, "request");
            Intrinsics.checkNotNullParameter(totalDelayStats, "totalDelayStats");
            Intrinsics.checkNotNullParameter(processingDelayStats, "processingDelayStats");
            Intrinsics.checkNotNullParameter(callback, "callback");
            this.request = request;
            this.totalDelayStats = totalDelayStats;
            this.processingDelayStats = processingDelayStats;
            this.receiveTime = receiveTime;
            this.callback = callback;
        }

        public /* synthetic */ ColibriRequest(ConferenceModifyIQ conferenceModifyIQ, DelayStats delayStats, DelayStats delayStats2, long l, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                l = System.currentTimeMillis();
            }
            this(conferenceModifyIQ, delayStats, delayStats2, l, function1);
        }

        @NotNull
        public final ConferenceModifyIQ getRequest() {
            return this.request;
        }

        @NotNull
        public final DelayStats getTotalDelayStats() {
            return this.totalDelayStats;
        }

        @NotNull
        public final DelayStats getProcessingDelayStats() {
            return this.processingDelayStats;
        }

        public final long getReceiveTime() {
            return this.receiveTime;
        }

        @NotNull
        public final Function1<IQ, Unit> getCallback() {
            return this.callback;
        }

        @NotNull
        public final ConferenceModifyIQ component1() {
            return this.request;
        }

        @NotNull
        public final DelayStats component2() {
            return this.totalDelayStats;
        }

        @NotNull
        public final DelayStats component3() {
            return this.processingDelayStats;
        }

        public final long component4() {
            return this.receiveTime;
        }

        @NotNull
        public final Function1<IQ, Unit> component5() {
            return this.callback;
        }

        @NotNull
        public final ColibriRequest copy(@NotNull ConferenceModifyIQ request, @NotNull DelayStats totalDelayStats, @NotNull DelayStats processingDelayStats, long receiveTime, @NotNull Function1<? super IQ, Unit> callback) {
            Intrinsics.checkNotNullParameter(request, "request");
            Intrinsics.checkNotNullParameter(totalDelayStats, "totalDelayStats");
            Intrinsics.checkNotNullParameter(processingDelayStats, "processingDelayStats");
            Intrinsics.checkNotNullParameter(callback, "callback");
            return new ColibriRequest(request, totalDelayStats, processingDelayStats, receiveTime, callback);
        }

        public static /* synthetic */ ColibriRequest copy$default(ColibriRequest colibriRequest, ConferenceModifyIQ conferenceModifyIQ, DelayStats delayStats, DelayStats delayStats2, long l, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                conferenceModifyIQ = colibriRequest.request;
            }
            if ((n & 2) != 0) {
                delayStats = colibriRequest.totalDelayStats;
            }
            if ((n & 4) != 0) {
                delayStats2 = colibriRequest.processingDelayStats;
            }
            if ((n & 8) != 0) {
                l = colibriRequest.receiveTime;
            }
            if ((n & 0x10) != 0) {
                function1 = colibriRequest.callback;
            }
            return colibriRequest.copy(conferenceModifyIQ, delayStats, delayStats2, l, function1);
        }

        @NotNull
        public String toString() {
            return "ColibriRequest(request=" + this.request + ", totalDelayStats=" + this.totalDelayStats + ", processingDelayStats=" + this.processingDelayStats + ", receiveTime=" + this.receiveTime + ", callback=" + this.callback + ")";
        }

        public int hashCode() {
            int result2 = this.request.hashCode();
            result2 = result2 * 31 + this.totalDelayStats.hashCode();
            result2 = result2 * 31 + this.processingDelayStats.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.receiveTime);
            result2 = result2 * 31 + this.callback.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColibriRequest)) {
                return false;
            }
            ColibriRequest colibriRequest = (ColibriRequest)other;
            if (!Intrinsics.areEqual(this.request, colibriRequest.request)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.totalDelayStats, colibriRequest.totalDelayStats)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.processingDelayStats, colibriRequest.processingDelayStats)) {
                return false;
            }
            if (this.receiveTime != colibriRequest.receiveTime) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, colibriRequest.callback);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection$Companion;", "", "()V", "FEATURES", "", "", "[Ljava/lang/String;", "colibriDelayStats", "Lorg/jitsi/nlj/stats/DelayStats;", "colibriProcessingDelayStats", "delayThresholds", "", "", "healthDelayStats", "versionDelayStats", "getStatsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OrderedJsonObject getStatsJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$getStatsJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$getStatsJson_u24lambda_u2d0.put("colibri", BucketStats.toJson$default(colibriDelayStats, null, 1, null));
            $this$getStatsJson_u24lambda_u2d0.put("colibri_processing", BucketStats.toJson$default(colibriProcessingDelayStats, null, 1, null));
            $this$getStatsJson_u24lambda_u2d0.put("health", BucketStats.toJson$default(healthDelayStats, null, 1, null));
            $this$getStatsJson_u24lambda_u2d0.put("version", BucketStats.toJson$default(versionDelayStats, null, 1, null));
            return orderedJsonObject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IQ.Type.values().length];
            nArray[IQ.Type.get.ordinal()] = 1;
            nArray[IQ.Type.set.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

