/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6OptionType;
import org.pcap4j.util.ByteArrays;

public final class UnknownIpV6Option
implements IpV6ExtOptionsPacket.IpV6Option {
    private static final long serialVersionUID = -2090004757469984967L;
    private final IpV6OptionType type;
    private final byte dataLen;
    private final byte[] data;

    public static UnknownIpV6Option newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UnknownIpV6Option(rawData, offset, length);
    }

    private UnknownIpV6Option(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.type = IpV6OptionType.getInstance(rawData[offset]);
        this.dataLen = rawData[1 + offset];
        if (length - 2 < this.dataLen) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option(").append(this.dataLen + 2).append("). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.data = ByteArrays.getSubArray(rawData, 2 + offset, this.dataLen);
    }

    private UnknownIpV6Option(Builder builder2) {
        if (builder2 == null || builder2.type == null || builder2.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.type: ").append(builder2.type).append(" builder.data: ").append(builder2.data);
            throw new NullPointerException(sb.toString());
        }
        this.type = builder2.type;
        this.data = new byte[builder2.data.length];
        System.arraycopy(builder2.data, 0, this.data, 0, builder2.data.length);
        this.dataLen = builder2.correctLengthAtBuild ? (byte)this.data.length : builder2.dataLen;
    }

    @Override
    public IpV6OptionType getType() {
        return this.type;
    }

    public byte getDataLen() {
        return this.dataLen;
    }

    public int getDataLenAsInt() {
        return 0xFF & this.dataLen;
    }

    public byte[] getData() {
        byte[] copy2 = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy2, 0, this.data.length);
        return copy2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.type.value();
        rawData[1] = this.dataLen;
        System.arraycopy(this.data, 0, rawData, 2, this.data.length);
        return rawData;
    }

    @Override
    public int length() {
        return this.data.length + 2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Option Type: ").append(this.type).append("] [Option Data Len: ").append(this.getDataLenAsInt()).append(" bytes] [Option Data: 0x").append(ByteArrays.toHexString(this.data, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        UnknownIpV6Option other = (UnknownIpV6Option)obj;
        return this.type.equals(other.type) && this.dataLen == other.dataLen && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.type.hashCode();
        result2 = 31 * result2 + this.dataLen;
        result2 = 31 * result2 + Arrays.hashCode(this.data);
        return result2;
    }

    public static final class Builder
    implements LengthBuilder<UnknownIpV6Option> {
        private IpV6OptionType type;
        private byte dataLen;
        private byte[] data;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(UnknownIpV6Option option) {
            this.type = option.type;
            this.dataLen = option.dataLen;
            this.data = option.data;
        }

        public Builder type(IpV6OptionType type2) {
            this.type = type2;
            return this;
        }

        public Builder dataLen(byte dataLen) {
            this.dataLen = dataLen;
            return this;
        }

        public Builder data(byte[] data2) {
            this.data = data2;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public UnknownIpV6Option build() {
            return new UnknownIpV6Option(this);
        }
    }
}

