/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingCore;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingFactory;
import org.pentaho.reporting.libraries.fonts.encoding.ExternalEncoding;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Ascii;
import org.pentaho.reporting.libraries.fonts.encoding.manual.BuiltInJavaEncoding;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.property.PropertiesResourceFactory;

public final class EncodingRegistry {
    private static final Logger logger = Logger.getLogger(EncodingRegistry.class.getName());
    private static final String TEST_STRING = " ";
    private HashMap encodingsMapping;
    private HashMap generatedMapping;
    private HashMap fallbackMapping;
    private HashMap aliases;
    private ResourceManager manager = new ResourceManager();
    private static EncodingRegistry instance;
    public static final String ENCODING_ALIAS_PREFIX = "org.pentaho.reporting.libraries.fonts.encoding.alias.";

    public static synchronized EncodingRegistry getInstance() {
        if (instance == null) {
            instance = new EncodingRegistry();
            instance.registerDefaults();
        }
        return instance;
    }

    private EncodingRegistry() {
        this.manager.registerFactoryCache();
        this.manager.registerDataCache();
        this.manager.registerDefaultLoaders();
        this.manager.registerFactory((ResourceFactory)new EncodingFactory());
        this.manager.registerFactory((ResourceFactory)new PropertiesResourceFactory());
        this.encodingsMapping = new HashMap();
        this.generatedMapping = new HashMap();
        this.fallbackMapping = new HashMap();
        this.aliases = new HashMap();
    }

    private void registerDefaults() {
        Configuration config = LibFontBoot.getInstance().getGlobalConfig();
        Iterator encodings = config.findPropertyKeys("org.pentaho.reporting.libraries.fonts.encoding.manual.");
        while (encodings.hasNext()) {
            String key = (String)encodings.next();
            String encodingClass = config.getConfigProperty(key);
            Object maybeEncoding = ObjectUtilities.loadAndInstantiate((String)encodingClass, EncodingRegistry.class, Encoding.class);
            if (maybeEncoding == null) continue;
            Encoding encoding = (Encoding)maybeEncoding;
            String name = encoding.getName();
            this.encodingsMapping.put(this.normalizeEncodingName(name), encodingClass);
        }
        Iterator generateDirs = config.findPropertyKeys("org.pentaho.reporting.libraries.fonts.encoding.generated.");
        while (generateDirs.hasNext()) {
            String key = (String)generateDirs.next();
            String dataLocation = config.getConfigProperty(key);
            try {
                ResourceKey resKey = this.manager.createKey((Object)dataLocation);
                Resource res = this.manager.create(resKey, null, Properties.class);
                Properties props = (Properties)res.getResource();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String encName = (String)entry.getKey();
                    String encPath = (String)entry.getValue();
                    ResourceKey encKey = this.manager.deriveKey(resKey, encPath);
                    this.generatedMapping.put(this.normalizeEncodingName(encName), encKey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator aliasesIt = config.findPropertyKeys(ENCODING_ALIAS_PREFIX);
        while (aliasesIt.hasNext()) {
            String key = (String)aliasesIt.next();
            String alias = key.substring(ENCODING_ALIAS_PREFIX.length());
            String target = config.getConfigProperty(key);
            this.aliases.put(this.normalizeEncodingName(alias), this.normalizeEncodingName(target));
        }
    }

    public boolean isSupportedEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        String key = this.normalizeEncodingName(encoding);
        if (this.encodingsMapping.containsKey(key)) {
            return true;
        }
        if (this.generatedMapping.containsKey(key)) {
            return true;
        }
        if (this.fallbackMapping.containsKey(key)) {
            return true;
        }
        return this.isEncodingSupportedJVM(encoding);
    }

    private String normalizeEncodingName(String name) {
        String lcName = name.toLowerCase();
        String retval = lcName.replace('_', '-');
        String alias = (String)this.aliases.get(retval);
        if (alias != null) {
            return alias;
        }
        return retval;
    }

    private boolean isEncodingSupportedJVM(String encoding) {
        try {
            TEST_STRING.getBytes(encoding);
            this.fallbackMapping.put(encoding, Boolean.TRUE);
            return true;
        }
        catch (Exception ue) {
            logger.info("Encoding " + encoding + " is not supported.");
            return false;
        }
    }

    public static String getPlatformDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("file.encoding", "Cp1252");
    }

    public Encoding getEncoding(String name) {
        String key = this.normalizeEncodingName(name);
        String manual = (String)this.encodingsMapping.get(key);
        if (manual != null) {
            return (Encoding)ObjectUtilities.loadAndInstantiate((String)manual, EncodingRegistry.class, Encoding.class);
        }
        ResourceKey generated = (ResourceKey)this.generatedMapping.get(key);
        if (generated != null) {
            try {
                Resource res = this.manager.create(generated, null, Encoding.class);
                Object o = res.getResource();
                if (o instanceof EncodingCore) {
                    return new ExternalEncoding(name, (EncodingCore)o, res);
                }
            }
            catch (Exception e) {
                logger.warning("Failed to create external-encoding instance for key " + key + " : " + e);
            }
        }
        if (this.isEncodingSupportedJVM(name)) {
            return new BuiltInJavaEncoding(name, true);
        }
        if (this.isEncodingSupportedJVM(key)) {
            return new BuiltInJavaEncoding(key, true);
        }
        return new Ascii();
    }
}

