/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class NotEqualOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = -3928772250539654675L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        ExtendedComparator comparator = typeRegistry.getComparator(value1.getType(), value2.getType());
        boolean result = comparator.isEqual(value1.getType(), value1.getValue(), value2.getType(), value2.getValue());
        if (!result) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    @Override
    public int getLevel() {
        return 400;
    }

    public String toString() {
        return "<>";
    }

    @Override
    public boolean isLeftOperation() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }
}

