/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTESMOVED;
    public static final int BYTESFREED;
    public static final int ALLOCATIONSMOVED;
    public static final int DEVICEMEMORYBLOCKSFREED;

    public VmaDefragmentationStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaDefragmentationStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long bytesMoved() {
        return VmaDefragmentationStats.nbytesMoved(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long bytesFreed() {
        return VmaDefragmentationStats.nbytesFreed(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationsMoved() {
        return VmaDefragmentationStats.nallocationsMoved(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMemoryBlocksFreed() {
        return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
    }

    public static VmaDefragmentationStats malloc() {
        return (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaDefragmentationStats calloc() {
        return (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaDefragmentationStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaDefragmentationStats create(long address) {
        return (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)address);
    }

    @Nullable
    public static VmaDefragmentationStats createSafe(long address) {
        return address == 0L ? null : (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaDefragmentationStats.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationStats.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VmaDefragmentationStats mallocStack() {
        return VmaDefragmentationStats.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationStats callocStack() {
        return VmaDefragmentationStats.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationStats mallocStack(MemoryStack stack) {
        return VmaDefragmentationStats.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationStats callocStack(MemoryStack stack) {
        return VmaDefragmentationStats.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationStats.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationStats.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.calloc(capacity, stack);
    }

    public static VmaDefragmentationStats malloc(MemoryStack stack) {
        return (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationStats calloc(MemoryStack stack) {
        return (VmaDefragmentationStats)VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaDefragmentationStats.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nbytesMoved(long struct) {
        return UNSAFE.getLong(null, struct + (long)BYTESMOVED);
    }

    public static long nbytesFreed(long struct) {
        return UNSAFE.getLong(null, struct + (long)BYTESFREED);
    }

    public static int nallocationsMoved(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCATIONSMOVED);
    }

    public static int ndeviceMemoryBlocksFreed(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMEMORYBLOCKSFREED);
    }

    static {
        Struct.Layout layout = VmaDefragmentationStats.__struct((Struct.Member[])new Struct.Member[]{VmaDefragmentationStats.__member((int)8), VmaDefragmentationStats.__member((int)8), VmaDefragmentationStats.__member((int)4), VmaDefragmentationStats.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTESMOVED = layout.offsetof(0);
        BYTESFREED = layout.offsetof(1);
        ALLOCATIONSMOVED = layout.offsetof(2);
        DEVICEMEMORYBLOCKSFREED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationStats, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationStats ELEMENT_FACTORY = VmaDefragmentationStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaDefragmentationStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long bytesMoved() {
            return VmaDefragmentationStats.nbytesMoved(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long bytesFreed() {
            return VmaDefragmentationStats.nbytesFreed(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationsMoved() {
            return VmaDefragmentationStats.nallocationsMoved(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMemoryBlocksFreed() {
            return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
        }
    }
}

