<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Kontoeinstellungen',
    'sidebar_personalization' => 'Personalisierung',
    'sidebar_settings_storage' => 'Speicher',
    'sidebar_settings_export' => 'Daten exportieren',
    'sidebar_settings_users' => 'Benutzer',
    'sidebar_settings_subscriptions' => 'Abonnement',
    'sidebar_settings_import' => 'Daten importieren',
    'sidebar_settings_tags' => 'Tag-Verwaltung',
    'sidebar_settings_api' => 'Schnittstelle (API)',
    'sidebar_settings_dav' => 'DAV-Ressourcen',
    'sidebar_settings_security' => 'Sicherheit',
    'sidebar_settings_auditlogs' => 'Prüfprotokolle',

    'title_general' => 'Allgemeine Information',
    'title_i18n' => 'Internationale Einstellungen',
    'title_layout' => 'Layout',

    'me_title' => 'Dein eigener Kontakt',
    'me_help' => 'Dies ist der Kontakt, der <em> Sie </em> in Monica vertritt',
    'me_select' => 'Wählen Sie einen Kontakt aus',
    'me_no_contact' => 'Es wurde kein Kontakt ausgewählt.',
    'me_select_click' => 'Klicken Sie hier, um einen Kontakt auszuwählen.',
    'me_remove_contact' => 'Entfernen Sie die Zuordnung',
    'me_choose' => 'Wähle dich selbst',
    'me_choose_placeholder' => 'Wähle dich selbst',

    'export_title' => 'Exportiere die Daten deines Kontos',
    'export_be_patient' => 'Button klicken um den Export zu starten. Dies kann mehrere Minuten dauern – sei bitte geduldig und klicke nicht mehrfach auf den Button.',
    'export_title_sql' => 'Nach SQL exportieren',
    'export_sql_explanation' => 'Der SQL-Export ermöglicht es dir deine Daten in einer eigenen monica-Installation zu importieren. Dies ist nur sinnvoll, wenn du einen eigenen Server besitzt.',
    'export_sql_cta' => 'SQL exportieren',
    'export_sql_link_instructions' => 'Hinweis: <a href=":url">lies die Anleitung</a> um mehr über das Importieren in die eigene Installation zu erfahren.',
    'export_title_json' => 'Nach JSON exportieren',
    'export_submitted' => 'Ihr Export wurde übermittelt, er wird in wenigen Augenblicken verfügbar sein…',
    'export_json_explanation' => 'Exportieren Ihrer Daten im JSON-Format für Sicherungszwecke.',
    'export_json_beta' => 'JSON-Export ist eine Vorschaufunktion. Sag uns, was du davon hältst:',
    'export_json_cta' => 'Nach JSON exportieren',
    'export_header_type' => 'Typ',
    'export_header_timestamp' => 'Erstellungsdatum',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Aktionen',
    'export_last_title' => 'Letzte Exporte',
    'export_empty_title' => 'Noch keine Exporte',
    'export_type_json' => 'JSON-Export',
    'export_type_sql' => 'SQL-Export',
    'export_status_todo' => 'Übermittelt',
    'export_status_doing' => 'In Arbeit',
    'export_status_done' => 'Fertig',
    'export_status_failed' => 'Fehlgeschlagen',
    'export_not_done' => 'Download nicht möglich, dieser Export ist noch nicht abgeschlossen.',

    'firstname' => 'Vorname',
    'lastname' => 'Nachname',
    'name_order' => 'Namensortierrichtung',
    'name_order_firstname_lastname' => '<First name> <Last name> – Max Mustermann',
    'name_order_lastname_firstname' => '<Last name> <First name> – Mustermann Max',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – Max Mustermann (Rambo)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – Max (Rambo) Mustermann',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Mustermann Max (Rambo)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Mustermann (Rambo) Max',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Rambo (Max Mustermann)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Doe John)',
    'name_order_nickname' => '<Nickname> – Rambo',
    'currency' => 'Währung',
    'name' => 'Dein Name: :name',
    'email' => 'E-Mail-Adresse',
    'email_placeholder' => 'E-Mail eingeben',
    'email_help' => 'Mit dieser Adresse kannst du dich einloggen und dorthin sendet Monica auch deine Erinnerungen.',
    'timezone' => 'Zeitzone',
    'temperature_scale' => 'Temperaturskala',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Ansicht',
    'layout_small' => 'Maximal 1200 Pixel breit',
    'layout_big' => 'Gesamte Breite des Browsers',
    'save' => 'Einstellungen speichern',
    'delete_title' => 'Konto löschen',
    'delete_desc' => 'Möchtest du dein Konto löschen? Dies kann nicht rückgangig gemacht werden und alle deine Daten werden dauerhaft gelöscht. Wenn du ein Abonnement hast, wird es sofort storniert.',
    'delete_other_desc' => 'Deine Daten in der Hauptdatenbank werden umgehend gelöscht. Wie in unseren Datenschutzrichtlinien beschrieben, führen wir täglich verschlüsselte Sicherungen durch, welche 30 Tage lang aufbewahrt und danach vollständig gelöscht werden. Wir können keine einzelnen Daten vor diesem Zeitraum aus den Backups löschen. Alle deine Daten werden innerhalb von 31 Tagen nach Löschung deines Kontos vollständig gelöscht.',
    'reset_desc' => 'Möchtest du dein Konto zurücksetzen? Dies entfernt alle deine Kontakte und die zugehörigen Daten. Dein Konto bleibt erhalten.',
    'reset_title' => 'Konto zurücksetzen',
    'reset_cta' => 'Konto zurücksetzen',
    'reset_notice' => 'Möchtest du dein Konto wirklich zurücksetzen? Dies ist dauerhaft und kann nicht rückgängig gemacht werden.',
    'reset_success' => 'Dein Konto wurde erfolgreich zurückgesetzt.',
    'delete_notice' => 'Bist du sicher, dass du dein Konto löschen möchtest? Dies ist dauerhaft und kann nicht rückgängig gemacht werden. Alle deine Daten werden gelöscht und können nicht wiederhergestellt werden.',
    'delete_cta' => 'Konto löschen',
    'settings_success' => 'Einstellungen aktualisiert!',
    'locale' => 'Sprache der Anwendung',
    'locale_help' => 'Möchtest du bei der Übersetzung von Monica helfen oder eine neue Sprache hinzufügen? Bitte folge <a href=":url" target="_blank" lang="en">diesem Link für weitere Informationen</a>.',
    'locale_ar' => 'Arabisch',
    'locale_cs' => 'Tschechisch',
    'locale_de' => 'Deutsch',
    'locale_el' => 'Griechisch',
    'locale_en' => 'Englisch',
    'locale_en-GB' => 'Englisch (Vereinigtes Königreich)',
    'locale_es' => 'Spanisch',
    'locale_fr' => 'Französisch',
    'locale_he' => 'Hebräisch',
    'locale_hr' => 'Kroatisch',
    'locale_id' => 'Indonesisch',
    'locale_it' => 'Italienisch',
    'locale_ja' => 'Japanisch',
    'locale_nl' => 'Niederländisch',
    'locale_pt' => 'Portugiesisch',
    'locale_pt-BR' => 'Brasilianisches Portugiesisch',
    'locale_ru' => 'Russisch',
    'locale_sv' => 'Schwedisch',
    'locale_vi' => 'Vietnamesisch',
    'locale_zh' => 'Vereinfachtes Chinesisch',
    'locale_zh-TW' => 'Chinesisch (Traditionell)',
    'locale_tr' => 'Türkisch',

    'security_title' => 'Sicherheit',
    'security_help' => 'Ändere die Sicherheitseinstellungen für dein Konto.',
    'password_change' => 'Passwort ändern',
    'password_current' => 'Aktuelles Passwort',
    'password_current_placeholder' => 'Aktuelles Passwort',
    'password_new1' => 'Neues Passwort',
    'password_new1_placeholder' => 'Gib dein neues Passwort ein',
    'password_new2' => 'Bestätige dein neues Passwort',
    'password_new2_placeholder' => 'Gib dein neues Passwort erneut ein',
    'password_btn' => 'Passwort ändern',
    '2fa_title' => 'Zwei-Faktor-Authentifizierung',
    '2fa_otp_title' => 'Zwei-Faktor-Authentifizierung Mobileapp',
    '2fa_enable_title' => 'Zwei-Faktor-Authentifizierung aktivieren',
    '2fa_enable_description' => 'Richte die Zwei-Faktor-Authentifizierung ein um die Sicherheit deines Kontos zu erhöhen.',
    '2fa_enable_otp' => 'Öffne deine Zwei-Faktor-Authentifizierungs-App und scanne den folgenden QR-Code:',
    '2fa_enable_otp_help' => 'Falls deine Zwei-Faktor-Authentifizierungs-App keine QR-Codes unterstützt, gib folgenden Code manuell ein:',
    '2fa_enable_otp_validate' => 'Bitte bestätige dein neu eingerichtetes Gerät:',
    '2fa_enable_success' => 'Zwei-Faktor-Authentifizierung ist nun aktiviert',
    '2fa_enable_error' => 'Fehler beim Einrichten der Zwei-Faktor-Authentifizierung',
    '2fa_enable_error_already_set' => 'Zwei-Faktor-Authentifizierung ist bereits aktiviert',
    '2fa_disable_title' => 'Zwei-Faktor-Authentifizierung deaktivieren',
    '2fa_disable_description' => 'Deaktiviere die Zwei-Faktor-Authentifizierung für dein Konto. Achtung, dies reduziert die Sicherheit deines Kontos erheblich!',
    '2fa_disable_success' => 'Zwei-Faktor-Authentifizierung ist nun deaktiviert',
    '2fa_disable_error' => 'Fehler beim Ausschalten der Zwei-Faktor-Authentifizierung',

    'webauthn_title' => 'Sicherheitsschlüssel — WebAuthn Protokoll',
    'webauthn_enable_description' => 'Neuen Sicherheitsschlüssel hinzufügen',
    'webauthn_key_name_help' => 'Geben Sie Ihren Schlüssel einen Namen.',
    'webauthn_key_name' => 'Schlüssel name:',
    'webauthn_success' => 'Ihr Schlüssel wurde erkannt und validiert.',
    'webauthn_last_use' => 'Letzte Verwendung: {timestamp}',
    'webauthn_delete_confirmation' => 'Diesen Schlüssel wirklich löschen?',
    'webauthn_delete_success' => 'Schlüssel gelöscht',
    'webauthn_insertKey' => 'Fügen Sie Ihren Sicherheitsschlüssel ein.',
    'webauthn_buttonAdvise' => 'Sofern Ihr Sicherheitsschlüssel einen Knopf hat, drücken Sie ihn.',
    'webauthn_noButtonAdvise' => 'Wenn nicht, entfernen Sie ihn und fügen Sie ihn erneut ein.',
    'webauthn_not_supported' => 'Ihr Browser unterstützt derzeit nicht WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn unterstützt nur sichere Verbindungen. Bitte laden Sie diese Seite mit https Schema.',
    'webauthn_error_already_used' => 'Dieser Schlüssel ist bereits registriert. Es ist nicht erforderlich, ihn erneut zu registrieren.',
    'webauthn_error_not_allowed' => 'Die Operation ist entweder abgelaufen oder nicht zulässig.',

    'recovery_title' => 'Wiederherstellungsschlüssel',
    'recovery_show' => 'Wiederherstellungscodes generieren',
    'recovery_copy_help' => 'Codes in die Zwischenablage kopieren',
    'recovery_help_intro' => 'Dies sind Ihre Wiederherstellungscodes:',
    'recovery_help_information' => 'Sie können jeden Wiederherstellungscode nur einmal verwenden.',
    'recovery_clipboard' => 'Codes wurden in die Zwischenablage kopiert.',
    'recovery_generate' => 'Neue Codes generieren…',
    'recovery_generate_help' => 'Beachte das die Generierung neuer Codes zuvor generierte Codes ungültig macht.',
    'recovery_already_used_help' => 'Dieser Code wurde bereits verwendet.',

    'users_list_title' => 'Benutzer, die Zugriff auf dein Konto haben',
    'users_list_add_user' => 'Einen Benutzer einladen',
    'users_list_you' => 'Das bist du',
    'users_list_invitations_title' => 'Ausstehende Einladungen',
    'users_list_invitations_explanation' => 'Unten stehen Personen, die du als Mithelfer eingeladen hast.',
    'users_list_invitations_invited_by' => 'eingeladen von :name',
    'users_list_invitations_sent_date' => 'versendet :date',
    'users_blank_title' => 'Du bist der Einzige mit Zugriff auf dieses Konto.',
    'users_blank_add_title' => 'Möchtest du jemand anderes einladen?',
    'users_blank_description' => 'Diese Person wird den gleichen Zugriff auf das System haben wie du und wird Kontakte hinzufügen, ändern und löschen können.',
    'users_blank_cta' => 'Jemanden einladen',
    'users_add_title' => 'Einen neuen Benutzer per E-Mail zu deinem Konto einladen',
    'users_add_description' => 'Diese Person wird den gleichen Zugriff wie du haben, einschließlich der Einladung oder des Löschens anderer Benutzer, inklusive dir selbst. Vergewissere dich, dass du dieser Person vertraust, bevor du ihr Zugang gewährst.',
    'users_add_email_field' => 'Gib die E-Mail-Adresse der Person an, die du einladen möchtest',
    'users_add_confirmation' => 'Ich bestätige, dass ich diesen Benutzer zu meinem Account einladen möchte. Ich verstehe, dass diese Person Zugriff auf ALLE meine Daten hat und sieht, was ich sehe.',
    'users_add_cta' => 'Benutzer per E-Mail einladen',
    'users_accept_title' => 'Einladung annehmen und neues Benutzerkonto erstellen',
    'users_error_please_confirm' => 'Bitte bestätige, dass du diesen Benutzer einladen willst',
    'users_error_email_already_taken' => 'Diese E-Mail-Adresse ist bereits vergeben. Bitte eine andere wählen.',
    'users_error_already_invited' => 'Diesen Benutzer hast du schon eingeladen. Bitte andere E-Mail-Adresse wählen.',
    'users_error_email_not_similar' => 'Dies ist nicht die E-Mail-Adresse der Person, die dich eingeladen hat.',
    'users_invitation_deleted_confirmation_message' => 'Die Einladung wurde erfolgreich gelöscht',
    'users_invitations_delete_confirmation' => 'Möchtest du die Einladung wirklich löschen?',
    'users_list_delete_confirmation' => 'Möchtest du den Benutzer wirklich aus deinem Konto entfernen?',
    'users_invitation_need_subscription' => 'Das Hinzufügen von weiteren Benutzern erfordert ein Abonnement.',

    'subscriptions_account_current_plan' => 'Dein aktuelles Abonnement',
    'subscriptions_account_current_legacy' => 'Aktueller Plan, nicht mehr wählbar:',
    'subscriptions_account_current_paid_plan' => 'Sie befinden sich im :name Abo. Vielen Dank für die Anmeldung.',

    'subscriptions_account_next_billing_title' => 'Nächste Rechnung',
    'subscriptions_account_next_billing' => 'Ihr Abonnement wird automatisch erneuert am <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'Wir berechnen Ihnen <strong>:price</strong> für einen weiteren <strong>Monat</strong>.',
    'subscriptions_account_bill_annual' => 'Wir berechnen Ihnen <strong>:price</strong> für ein weiteres <strong>Jahr</strong>.',
    'subscriptions_account_change' => 'Abo wechseln',

    'subscriptions_account_cancel_title' => 'Abonnement kündigen',
    'subscriptions_account_cancel_action' => 'Abonnement kündigen',
    'subscriptions_account_cancel' => 'Sie können Ihr Abonnement jederzeit kündigen.',
    'subscriptions_account_free_plan' => 'Du hast das kostenlose Abonnement.',
    'subscriptions_account_free_plan_upgrade' => 'Du kannst dein Konto auf :name upgraden, was $:price pro Monat kostet. Es beinhaltet folgende Vorteile:',
    'subscriptions_account_free_plan_benefits_users' => 'Beliebige Anzahl von Benutzern',
    'subscriptions_account_free_plan_benefits_reminders' => 'Erinnerungen per email',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importiere Kontakte über vCards',
    'subscriptions_account_free_plan_benefits_support' => 'Unterstütze das Projekt auf lange Sicht, so dass wir mehr großartige Features umsetzen können.',
    'subscriptions_account_upgrade' => 'Konto upgraden',
    'subscriptions_account_upgrade_title' => 'Upgrade Monica heute und mache deine persönlichen Beziehungen gehaltvoller.',
    'subscriptions_account_upgrade_choice' => 'Wähle eines der Abos und schließe dich :customers Personen an, die bereits die Premium-Version von Monica nutzen.',
    'subscriptions_account_update_title' => 'Abonnement aktualisieren',
    'subscriptions_account_update_description' => 'Hier können Sie das Intervall Ihres Abonnements ändern.',
    'subscriptions_account_update_information' => 'Der neue Betrag wird ihnen unmittelbar in Rechnung gestellt. Ihr Abonnement verlängert sich um den von Ihnen gewählten Zeitraum.',
    'subscriptions_account_invoices' => 'Rechnungen',
    'subscriptions_account_invoices_download' => 'Herunterladen',
    'subscriptions_account_invoices_subscription' => 'Abonnement von :startDate bis :endDate',
    'subscriptions_account_payment' => 'Wie möchtest du bezahlen?',
    'subscriptions_account_confirm_payment' => 'Ihre Zahlung ist derzeit unvollständig, bitte <a href=":url">bestätigen Sie die Zahlung</a>.',
    'subscriptions_downgrade_title' => 'Konto auf kostenlose Variante downgraden',
    'subscriptions_downgrade_limitations' => 'Die kostenlose Variante hat Einschränkungen. um downdgraden zu können müssen folgende Dinge zutreffen:',
    'subscriptions_downgrade_rule_users' => 'Du darfst nur einen Benutzer in deinem Konto haben',
    'subscriptions_downgrade_rule_users_constraint' => 'Du hast derzeit <a href=":url">1 Benutzer</a> in deinem Konto. | Du hast derzeit <a href=":url">:count Benutzer</a> in deinem Konto.',
    'subscriptions_downgrade_rule_invitations' => 'Du darfst keine ausstehenden Einladungen haben',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Du hast aktuell <a href=":url">eine ausstehende Einladung</a>.|Du hast aktuell <a href=":url">:count ausstehende Einladungen</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Sie dürfen nicht mehr als :number aktive Kontakte haben',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Sie haben derzeit <a href=":url">1 Kontakt </a>.|Sie haben derzeit <a href=":url">:count contacts</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'Wir können auch <a href=":url">alle Ihre Kontakte für Sie archivieren:</a> – das würde diese Regel deaktivieren und Sie mit dem Herabstufungsprozess Ihres Kontos fortfahren lassen.',
    'subscriptions_downgrade_cta' => 'Zurückstufen',
    'subscriptions_downgrade_success' => 'Du hast das kostenlose Abonnement!',
    'subscriptions_downgrade_thanks' => 'Vielen Dank, dass du das kostenpflichtige Abo ausprobiert hast. Wir fügen kontinuierlich weitere Funktionen hinzu. Vielleicht hast du in Zukunft ja wieder Interesse daran ein Abo abzuschließen.',
    'subscriptions_back' => 'Zurück zu Einstellungen',
    'subscriptions_upgrade_title' => 'Konto upgraden',
    'subscriptions_upgrade_choose' => 'Du hast das :plan Abonnement ausgewählt.',
    'subscriptions_upgrade_infos' => 'Wir freuen uns sehr. Bitte gebe deine Zahlungsinformationen unten ein.',
    'subscriptions_upgrade_name' => 'Name auf der Karte',
    'subscriptions_upgrade_zip' => 'Postleitzahl / ZIP-Code',
    'subscriptions_upgrade_credit' => 'Kreditkarte',
    'subscriptions_upgrade_submit' => 'Zahlen {amount}',
    'subscriptions_upgrade_charge' => 'Wir belasten deine Kreditkarte mit :price. Die nächste Gebühr wird am :date fällig sein. Wenn du es dir irgendwann anders überlegst, kannst du jederzeit ohne weitere Angaben kündigen.',
    'subscriptions_upgrade_charge_handled' => 'Die Zahlung erfolgt über <a href=":url">Stripe</a>. Keine Kreditkarteninformationen gelangen auf unsere Server.',
    'subscriptions_upgrade_success' => 'Danke! Du bist nun angemeldet.',
    'subscriptions_upgrade_thanks' => 'Willkommen in der Community von Leuten, die versuchen die Welt zu einem besseren Ort zu machen.',

    'subscriptions_payment_confirm_title' => 'Zahlung bestätigen',
    'subscriptions_payment_confirm_information' => 'Zur Bearbeitung Ihrer Zahlung ist eine zusätzliche Bestätigung erforderlich. Bitte bestätigen Sie Ihre Zahlung, indem Sie Ihre Zahlungsinformationen unten ausfüllen.',
    'subscriptions_payment_succeeded_title' => 'Zahlung erfolgreich',
    'subscriptions_payment_succeeded' => 'Diese Zahlung wurde bereits erfolgreich bestätigt.',
    'subscriptions_payment_cancelled_title' => 'Zahlung storniert',
    'subscriptions_payment_cancelled' => 'Der Bezahlvorgang wurde abgebrochen.',
    'subscriptions_payment_error_name' => 'Bitte geben Sie Ihren Namen ein.',
    'subscriptions_payment_success' => 'Zahlung wurde erfolgreich ausgeführt.',

    'subscriptions_pdf_title' => 'Dein :name monatliches Abonnement',
    'subscriptions_plan_frequency_year' => ':amount / Jahr',
    'subscriptions_plan_frequency_month' => ':amount / Monat',
    'subscriptions_plan_choose' => 'Bitte ein Paket auswählen',
    'subscriptions_plan_year_title' => 'Jährlich zahlen',
    'subscriptions_plan_year_bonus' => 'Ein ganzes Jahr lang keine Gedanken mehr machen',
    'subscriptions_plan_month_title' => 'Monatlich zahlen',
    'subscriptions_plan_month_bonus' => 'Jederzeit kündbar',
    'subscriptions_plan_include1' => 'Bei deinem Upgrade inklusive:',
    'subscriptions_plan_include2' => 'Unbegrenzte Anzahl an Nutzern • Erinnerungen per E-Mail • Importieren per vCard • Personalisierung der Kontaktseiten',
    'subscriptions_plan_include3' => '100% der Einnahmen fließen in die Entwicklung dieses großartigen Open-Source-Projektes.',
    'subscriptions_help_title' => 'Weitere Details, die dich interessieren könnten',
    'subscriptions_help_opensource_title' => 'Was ist ein Open-Source-Projekt?',
    'subscriptions_help_opensource_desc' => 'Monica ist ein Open-Source-Projekt. Das bedeutet, es wird von einer Community erstellt, die einfach ein tolles Programm der Allgemeinheit zur Verfügung stellen will. Open-Source bedeutet, dass der Quellcode auf GitHub öffentlich zugänglich ist und von jedermann eingesehen, verändert oder erweitert werden kann. Alle Einnahmen werden genutzt um das Programm zu verbessern, schnellere Server zu erwerben und andere Kosten zu bezahlen. Vielen Dank für deine Hilfe. Wir könnten das Ganze nicht ohne dich schaffen.',
    'subscriptions_help_limits_title' => 'Gibt es im kostenlosen Abo eine Begrenzung bei der Anzahl an Kontakten, die man haben kann?',
    'subscriptions_help_limits_plan' => 'Ja. Kostenlose Pläne ermöglichen es Ihnen, :number Kontakte zu verwalten.',
    'subscriptions_help_discounts_title' => 'Gibt es Ermäßigungen für gemeinnützige Organisationen und Bildungseinrichtungen?',
    'subscriptions_help_discounts_desc' => 'Ja! Monica ist kostenlos für Schüler, Studenten und gemeinnützige Organisationen. Kontaktiere einfach <a href=":support">den Support</a> mit einem entsprechenden Nachweis und wir werden den speziellen Status auf deinen Account anwenden.',
    'subscriptions_help_change_title' => 'Was passiert, wenn ich meine Meinung ändere?',
    'subscriptions_help_change_desc' => 'Du kannst jederzeit ohne weiteres selber kündigen, du musst dazu nicht den Support kontaktieren. Laufende Abos werden jedoch nicht zurückerstattet.',

    'stripe_error_card' => 'Ihre Karte wurde abgelehnt. Grund: :message',
    'stripe_error_api_connection' => 'Netzwerkkommunikation mit Stripe fehlgeschlagen. Versuchen Sie es später erneut.',
    'stripe_error_rate_limit' => 'Zu viele Anfragen mit Stripe. Versuchen Sie es später erneut.',
    'stripe_error_invalid_request' => 'Ungültige Parameter. Versuchen Sie es später erneut.',
    'stripe_error_authentication' => 'Falsche Authentifizierung mit Stripe',

    'import_title' => 'Importiere Kontakte in dein Konto',
    'import_cta' => 'Kontakte hochladen',
    'import_stat' => 'Du hast bisher :number Dateien importiert.',
    'import_result_stat' => 'vCard mit 1 Kontakt hochgeladen (:total_imported importiert, :total_skipped übersprungen)|vCard mit :total_contacts Kontakten hochgeladen (:total_imported importiert, :total_skipped übersprungen)',
    'import_view_report' => 'Bericht anzeigen',
    'import_in_progress' => 'Der Import ist im Gange. Lade die Seite in einer Minute neu.',
    'import_upload_title' => 'Kontakte aus vCard importieren',
    'import_upload_rules_desc' => 'Es gibt Einschränkungen:',
    'import_upload_rule_format' => 'Wir unterstützen <code>.vcard</code> und <code>.vcf</code> Dateien.',
    'import_upload_rule_vcard' => 'Wir unterstützen das vCard 3.0 Format, welches der Standard für MacOS und Google Kontakte ist.',
    'import_upload_rule_instructions' => 'Export-Anleitung für <a href=":url1" target="_blank" rel="noopener noreferrer">MacOS Kontakte</a> und <a href=":url2" target="_blank" rel="noopener noreferrer">Google Kontakte</a>.',
    'import_upload_rule_multiple' => 'Wenn deine Kontakte mehrere E-Mail-Adressen und Telefonnummern haben, werden jeweils nur die ersten Einträge importiert.',
    'import_upload_rule_limit' => 'Die Dateien dürfen nicht größer als 10 MB sein.',
    'import_upload_rule_time' => 'Es kann bis zu einer Minute dauern die Kontakte hochzuladen und zu verarbeiten. Wir bitten um Geduld.',
    'import_upload_rule_cant_revert' => 'Stell sicher, dass die Daten fehlerfrei sind, da der Upload nicht rückgängig gemacht werden kann.',
    'import_upload_form_file' => 'Deine <code>.vcf</code> oder <code>.vCard</code> Datei:',
    'import_upload_behaviour' => 'Import-Verhalten:',
    'import_upload_behaviour_add' => 'Neue Kontakte hinzufügen und bestehende überspringen',
    'import_upload_behaviour_replace' => 'Ersetze bestehende Kontakte',
    'import_upload_behaviour_help' => 'Ersetzen bedeutet, dass alle Daten mit den Informationen aus der vCard ersetzt werden, wobei existierende Kontaktfelder erhalten bleiben.',
    'import_report_title' => 'Importbericht',
    'import_report_date' => 'Importdatum',
    'import_report_type' => 'Importtyp',
    'import_report_number_contacts' => 'Anzahl der Kontakte in der Datei',
    'import_report_number_contacts_imported' => 'Anzahl der importieren Kontakte',
    'import_report_number_contacts_skipped' => 'Anzahl der übersprungenden Kontakte',
    'import_report_status_imported' => 'Importiert',
    'import_report_status_skipped' => 'Übersprungen',
    'import_vcard_parse_error' => 'Fehler beim Parsen des vCard-Eintrags',
    'import_vcard_contact_exist' => 'Kontakt existiert bereits',
    'import_vcard_contact_no_firstname' => 'Kein Vorname (Pflicht)',
    'import_vcard_file_not_found' => 'Datei nicht gefunden',
    'import_vcard_unknown_entry' => 'Unbekannter Kontakt',
    'import_vcard_file_no_entries' => 'Datei enthält keine Einträge',
    'import_blank_title' => 'Du has noch keine Kontakte importiert.',
    'import_blank_question' => 'Möchtest du jetzt Kontakte importieren?',
    'import_blank_description' => 'Wir können vCard-Dateien importieren, die du aus Google Contacts oder deinem Kontakt-Manager erhalten kannst.',
    'import_blank_cta' => 'Importiere vCard',
    'import_need_subscription' => 'Importieren von Daten erfordert ein Abonnement.',

    'tags_list_title' => 'Markierungen',
    'tags_list_description' => 'Du kannst deine Kontakte mithilfe von Tags organisieren. Tags funktionieren wie Ordner, wobei ein Kontakt auch mehrere Tags erhalten kann. Um einen neuen Tag anzulegen, musst du ihn nur beim Kontakt hinzufügen.',
    'tags_list_contact_number' => '1 Kontakt|:count Kontakte',
    'tags_list_delete_success' => 'Der Tag wurde erfolgreich gelöscht',
    'tags_list_delete_confirmation' => 'Möchtest du den Tag wirklich löschen? Kontakte werden nicht gelöscht, sondern nur der Tag.',
    'tags_blank_title' => 'Tags bieten eine tolle Möglichkeit Kontakte zu organisieren.',
    'tags_blank_description' => 'Tags funktionieren wie Ordner, wobei ein Kontakt auch mehrere Tags erhalten kann. Öffne einen Kontakt und tagge einen Freund direkt unter dem Namen. Sobald ein Kontakt getaggt ist, kannst du hier deine Tags verwalten.',

    'api_title' => 'API Zugriff',
    'api_description' => 'Über die API ist es möglich, Monica über eine externe Applikation zu nutzen, wie z.B. eine App auf deinem Handy.',
    'api_help' => 'Um die API zu verwenden, ist ein Token obligatorisch. Sie können entweder ein persönliches Zugangs-Token (Bearer authentication) erstellen oder einen OAuth-Client autorisieren, es für Sie zu erstellen. Siehe <a href=":url">API-Dokumentation</a>.',
    'api_endpoint' => 'Der API-Endpunkt für diese Monica-Instanz ist:',

    'api_personal_access_tokens' => 'Persönliche Zugangscodes',
    'api_pao_description' => 'Stelle sicher, dass du dieses Token nur an Quellen gibst, denen du vertraust, denn es erlaubt den Zugriff auf all deine Daten.',
    'api_token_title' => 'Persönliche Zugangs-Tokens',
    'api_token_create_new' => 'Neues Token erstellen',
    'api_token_not_created' => 'Du hast keine persönlichen Zugangs-Token erstellt.',
    'api_token_name' => 'Tokenname',
    'api_token_expire' => 'Läuft ab am {date}',
    'api_token_delete' => 'Löschen',
    'api_token_create' => 'Token erstellen',
    'api_token_scopes' => 'Geltungsbereiche',
    'api_token_help' => 'Hier ist dein neuer persönlicher Zugangs-Token. Dies ist das einzige Mal, dass er angezeigt wird, also verliere ihn nicht! Du kannst nun diesen Token verwenden, um API-Anfragen zu machen.',

    'api_oauth_clients' => 'Deine Oauth Clients',
    'api_oauth_clients_desc' => 'Hier kannst du deine eigenen OAuth Clients registrieren.',
    'api_oauth_clients_desc2' => 'Benutzen Sie diese Client-Id, um ein neues Token anzufordern und um Berechtigungscodes für den Zugriff auf Token zu konvertieren. Siehe <a href="{url}">Laravel Passport-Dokumentation</a> für weitere Informationen.',
    'api_oauth_title' => 'OAuth-Clients',
    'api_oauth_create_new' => 'Neuen Client erstellen',
    'api_oauth_edit' => 'Client bearbeiten',
    'api_oauth_not_created' => 'Du hast noch keine OAuth-Clients erstellt.',
    'api_oauth_clientid' => 'Kundennummer',
    'api_oauth_name' => 'Name',
    'api_oauth_name_help' => 'Etwas das deine Nutzer erkennen und dem sie vertrauen.',
    'api_oauth_secret' => 'Geheimbegriff',
    'api_oauth_create' => 'Client erstellen',
    'api_oauth_redirecturl' => 'Weiterleitungs-URL',
    'api_oauth_redirecturl_help' => 'Die Authorisierungs-Callback-URL deiner Anwendung.',

    'api_authorized_clients' => 'Liste der authorisierten Clients',
    'api_authorized_clients_desc' => 'Diese Liste zeigt dir alle Clients, denen du Zugriff auf deine Anwendung gewährt hast. Du kannst die Authorisierungen jederzeit widerrufen.',
    'api_authorized_clients_title' => 'Zugelassene Anwendungen',
    'api_authorized_clients_none' => 'Es sind noch keine autorisierten Clients vorhanden.',
    'api_authorized_clients_name' => 'Name',
    'api_authorized_clients_scopes' => 'Geltungsbereiche',

    'personalization_tab_title' => 'Personalisiere dein Konto',

    'personalization_title' => 'Hier findest du verschiedene Einstellungsoptionen für deinen Account. Diese Funktionen sind eher für erfahrene Nutzer gedacht, die maximale Kontrolle über Monica möchten.',
    'personalization_contact_field_type_title' => 'Kontaktfelder',
    'personalization_contact_field_type_add' => 'Neues Feld hinzufügen',
    'personalization_contact_field_type_description' => 'Du kannst verschiedene Typen von Kontaktfeldern definieren, die du dann bei deinen Kontakten verwenden kannst. Wenn es beispielsweise in der Zukunft ein neues soziales Netzwerk gibt, kannst du diese neue Art der Kommunikation mit deinen Kontakten direkt hier hinzufügen.',
    'personalization_contact_field_type_table_name' => 'Name',
    'personalization_contact_field_type_table_protocol' => 'Protokoll',
    'personalization_contact_field_type_table_actions' => 'Aktionen',
    'personalization_contact_field_type_modal_title' => 'Neues Kontaktfeld hinzufügen',
    'personalization_contact_field_type_modal_edit_title' => 'Bestehendes Kontaktfeld bearbeiten',
    'personalization_contact_field_type_modal_delete_title' => 'Bestehendes Kontaktfeld löschen',
    'personalization_contact_field_type_modal_delete_description' => 'Bist du sicher, dass du dieses Kontaktfeld löschen möchtest? Wenn du dieses Kontaktfeld löschst, werden auch alle Einträge dieses Typs bei bestehenden Kontakten entfernt.',
    'personalization_contact_field_type_modal_name' => 'Name',
    'personalization_contact_field_type_modal_protocol' => 'Protokoll (optional)',
    'personalization_contact_field_type_modal_protocol_help' => 'Wenn ein Protokoll für ein Kontaktfeld gesetzt ist, wird bei Klick auf das Feld die verknüpfte Aktion ausgelöst.',
    'personalization_contact_field_type_modal_icon' => 'Symbol (Optional)',
    'personalization_contact_field_type_modal_icon_help' => 'Du kannst ein Icon für dieses Kontaktfeld hinterlegen. Es muss eine Referenz auf ein Font Awesome Icon sein.',
    'personalization_contact_field_type_delete_success' => 'Das Kontaktfeld wurde erfolgreich gelöscht.',
    'personalization_contact_field_type_add_success' => 'Das Kontakfeld wurde erfolgreich hinzugefügt.',
    'personalization_contact_field_type_edit_success' => 'Das Kontakfeld wurde erfolgreich editiert.',

    'personalization_genders_title' => 'Geschlechter Typen',
    'personalization_genders_add' => 'Neue Geschlechtsidentität hinzufügen',
    'personalization_genders_desc' => 'Du kannst so viele Geschlechtsidentitäten anlegen wie du möchtest. Du brauchst mindestens eine Geschlechtsidentität in deinem Account.',
    'personalization_genders_modal_add' => 'Neue Geschlechtsidentität hinzufügen',
    'personalization_genders_modal_edit' => 'Geschlechtsidentität bearbeiten',
    'personalization_genders_modal_name' => 'Name',
    'personalization_genders_modal_name_help' => 'Der Name, mit dem das Geschlecht auf einer Kontaktseite angezeigt wird.',
    'personalization_genders_modal_sex' => 'Geschlecht',
    'personalization_genders_modal_sex_help' => 'Wird verwendet, um die Beziehungen zu definieren, und während des VCard Import/Export Prozesses.',
    'personalization_genders_modal_default' => 'Neuen Kontakten das Standardgeschlecht zuweisen',
    'personalization_genders_modal_delete' => 'Geschlechtsidentität löschen',
    'personalization_genders_modal_delete_desc' => 'Möchtest Du das Geschlecht "{name}" wirklich löschen?',
    'personalization_genders_modal_delete_question' => 'Du hast aktuell {count} Kontakt mit diesem Geschlecht. Wenn du dieses Geschlecht löschst, welches Geschlecht soll der Kontakt dann haben?|Du hast aktuell {count} Kontakte mit diesem Geschlecht. Wenn du dieses Geschlecht löschst, welches Geschlecht sollen die Kontakte dann haben?',
    'personalization_genders_modal_delete_question_default' => 'Dieses Geschlecht ist der aktuelle Standardwert. Wenn du dieses Geschlecht löschst, welches soll der neue Standardwert sein?',
    'personalization_genders_modal_error' => 'Bitte wähle ein Geschlecht aus der Liste.',
    'personalization_genders_list_contact_number' => '{count} Kontakt|{count} Kontakte',
    'personalization_genders_table_name' => 'Name',
    'personalization_genders_table_sex' => 'Geschlecht',
    'personalization_genders_table_default' => 'Standard',
    'personalization_genders_default' => 'Standard Geschlecht',
    'personalization_genders_make_default' => 'Ändern Sie das Standardgeschlecht',
    'personalization_genders_select_default' => 'Wählen Sie das Standardgeschlecht',
    'personalization_genders_m' => 'Männlich',
    'personalization_genders_f' => 'Weiblich',
    'personalization_genders_o' => 'Andere',
    'personalization_genders_u' => 'Unbekannt',
    'personalization_genders_n' => 'Keine oder nicht zutreffend',

    'personalization_reminder_rule_save' => 'Die Änderung wurde gespeichert',
    'personalization_reminder_rule_title' => 'Erinnerungen',
    'personalization_reminder_rule_line' => '{count} Tag zuvor|{count} Tage zuvor',
    'personalization_reminder_rule_desc' => 'Für jede Erinnerung die du setzt, kann Monica dir ein paar Tage bevor das Ereignis stattfindet eine Email senden. Du kannst diese Benachrichtigungen hier anpassen. Diese Einstellungen gelten nur für monatliche und jährliche Erinnerungen.',

    'personalization_module_save' => 'Die Änderung wurde gespeichert',
    'personalization_module_title' => 'Funktionen',
    'personalization_module_desc' => 'Möglicherweise brauchst du nicht alle Funktionen von Monica. Unten kannst du die Funktionen umschalten, die auf einer Kontaktseite zur Verfügung stehen. Diese Änderungen werden für ALLE Kontakte übernommen. Wenn du eine Funktion ausschaltest, gehen die Daten darin nicht verloren, sie werden nur verborgen.',

    'personalisation_paid_upgrade' => 'Dies ist eine Premium-Funktion, die nur im kostenpflichtigen Abo aktiv ist. Upgrade deinen Account unter <a href=":url">Einstellungen > Abonnement</a>.',
    'personalisation_paid_upgrade_vue' => 'Dies ist eine Premium-Funktion, die nur im kostenpflichtigen Abo aktiv ist. Upgrade deinen Account unter <a href="{url}">Einstellungen > Abonnement</a>.',

    'reminder_time_to_send' => 'Uhrzeit zu der die Erinnerungen versandt werden',
    'reminder_time_to_send_help' => 'Der Versand deiner nächsten Erinnerung ist für <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span> geplant.',

    'personalization_activity_type_category_title' => 'Aktivitätstyp Kategorien',
    'personalization_activity_type_category_add' => 'Neue Aktivitätstyp Kategorie hinzufügen',
    'personalization_activity_type_category_table_name' => 'Name',
    'personalization_activity_type_category_description' => 'Eine Aktivität mit einem deiner Kontakte kann einen Typ und eine Kategorie haben. Dein Konto kommt standardmäßig mit einer Reihe vordefinierter Kategorien, aber du kannst diese hier anpassen.',
    'personalization_activity_type_category_table_actions' => 'Aktionen',
    'personalization_activity_type_category_modal_add' => 'Neue Aktivitätstyp Kategorie hinzufügen',
    'personalization_activity_type_category_modal_edit' => 'Aktivitätstyps Kategorie bearbeiten',
    'personalization_activity_type_category_modal_question' => 'Wie sollen wir die neue Kategorie nennen?',
    'personalization_activity_type_add_button' => 'Neuen Aktivitätstyp hinzufügen',
    'personalization_activity_type_modal_add' => 'Neuen Aktivitätstyp hinzufügen',
    'personalization_activity_type_modal_question' => 'Wie sollen wir den neuen Aktivitätstyp nennen?',
    'personalization_activity_type_modal_edit' => 'Aktivitätstyp bearbeiten',
    'personalization_activity_type_category_modal_delete' => 'Eine Aktivitätstyp Kategorie löschen',
    'personalization_activity_type_category_modal_delete_desc' => 'Bist du sicher, dass du diese Kategorie löschen möchtest? Es werden alle zugehörigen Aktivitätstypen gelöscht. Tätigkeiten, die zu dieser Kategorie gehören, sind nicht von der Löschung betroffen.',
    'personalization_activity_type_modal_delete' => 'Aktivitätstyp löschen',
    'personalization_activity_type_modal_delete_desc' => 'Sind Sie sicher, dass Sie diesen Aktivitätstyp löschen möchten? Aktivitäten, die dieser Kategorie angehören, werden von dieser Löschung nicht betroffen sein.',
    'personalization_activity_type_modal_delete_error' => 'Wir können diesen Aktivitätstyp nicht finden.',
    'personalization_activity_type_category_modal_delete_error' => 'Wir können diese Aktivitätstyp Kategorie nicht finden.',

    'personalization_life_event_category_title' => 'Lebensereigniskategorien',
    'personalization_live_event_category_table_name' => 'Name',
    'personalization_life_event_category_description' => 'Eine Lebensereignis kann einen Typ und eine Kategorie haben. Dein Konto verfügt über eine Reihe vordefinierter Kategorien und Typen, welche du hier anpassen kannst.',
    'personalization_live_event_category_table_actions' => 'Aktionen',
    'personalization_life_event_type_add_button' => 'Neuen Lebensereignis-Typ hinzufügen',
    'personalization_life_event_type_modal_add' => 'Neuen Lebensereignis-Typ hinzufügen',
    'personalization_life_event_type_modal_question' => 'Wie sollen wir den neuen Lebensereignistyp nennen?',
    'personalization_life_event_type_modal_edit' => 'Lebensereignis-Typ bearbeiten',
    'personalization_life_event_type_modal_delete' => 'Lebensereignis-Typ löschen',
    'personalization_life_event_type_modal_delete_desc' => 'Bist du sicher, dass du diesen Lebensereignis-Typ löschen möchtest? Lebensereignisse, die zu diesem Typ gehören, werden durch diese Aktion gelöscht.',
    'personalization_life_event_type_modal_delete_error' => 'Wir können diesen Lebensereignis-Typ nicht finden.',

    'personalization_life_event_category_work_education' => 'Arbeit & Bildung',
    'personalization_life_event_category_family_relationships' => 'Familie & Beziehungen',
    'personalization_life_event_category_home_living' => 'Zuhause & Leben',
    'personalization_life_event_category_travel_experiences' => 'Reisen & Erfahrungen',
    'personalization_life_event_category_health_wellness' => 'Gesundheit & Fitness',

    'personalization_life_event_type_new_job' => 'Neuer Job',
    'personalization_life_event_type_retirement' => 'Pensionierung',
    'personalization_life_event_type_new_school' => 'Neue Schule',
    'personalization_life_event_type_study_abroad' => 'Studium im Ausland',
    'personalization_life_event_type_volunteer_work' => 'Ehrenamtliche Arbeit',
    'personalization_life_event_type_published_book_or_paper' => 'Buch oder Bericht veröffentlicht',
    'personalization_life_event_type_military_service' => 'Militärdienst',
    'personalization_life_event_type_first_met' => 'Erste Begegnung',
    'personalization_life_event_type_new_relationship' => 'Neue Beziehung',
    'personalization_life_event_type_engagement' => 'Engagement',
    'personalization_life_event_type_marriage' => 'Heirat',
    'personalization_life_event_type_anniversary' => 'Jahrestag',
    'personalization_life_event_type_expecting_a_baby' => 'Erwartet ein Baby',
    'personalization_life_event_type_new_child' => 'Neues Kind',
    'personalization_life_event_type_new_family_member' => 'Neues Familienmitglied',
    'personalization_life_event_type_new_pet' => 'Neues Haustier',
    'personalization_life_event_type_end_of_relationship' => 'Ende einer Beziehung',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Einen geliebten Menschen verloren',
    'personalization_life_event_type_moved' => 'Umgezogen',
    'personalization_life_event_type_bought_a_home' => 'Ein Haus gekauft',
    'personalization_life_event_type_home_improvement' => 'Immobilien-Renovierung',
    'personalization_life_event_type_holidays' => 'Feiertage',
    'personalization_life_event_type_new_vehicle' => 'Neues Fahrzeug',
    'personalization_life_event_type_new_roommate' => 'Neuer Mitbewohner',
    'personalization_life_event_type_overcame_an_illness' => 'Krankheit überwunden',
    'personalization_life_event_type_quit_a_habit' => 'Gewohnheit beendet',
    'personalization_life_event_type_new_eating_habits' => 'Neue Essgewohnheiten',
    'personalization_life_event_type_weight_loss' => 'Gewichts-Verlust',
    'personalization_life_event_type_wear_glass_or_contact' => 'Trägt nun eine Brille oder Kontaktlinsen',
    'personalization_life_event_type_broken_bone' => 'Hat sich einen Knochen gebrochen',
    'personalization_life_event_type_removed_braces' => 'Hat die Zahnspange entfernt bekommen',
    'personalization_life_event_type_surgery' => 'Hatte eine Operation',
    'personalization_life_event_type_dentist' => 'Hatte eine Zahnbehandlung',
    'personalization_life_event_type_new_sport' => 'Hat eine neue Sportart begonnen',
    'personalization_life_event_type_new_hobby' => 'Hat ein neues Hobby begonnen',
    'personalization_life_event_type_new_instrument' => 'Hat angefangen ein neues Instrument zu lernen',
    'personalization_life_event_type_new_language' => 'Hat angefangen eine neue Sprache zu lernen',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tattoo oder Piercing',
    'personalization_life_event_type_new_license' => 'Neue Lizenz',
    'personalization_life_event_type_travel' => 'Reise',
    'personalization_life_event_type_achievement_or_award' => 'Errungenschaft oder Auszeichnung',
    'personalization_life_event_type_changed_beliefs' => 'Überzeugung geändert',
    'personalization_life_event_type_first_word' => 'Erstes Wort',
    'personalization_life_event_type_first_kiss' => 'Erster Kuss',

    'storage_title' => 'Speicher',
    'storage_account_info' => 'Dein Kontolimit ist :accountLimit MB / Deine aktuelle Nutzung ist :currentAccountSize MB (ungefähr :percentUsage%).',
    'storage_upgrade_notice' => 'Upgraden Sie Ihr Konto, um Dokumente und Fotos hochladen zu können.',
    'storage_description' => 'Hier sehen Sie alle Dokumente und Fotos, die Sie über Ihre Kontakte hochgeladen haben.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Hier finden Sie alle Einstellungen für den Einsatz von WebDAV Ressourcen für CardDAV und CalDAV Export.',
    'dav_copy_help' => 'In die Zwischenablage kopieren',
    'dav_clipboard_copied' => 'Wert in die Zwischenablage kopiert',
    'dav_url_base' => 'Basis-Url für alle CardDAV- und CalDAV-Ressourcen:',
    'dav_connect_help' => 'Sie können Ihre Kontakte und/oder Kalender mit dieser Basis-Url auf Ihrem Telefon oder Computer verbinden.',
    'dav_connect_help2' => 'Verwenden Sie Ihren Login (E-Mail) und erstellen Sie ein API-Token als Passwort, um sich zu authentifizieren.',
    'dav_url_carddav' => 'CardDAV-Url für Kontaktressourcen:',
    'dav_url_caldav_birthdays' => 'CalDAV Url für Geburtstage Ressourcen:',
    'dav_url_caldav_tasks' => 'CalDAV-Url für Aufgabenressourcen:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Alle Kontakte in einer Datei exportieren',
    'dav_caldav_birthdays_export' => 'Alle Geburtstage in einer Datei exportieren',
    'dav_caldav_tasks_export' => 'Alle Aufgaben in einer Datei exportieren',

    'archive_title' => 'Alle Kontakte in deinem Konto archivieren',
    'archive_desc' => 'Dies wird alle Kontakte in deinem Konto archivieren.',
    'archive_cta' => 'Alle Kontakte archivieren',

    'logs_title' => 'Alles, was mit diesem Konto passiert ist',
    'logs_actor' => 'Benutzer',
    'logs_timestamp' => 'Zeitpunkt',
    'logs_description' => 'Beschreibung',
    'logs_subject' => 'Betroffener Kontakt',
    'logs_size' => 'Größe (KB)',
    'logs_object' => 'Objekt',
];
