/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;

public class TestChecker
implements PrerequisitesChecker {
    public static final String PROP_SKIP_TEST = "skipTests";

    @Override
    public boolean checkRunConfig(RunConfig config) {
        ClassPath nontestsrc;
        FileObject origFile;
        String method;
        String test;
        String action = config.getActionName();
        if ("test".equals(action) || "test.single".equals(action) || "debug.test.single".equals(action) || "profile-tests".equals(action)) {
            test = config.getProperties().get("test");
            method = config.getProperties().get("nb.single.run.methodName");
            if (test != null && method != null) {
                config.setProperty("nb.single.run.methodName", null);
                config.setProperty("test", test + '#' + method);
            }
        }
        if ("integration-test.single".equals(action) || "debug.integration-test.single".equals(action) || "profile-tests".equals(action)) {
            test = config.getProperties().get("it.test");
            method = config.getProperties().get("nb.single.run.methodName");
            if (test != null && method != null) {
                config.setProperty("nb.single.run.methodName", null);
                config.setProperty("it.test", test + '#' + method);
            }
        }
        if (MavenSettings.getDefault().isSkipTests() && !String.valueOf(config.getGoals()).contains("test") && config.getProperties().get(PROP_SKIP_TEST) == null) {
            config.setProperty(PROP_SKIP_TEST, "true");
        }
        if (("test.single".equals(action) || "integration-test.single".equals(action) || "debug.test.single".equals(action) || "debug.integration-test.single".equals(action) || "profile.test.single".equals(action)) && (test = "integration-test.single".equals(action) || "debug.integration-test.single".equals(action) ? config.getProperties().get("it.test") : config.getProperties().get("test")) != null && (origFile = config.getSelectedFileObject()) != null && (nontestsrc = ((ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectSourcesClassPath("classpath/source")).contains(origFile)) {
            String[] tests = StringUtils.split((String)test, (String)",");
            boolean found = false;
            ClassPath[] src = ((ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPaths("classpath/source");
            block0: for (String tt : tests) {
                if (tt.contains("#")) {
                    found = true;
                    break;
                }
                if (tt.contains("*")) {
                    found = true;
                    break;
                }
                String testPath = tt.replace(".", "/");
                if (!testPath.endsWith(".java")) {
                    testPath = testPath + ".java";
                }
                for (ClassPath cp : src) {
                    if (cp.findResource(testPath) == null) continue;
                    found = true;
                    continue block0;
                }
            }
            if (!found) {
                StatusDisplayer.getDefault().setStatusText("Could not find tests for selected files. Skipping execution.", 700);
                return false;
            }
        }
        return true;
    }
}

