/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.openide.util.Utilities;

public class TestRuntimeClassPathImpl
extends AbstractProjectClassPathImpl {
    private final boolean testScoped;

    public TestRuntimeClassPathImpl(NbMavenProjectImpl proj, boolean testScoped) {
        super(proj);
        this.testScoped = testScoped;
    }

    @Override
    URI[] createPath() {
        List<URI> lst = TestRuntimeClassPathImpl.createPath(this.getMavenProject().getOriginalMavenProject(), this.testScoped);
        URI[] uris = new URI[lst.size()];
        uris = lst.toArray(uris);
        return uris;
    }

    public static List<URI> createPath(MavenProject prj) {
        return TestRuntimeClassPathImpl.createPath(prj, false);
    }

    private static List<URI> createPath(MavenProject prj, boolean testScoped) {
        assert (prj != null);
        ArrayList<URI> lst = new ArrayList<URI>();
        Build build = prj.getBuild();
        if (build != null) {
            Object outputDirectory;
            String testOutputDirectory = build.getTestOutputDirectory();
            if (testOutputDirectory != null) {
                lst.add(NbMavenProjectImpl.convertStringToUri(testOutputDirectory, true));
            }
            if ((outputDirectory = build.getOutputDirectory()) != null) {
                lst.add(NbMavenProjectImpl.convertStringToUri((String)outputDirectory, true));
            }
        }
        List arts = prj.getTestArtifacts();
        for (Artifact art : arts) {
            File f = TestRuntimeClassPathImpl.getFile(art);
            if (f == null) continue;
            lst.add(Utilities.toURI((File)f));
        }
        if (testScoped) {
            List<URI> cmplst = RuntimeClassPathImpl.createPath(prj);
            lst.removeAll(cmplst);
        }
        return lst;
    }
}

