/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class BeanRunConfig
implements RunConfig {
    private File executionDirectory;
    private WeakReference<Project> project;
    private FileObject projectDirectory;
    private List<String> goals;
    private String executionName;
    private Map<String, String> properties;
    private Map<String, Object> internalProperties;
    private boolean showDebug = MavenSettings.getDefault().isShowDebug();
    private boolean showError = MavenSettings.getDefault().isShowErrors();
    private Boolean offline = MavenSettings.getDefault().isOffline();
    private boolean updateSnapshots = MavenSettings.getDefault().isUpdateSnapshots();
    private boolean interactive = MavenSettings.getDefault().isInteractive();
    private List<String> activate;
    private boolean recursive = true;
    private String taskName;
    private RunConfig parent;
    private String actionName;
    private FileObject selectedFO;
    private MavenProject mp;
    private RunConfig preexecution;
    private RunConfig.ReactorStyle reactor = RunConfig.ReactorStyle.NONE;
    private Lookup actionContext = Lookup.EMPTY;

    public BeanRunConfig() {
    }

    @Override
    public Lookup getActionContext() {
        return this.actionContext;
    }

    public BeanRunConfig(RunConfig parent) {
        this.parent = parent;
        this.setRecursive(parent.isRecursive());
        this.setInteractive(parent.isInteractive());
        this.setOffline(parent.isOffline());
        this.setShowDebug(parent.isShowDebug());
        this.setShowError(parent.isShowError());
        this.setUpdateSnapshots(parent.isUpdateSnapshots());
        this.setReactorStyle(parent.getReactorStyle());
        this.setActionContext(parent.getActionContext());
    }

    public void setActionContext(Lookup actionContext) {
        this.actionContext = actionContext;
    }

    public void reassignMavenProjectFromParent() {
        if (this.parent instanceof BeanRunConfig) {
            this.mp = ((BeanRunConfig)this.parent).mp;
        }
    }

    @Override
    public final File getExecutionDirectory() {
        if (this.parent != null && this.executionDirectory == null) {
            return this.parent.getExecutionDirectory();
        }
        return this.executionDirectory;
    }

    @Override
    public final void setExecutionDirectory(File executionDirectory) {
        assert (executionDirectory != null) : "Please reopen issue 239540 - https://netbeans.org/bugzilla/show_bug.cgi?id=239540";
        this.executionDirectory = executionDirectory;
    }

    @Override
    public final Project getProject() {
        if (this.parent != null && this.project == null) {
            return this.parent.getProject();
        }
        if (this.project != null) {
            Project prj = (Project)this.project.get();
            if (prj == null && this.projectDirectory.isValid()) {
                try {
                    prj = ProjectManager.getDefault().findProject(this.projectDirectory);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return prj;
        }
        return null;
    }

    @Override
    public final synchronized MavenProject getMavenProject() {
        if (this.mp != null) {
            return this.mp;
        }
        Project prj = this.getProject();
        if (prj != null) {
            NbMavenProjectImpl impl = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
            ArrayList<String> profiles = new ArrayList<String>();
            profiles.addAll(impl.getCurrentActiveProfiles());
            if (this.getActivatedProfiles() != null) {
                profiles.addAll(this.getActivatedProfiles());
            }
            Properties props = new Properties();
            if (this.getProperties() != null) {
                props.putAll(this.getProperties());
            }
            this.mp = impl.loadMavenProject(EmbedderFactory.getProjectEmbedder(), profiles, props);
        }
        return this.mp;
    }

    public final synchronized void setProject(Project project) {
        if (project != null) {
            this.project = new WeakReference<Project>(project);
            this.projectDirectory = project.getProjectDirectory();
        } else {
            this.project = null;
            this.projectDirectory = null;
        }
        this.mp = null;
    }

    @Override
    public final List<String> getGoals() {
        if (this.parent != null && this.goals == null) {
            return this.parent.getGoals();
        }
        return this.goals;
    }

    public final void setGoals(List<String> goals) {
        this.goals = goals;
    }

    @Override
    public final String getExecutionName() {
        if (this.parent != null && this.executionName == null) {
            return this.parent.getExecutionName();
        }
        return this.executionName;
    }

    public final void setExecutionName(String executionName) {
        this.executionName = executionName;
    }

    @Override
    public final Map<? extends String, ? extends String> getProperties() {
        if (this.properties == null) {
            return this.parent != null ? this.parent.getProperties() : Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.properties));
    }

    @Override
    public final void setProperty(@NonNull String key, @NullAllowed String value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
            if (this.parent != null) {
                this.properties.putAll(this.parent.getProperties());
            }
        }
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    @Override
    public final Map<? extends String, ? extends Object> getInternalProperties() {
        if (this.internalProperties == null) {
            return this.parent != null ? this.parent.getInternalProperties() : Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<String, Object>(this.internalProperties));
    }

    @Override
    public final void setInternalProperty(@NonNull String key, @NullAllowed Object value) {
        if (this.internalProperties == null) {
            this.internalProperties = new LinkedHashMap<String, Object>();
            if (this.parent != null) {
                this.internalProperties.putAll(this.parent.getInternalProperties());
            }
        }
        if (value != null) {
            this.internalProperties.put(key, value);
        } else {
            this.internalProperties.remove(key);
        }
    }

    @Override
    public final void addProperties(Map<String, String> props) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
            if (this.parent != null) {
                this.properties.putAll(this.parent.getProperties());
            }
        }
        this.properties.putAll(props);
    }

    @Override
    public final boolean isShowDebug() {
        return this.showDebug;
    }

    public final void setShowDebug(boolean showDebug) {
        this.showDebug = showDebug;
    }

    @Override
    public final boolean isShowError() {
        return this.showError;
    }

    public final void setShowError(boolean showError) {
        this.showError = showError;
    }

    @Override
    public final Boolean isOffline() {
        return this.offline;
    }

    @Override
    public final void setOffline(Boolean offline) {
        this.offline = offline;
    }

    @Override
    public final List<String> getActivatedProfiles() {
        if (this.parent != null && this.activate == null) {
            return this.parent.getActivatedProfiles();
        }
        if (this.activate != null) {
            return Collections.unmodifiableList(this.activate);
        }
        return Collections.emptyList();
    }

    @Override
    public final void setActivatedProfiles(List<String> activeteProfiles) {
        this.activate = new ArrayList<String>();
        this.activate.addAll(activeteProfiles);
    }

    @Override
    public final boolean isRecursive() {
        return this.recursive;
    }

    public final void setRecursive(boolean rec) {
        this.recursive = rec;
    }

    @Override
    public final boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    public final void setUpdateSnapshots(boolean set) {
        this.updateSnapshots = set;
    }

    @Override
    public final String getTaskDisplayName() {
        if (this.parent != null && this.taskName == null) {
            return this.parent.getTaskDisplayName();
        }
        return this.taskName;
    }

    public final void setTaskDisplayName(String name) {
        this.taskName = name;
    }

    @Override
    public final boolean isInteractive() {
        return this.interactive;
    }

    public final void setInteractive(boolean ia) {
        this.interactive = ia;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public String getActionName() {
        if (this.parent != null && this.actionName == null) {
            return this.parent.getActionName();
        }
        return this.actionName;
    }

    @Override
    public FileObject getSelectedFileObject() {
        if (this.parent != null && this.selectedFO == null) {
            return this.parent.getSelectedFileObject();
        }
        return this.selectedFO;
    }

    public void setFileObject(FileObject selectedFile) {
        this.selectedFO = selectedFile;
    }

    @Override
    public RunConfig getPreExecution() {
        if (this.parent != null && this.preexecution == null) {
            return this.parent.getPreExecution();
        }
        return this.preexecution;
    }

    @Override
    public void setPreExecution(RunConfig config) {
        this.preexecution = config;
    }

    @Override
    public final RunConfig.ReactorStyle getReactorStyle() {
        return this.reactor;
    }

    public final void setReactorStyle(RunConfig.ReactorStyle style) {
        this.reactor = style;
    }
}

