/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;

public class TreePath {
    private Node first;
    private Node last;

    public TreePath(Node last) {
        this(null, last);
    }

    public TreePath(Node first, Node last) {
        this.first = first;
        this.last = last;
    }

    public Node first() {
        return this.first;
    }

    public Node last() {
        return this.last;
    }

    public List<Node> path() {
        ArrayList<Node> path = new ArrayList<Node>();
        for (Node node = this.last; node != null; node = node.parent()) {
            path.add(node);
            if (node == this.first) break;
        }
        return path;
    }

    public String toString() {
        return this.getNodePath();
    }

    private String getNodePath() {
        return NodeUtil.encodeToString(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TreePath)) {
            return false;
        }
        TreePath path = (TreePath)o;
        return this.getNodePath().equals(path.getNodePath());
    }

    public int hashCode() {
        return this.getNodePath().hashCode();
    }
}

