/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.refactoring.api.CssRefactoringExtraInfo;
import org.netbeans.modules.css.refactoring.api.CssRefactoringInfo;
import org.netbeans.modules.html.editor.indexing.Entry;
import org.netbeans.modules.html.editor.indexing.HtmlFileModel;
import org.netbeans.modules.html.editor.refactoring.WhereUsedElement;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CssWhereUsedQueryPlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(CssWhereUsedQueryPlugin.class.getName());
    private final WhereUsedQuery refactoring;
    private boolean cancelled = false;

    public CssWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (this.cancelled) {
            return null;
        }
        Lookup lookup = this.refactoring.getRefactoringSource();
        CssRefactoringInfo context = (CssRefactoringInfo)lookup.lookup(CssRefactoringInfo.class);
        if (context != null) {
            ElementKind kind;
            Collection files;
            Project containingProject = FileOwnerQuery.getOwner((FileObject)context.getFileObject());
            if (containingProject == null) {
                return null;
            }
            CssIndex index = null;
            try {
                index = CssIndex.get((Project)containingProject);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Failed to open CssIndex for: " + containingProject, ex);
            }
            if (index == null) {
                return null;
            }
            CssRefactoringInfo.Type cssType = context.getType();
            if (cssType != CssRefactoringInfo.Type.CLASS && cssType != CssRefactoringInfo.Type.ID) {
                return null;
            }
            String elementImage = context.getElementName();
            switch (cssType) {
                case CLASS: {
                    files = index.findClasses(elementImage);
                    kind = ElementKind.CLASS;
                    break;
                }
                case ID: {
                    files = index.findIds(elementImage);
                    kind = ElementKind.ATTRIBUTE;
                    break;
                }
                default: {
                    files = null;
                    kind = null;
                }
            }
            LinkedList involvedFiles = new LinkedList(files);
            DependenciesGraph deps = index.getDependencies(context.getFileObject());
            Collection relatedFiles = deps.getAllRelatedFiles();
            CssRefactoringExtraInfo extraInfo = (CssRefactoringExtraInfo)lookup.lookup(CssRefactoringExtraInfo.class);
            if (extraInfo == null || !extraInfo.isRefactorAll()) {
                involvedFiles.retainAll(relatedFiles);
            }
            for (FileObject file : involvedFiles) {
                try {
                    CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                    Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                    HtmlFileModel model = new HtmlFileModel(source);
                    List<Entry> entries = null;
                    if (CssRefactoringInfo.Type.CLASS == cssType) {
                        entries = model.getCssClasses().get(elementImage);
                    } else if (CssRefactoringInfo.Type.ID == cssType) {
                        Entry e = model.getIds().get(elementImage);
                        List<Entry> list = entries = e == null ? null : Arrays.asList(e);
                    }
                    if (entries == null) continue;
                    boolean related = relatedFiles.contains(file);
                    for (Entry e : entries) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(file, e, kind, related));
                    }
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
        this.cancelled = true;
    }
}

