/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import javax.swing.Action;
import org.netbeans.modules.derby.Bundle;
import org.netbeans.modules.derby.ConnectDatabaseAction;
import org.netbeans.modules.derby.DerbyDatabasesImpl;
import org.netbeans.modules.derby.DerbyOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class DerbyDatabaseNode
extends AbstractNode
implements Comparable {
    private static final String ICON_BASE = "org/netbeans/modules/derby/resources/database.gif";
    private String database;
    private DerbyDatabasesImpl server;

    public DerbyDatabaseNode(String dbName, DerbyDatabasesImpl server) {
        super(Children.LEAF);
        this.database = dbName;
        this.server = server;
        this.setName(dbName);
        this.setDisplayName(dbName);
        this.setShortDescription(NbBundle.getMessage(DerbyDatabaseNode.class, (String)"DerbyDatabaseNode_ShortDescription", (Object)dbName, (Object)DerbyOptions.getDefault().getLocation()));
        this.setIconBaseWithExtension(ICON_BASE);
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return super.getActions(context);
        }
        return new SystemAction[]{SystemAction.get(ConnectDatabaseAction.class), SystemAction.get(DeleteAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_Confirm_DB_Delete(this.database), Bundle.MSG_Confirm_DB_Delete_Title(), 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        if (NotifyDescriptor.OK_OPTION.equals(result)) {
            this.server.dropDatabase(this.database);
        }
    }

    public int compareTo(Object other) {
        Node othernode = (Node)other;
        return this.getDisplayName().compareTo(othernode.getDisplayName());
    }
}

