/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.Bundle;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class AttachedPropertyItem
extends AbstractCompletionItem {
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/property-static.png";
    private final String classPrefix;
    private final String propertyName;
    private final String propertySamples;
    private final String type;
    private final boolean primitive;
    private boolean attribute;
    private static ImageIcon ICON = null;

    public AttachedPropertyItem(CompletionContext ctx, String text, String classPrefix, String propertySamples) {
        super(ctx, text);
        this.classPrefix = classPrefix;
        this.propertySamples = propertySamples;
        this.primitive = false;
        this.type = null;
        this.propertyName = null;
    }

    public AttachedPropertyItem(CompletionContext ctx, String text, String propertyName, String type, boolean primitive) {
        super(ctx, text);
        this.propertyName = propertyName;
        this.primitive = primitive;
        this.type = type;
        this.classPrefix = null;
        this.propertySamples = null;
    }

    public void setAttribute(boolean attribute) {
        this.attribute = attribute;
    }

    @Override
    protected String getSubstituteText() {
        boolean replaceExisting = this.ctx.isReplaceExisting();
        if (this.attribute) {
            if (replaceExisting || this.type == null) {
                return super.getSubstituteText();
            }
            return super.getSubstituteText() + "=\"\" ";
        }
        if (replaceExisting || this.type == null) {
            return "<" + super.getSubstituteText();
        }
        return "<" + super.getSubstituteText() + "></" + super.getSubstituteText() + ">";
    }

    @Override
    protected String getLeftHtmlText() {
        if (this.classPrefix != null) {
            return Bundle.FMT_attachedPropertyClassLeft(this.classPrefix, this.propertySamples);
        }
        return Bundle.FMT_attachedPropertyLeft(this.propertyName);
    }

    @Override
    protected int getCaretShift(Document d) {
        if (this.classPrefix != null) {
            return super.getCaretShift(d);
        }
        if (!this.attribute) {
            return 2 + super.getSubstituteText().length();
        }
        return super.getCaretShift(d) - 2;
    }

    @Override
    protected String getRightHtmlText() {
        if (this.classPrefix != null) {
            return null;
        }
        if (this.type == null) {
            return null;
        }
        if (this.primitive) {
            return NbBundle.getMessage(AttachedPropertyItem.class, (String)"FMT_PrimitiveType", (Object)this.type);
        }
        return NbBundle.getMessage(AttachedPropertyItem.class, (String)"FMT_DeclaredType", (Object)this.type);
    }

    @Override
    protected ImageIcon getIcon() {
        if (ICON == null) {
            ICON = ImageUtilities.loadImageIcon((String)ICON_RESOURCE, (boolean)false);
        }
        return ICON;
    }

    public String toString() {
        return "staticProperty[" + this.propertyName + "]";
    }
}

