/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.MfaTotpDeviceSummary;
import com.oracle.bmc.identity.requests.ActivateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.responses.ActivateMfaTotpDeviceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateMfaTotpDeviceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateMfaTotpDeviceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ActivateMfaTotpDeviceRequest interceptRequest(ActivateMfaTotpDeviceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ActivateMfaTotpDeviceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMfaTotpDeviceId(), (String)"mfaTotpDeviceId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getMfaTotpToken(), (String)"mfaTotpToken is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("users").path(HttpUtils.encodePathSegment((String)request.getUserId())).path("mfaTotpDevices").path(HttpUtils.encodePathSegment((String)request.getMfaTotpDeviceId())).path("actions").path("activate");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ActivateMfaTotpDeviceResponse> fromResponse() {
        Function<Response, ActivateMfaTotpDeviceResponse> transformer = new Function<Response, ActivateMfaTotpDeviceResponse>(){

            public ActivateMfaTotpDeviceResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.ActivateMfaTotpDeviceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(MfaTotpDeviceSummary.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ActivateMfaTotpDeviceResponse.Builder builder = ActivateMfaTotpDeviceResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.mfaTotpDeviceSummary((MfaTotpDeviceSummary)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                ActivateMfaTotpDeviceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

