/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.AuthToken;
import com.oracle.bmc.identity.requests.ListAuthTokensRequest;
import com.oracle.bmc.identity.responses.ListAuthTokensResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListAuthTokensConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListAuthTokensConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListAuthTokensRequest interceptRequest(ListAuthTokensRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListAuthTokensRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("users").path(HttpUtils.encodePathSegment((String)request.getUserId())).path("authTokens");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListAuthTokensResponse> fromResponse() {
        Function<Response, ListAuthTokensResponse> transformer = new Function<Response, ListAuthTokensResponse>(){

            public ListAuthTokensResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.ListAuthTokensResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<AuthToken>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListAuthTokensResponse.Builder builder = ListAuthTokensResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListAuthTokensResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

