/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.navigation.actions.NameActions;
import org.netbeans.modules.java.navigation.actions.SortActions;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.openide.util.NbPreferences;

public abstract class Filters<T> {
    private static final String PROP_NATURAL_SORT = "naturalSort";
    private static final String PROP_FQN = "fqn";
    private volatile boolean naturalSort = NbPreferences.forModule(this.getClass()).getBoolean("naturalSort", false);
    private volatile boolean fqn = NbPreferences.forModule(this.getClass()).getBoolean("fqn", false);
    private FiltersManager filtersManager;
    private JToggleButton sortByNameButton;
    private JToggleButton sortByPositionButton;
    private JToggleButton fqNameButton;

    protected Filters() {
    }

    public final boolean isNaturalSort() {
        return this.naturalSort;
    }

    public final void setNaturalSort(boolean naturalSort) {
        this.naturalSort = naturalSort;
        NbPreferences.forModule(this.getClass()).putBoolean(PROP_NATURAL_SORT, naturalSort);
        if (null != this.sortByNameButton) {
            this.sortByNameButton.setSelected(!naturalSort);
        }
        if (null != this.sortByPositionButton) {
            this.sortByPositionButton.setSelected(naturalSort);
        }
        this.sortUpdated();
    }

    public boolean isFqn() {
        return this.fqn;
    }

    public void setFqn(boolean fqn) {
        this.fqn = fqn;
        NbPreferences.forModule(this.getClass()).putBoolean(PROP_FQN, fqn);
        if (null != this.fqNameButton) {
            this.fqNameButton.setSelected(fqn);
        }
        this.fqnUpdated();
    }

    public final JComponent getComponent() {
        FiltersManager fm = this.getFiltersManager();
        AbstractButton[] nameButtons = this.createNameButtons();
        AbstractButton[] sortButtons = this.createSortButtons();
        AbstractButton[] customButtons = this.createCustomButtons();
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>(nameButtons.length + customButtons.length + sortButtons.length + 2);
        buttons.addAll(Arrays.asList(nameButtons));
        if (!buttons.isEmpty() && sortButtons.length > 0) {
            buttons.add(null);
        }
        buttons.addAll(Arrays.asList(sortButtons));
        if (!buttons.isEmpty() && customButtons.length > 0) {
            buttons.add(null);
        }
        buttons.addAll(Arrays.asList(customButtons));
        return fm.getComponent(buttons);
    }

    public final synchronized FiltersManager getFiltersManager() {
        if (this.filtersManager == null) {
            this.filtersManager = this.createFilters();
        }
        return this.filtersManager;
    }

    public abstract Collection<T> filter(Collection<? extends T> var1);

    protected abstract FiltersManager createFilters();

    protected abstract void sortUpdated();

    protected abstract void fqnUpdated();

    @NonNull
    protected AbstractButton[] createNameButtons() {
        assert (SwingUtilities.isEventDispatchThread());
        AbstractButton[] res = new AbstractButton[1];
        if (null == this.fqNameButton) {
            this.fqNameButton = new JToggleButton(NameActions.createFullyQualifiedNameAction(this));
            this.fqNameButton.setToolTipText(this.fqNameButton.getText());
            this.fqNameButton.setText(null);
            this.fqNameButton.setSelected(this.isFqn());
            this.fqNameButton.setFocusable(false);
        }
        res[0] = this.fqNameButton;
        return res;
    }

    @NonNull
    protected AbstractButton[] createSortButtons() {
        assert (SwingUtilities.isEventDispatchThread());
        AbstractButton[] res = new JToggleButton[2];
        if (null == this.sortByNameButton) {
            this.sortByNameButton = new JToggleButton(SortActions.createSortByNameAction(this));
            this.sortByNameButton.setToolTipText(this.sortByNameButton.getText());
            this.sortByNameButton.setText(null);
            this.sortByNameButton.setSelected(!this.isNaturalSort());
            this.sortByNameButton.setFocusable(false);
        }
        res[0] = this.sortByNameButton;
        if (null == this.sortByPositionButton) {
            this.sortByPositionButton = new JToggleButton(SortActions.createSortBySourceAction(this));
            this.sortByPositionButton.setToolTipText(this.sortByPositionButton.getText());
            this.sortByPositionButton.setText(null);
            this.sortByPositionButton.setSelected(this.isNaturalSort());
            this.sortByPositionButton.setFocusable(false);
        }
        res[1] = this.sortByPositionButton;
        return res;
    }

    @NonNull
    protected AbstractButton[] createCustomButtons() {
        return new AbstractButton[0];
    }
}

