/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.rename.BaseTldRename;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;

public class TldPackageRename
extends BaseTldRename {
    private final RenameRefactoring rename;
    private final FileObject pkg;

    public TldPackageRename(RenameRefactoring rename, WebModule webModule, FileObject pkg) {
        super(webModule);
        this.rename = rename;
        this.pkg = pkg;
    }

    @Override
    protected List<RenameItem> getAffectedClasses() {
        ArrayList<FileObject> affectedClasses = new ArrayList<FileObject>();
        RefactoringUtil.collectChildren(this.pkg, affectedClasses);
        ArrayList<RenameItem> result = new ArrayList<RenameItem>();
        for (FileObject affected : affectedClasses) {
            if (RefactoringUtil.isPackageInfo(affected)) continue;
            String oldName = JavaIdentifiers.getQualifiedName((FileObject)affected);
            String newName = RefactoringUtil.constructNewName(affected, this.rename);
            result.add(new RenameItem(newName, oldName));
        }
        return result;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.rename;
    }
}

