/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.GlobalPropertyNode;
import com.oracle.truffle.js.nodes.access.GlobalScopeLookupNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.access.WritePropertyNode;
import com.oracle.truffle.js.runtime.Errors;
import java.util.Objects;
import java.util.Set;

public final class GlobalScopeVarWrapperNode
extends JavaScriptNode
implements ReadNode,
WriteNode {
    private final String varName;
    @Node.Child
    private JavaScriptNode dynamicScopeNode;
    @Node.Child
    private JavaScriptNode defaultDelegate;
    @Node.Child
    private JSTargetableNode scopeAccessNode;
    @Node.Child
    private GlobalScopeLookupNode scopeHasBinding;

    public GlobalScopeVarWrapperNode(String varName, JavaScriptNode defaultDelegate, JavaScriptNode dynamicScope, JSTargetableNode scopeAccessNode) {
        this.varName = varName;
        this.dynamicScopeNode = dynamicScope;
        this.defaultDelegate = Objects.requireNonNull(defaultDelegate);
        this.scopeAccessNode = scopeAccessNode;
        this.scopeHasBinding = GlobalScopeLookupNode.create(varName, this.isWrite());
    }

    public JavaScriptNode getDelegateNode() {
        return this.defaultDelegate;
    }

    public String getPropertyName() {
        return this.varName;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return false;
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    private boolean isWrite() {
        return this.scopeAccessNode instanceof WritePropertyNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object dynamicScope = this.dynamicScopeNode.execute(frame);
        if (this.scopeHasBinding.execute(dynamicScope)) {
            if (this.isWrite()) {
                Object value = ((WriteNode)((Object)this.defaultDelegate)).getRhs().execute(frame);
                ((WritePropertyNode)this.scopeAccessNode).executeWithValue(dynamicScope, value);
                return value;
            }
            return this.scopeAccessNode.executeWithTarget(frame, dynamicScope);
        }
        return this.defaultDelegate.execute(frame);
    }

    @Override
    public Object executeWrite(VirtualFrame frame, Object value) {
        throw Errors.shouldNotReachHere();
    }

    @Override
    public JavaScriptNode getRhs() {
        return ((WriteNode)((Object)this.defaultDelegate)).getRhs();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GlobalScopeVarWrapperNode(this.varName, GlobalScopeVarWrapperNode.cloneUninitialized(this.defaultDelegate, materializedTags), GlobalScopeVarWrapperNode.cloneUninitialized(this.dynamicScopeNode, materializedTags), GlobalScopeVarWrapperNode.cloneUninitialized(this.scopeAccessNode, materializedTags));
    }

    public void setMethod() {
        if (this.defaultDelegate instanceof GlobalPropertyNode) {
            ((GlobalPropertyNode)this.defaultDelegate).setMethod();
        }
    }
}

