/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.FrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSReadCurrentFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.JSReadScopeFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.JSReadScopeFrameSlotWithTDZNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.JSFrameUtil;

@ImportStatic(value={FrameSlotKind.class})
public abstract class JSReadFrameSlotNode
extends FrameSlotNode
implements RepeatableNode,
ReadNode {
    JSReadFrameSlotNode(FrameSlot slot) {
        super(slot);
    }

    public static JSReadFrameSlotNode create(FrameSlot slot, ScopeFrameNode levelFrameNode, boolean hasTemporalDeadZone) {
        if (hasTemporalDeadZone) {
            return JSReadScopeFrameSlotWithTDZNodeGen.create(slot, levelFrameNode);
        }
        return JSReadScopeFrameSlotNodeGen.create(slot, levelFrameNode);
    }

    public static JSReadFrameSlotNode create(FrameSlot slot, int frameLevel, int scopeLevel, FrameSlot[] parentSlots, boolean hasTemporalDeadZone) {
        if (frameLevel == 0 && scopeLevel == 0 && !hasTemporalDeadZone) {
            return JSReadCurrentFrameSlotNodeGen.create(slot);
        }
        return JSReadFrameSlotNode.create(slot, ScopeFrameNode.create(frameLevel, scopeLevel, parentSlots), hasTemporalDeadZone);
    }

    public static JSReadFrameSlotNode create(FrameSlot slot) {
        if (JSFrameUtil.hasTemporalDeadZone(slot)) {
            return JSReadScopeFrameSlotWithTDZNodeGen.create(slot, ScopeFrameNode.createCurrent());
        }
        return JSReadCurrentFrameSlotNodeGen.create(slot);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ReadVariableTag.class || tag == StandardTags.ReadVariableTag.class) {
            if (JSFrameUtil.isInternal(this.frameSlot)) {
                return JSFrameUtil.isThisSlot(this.frameSlot);
            }
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        String name = JSFrameUtil.getPublicName(this.frameSlot);
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", name);
        descriptor.addProperty("readVariableName", name);
        return descriptor;
    }

    @Override
    public String expressionToString() {
        if (this.frameSlot.getIdentifier() instanceof String) {
            return (String)this.frameSlot.getIdentifier();
        }
        return null;
    }
}

