/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.CreateResolvingFunctionNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;

public class PromiseResolveThenableNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private CreateResolvingFunctionNode createResolvingFunctions;
    @Node.Child
    private JSFunctionCallNode callResolveNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    private final ValueProfile typeProfile = ValueProfile.createClassProfile();

    protected PromiseResolveThenableNode(JSContext context) {
        this.context = context;
        this.createResolvingFunctions = CreateResolvingFunctionNode.create(context);
        this.callResolveNode = JSFunctionCallNode.createCall();
    }

    public static PromiseResolveThenableNode create(JSContext context) {
        return new PromiseResolveThenableNode(context);
    }

    public Object execute(DynamicObject promiseToResolve, Object thenable, Object then) {
        Pair<DynamicObject, DynamicObject> resolvingFunctions = this.createResolvingFunctions.execute(promiseToResolve);
        DynamicObject resolve = resolvingFunctions.getFirst();
        DynamicObject reject = resolvingFunctions.getSecond();
        try {
            return this.callResolveNode.executeCall(JSArguments.create(thenable, then, resolve, reject));
        }
        catch (Throwable ex) {
            if (this.shouldCatch(ex)) {
                return this.callReject().executeCall(JSArguments.create((Object)Undefined.instance, reject, this.getErrorObjectNode.execute(ex)));
            }
            throw ex;
        }
    }

    private boolean shouldCatch(Throwable exception) {
        if (this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        return TryCatchNode.shouldCatch(exception, this.typeProfile);
    }

    private JSFunctionCallNode callReject() {
        if (this.callRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return this.callRejectNode;
    }
}

