/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.actions;

import java.awt.EventQueue;
import java.io.File;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.ui.customizer.NodeJsCustomizerProvider;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.RunInfo;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

abstract class Command {
    protected final Project project;

    Command(Project project) {
        assert (project != null);
        this.project = project;
    }

    public abstract String getCommandId();

    public abstract boolean isEnabled(Lookup var1);

    abstract void runInternal(Lookup var1);

    abstract ValidationResult validateRunInfo(RunInfo var1);

    public void run(Lookup context) {
        assert (!EventQueue.isDispatchThread());
        this.runInternal(context);
    }

    @CheckForNull
    protected NodeExecutable getNode() {
        return NodeExecutable.forProject(this.project, true);
    }

    @CheckForNull
    protected RunInfo getRunInfo() {
        RunInfo runInfo = new RunInfo(this.project);
        ValidationResult result = this.validateRunInfo(runInfo);
        if (!result.isFaultless()) {
            NodeJsCustomizerProvider.openCustomizer(this.project, result);
            return null;
        }
        return runInfo;
    }

    @CheckForNull
    protected FileObject lookupFileObject(Lookup context) {
        return (FileObject)context.lookup(FileObject.class);
    }

    @CheckForNull
    protected File lookupFile(Lookup context) {
        FileObject fo = this.lookupFileObject(context);
        if (fo == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fo);
        assert (file != null) : fo;
        return file;
    }

    @CheckForNull
    protected File lookupJavaScriptFile(Lookup context) {
        FileObject file = this.lookupFileObject(context);
        if (file == null) {
            return null;
        }
        if (!FileUtils.isJavaScriptFile(file)) {
            return null;
        }
        return FileUtil.toFile((FileObject)file);
    }
}

