/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.spi;

import java.io.File;
import java.io.IOException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.modules.SpecificationVersion;

public interface NbModuleProvider {
    @CheckForNull
    public String getSpecVersion();

    public String getCodeNameBase();

    public String getSourceDirectoryPath();

    public String getTestSourceDirectoryPath();

    public String getResourceDirectoryPath(boolean var1);

    public String getReleaseDirectoryPath();

    public FileObject getReleaseDirectory() throws IOException;

    public String getProjectFilePath();

    public FileObject getSourceDirectory();

    @CheckForNull
    public FileObject getManifestFile();

    public void addDependencies(@NonNull ModuleDependency[] var1) throws IOException;

    public void addModulesToTargetPlatform(@NonNull ModuleDependency[] var1) throws IOException;

    @CheckForNull
    public SpecificationVersion getDependencyVersion(String var1) throws IOException;

    public boolean hasDependency(String var1) throws IOException;

    @CheckForNull
    public File getModuleJarLocation();

    @CheckForNull
    public File getClassesDirectory();

    @NonNull
    public FileSystem getEffectiveSystemFilesystem() throws IOException;

    public static final class ModuleDependency {
        private final String codeNameBase;
        private final String releaseVersion;
        private final SpecificationVersion version;
        private final boolean useInCompiler;
        private boolean testDependency = false;
        private final String clusterName;

        public ModuleDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) {
            this.codeNameBase = codeNameBase;
            this.releaseVersion = releaseVersion;
            this.version = version;
            this.useInCompiler = useInCompiler;
            this.clusterName = null;
        }

        public ModuleDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler, String clusterName) {
            this.codeNameBase = codeNameBase;
            this.releaseVersion = releaseVersion;
            this.version = version;
            this.useInCompiler = useInCompiler;
            this.clusterName = clusterName;
        }

        public String getCodeNameBase() {
            return this.codeNameBase;
        }

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public SpecificationVersion getVersion() {
            return this.version;
        }

        public boolean isUseInCompiler() {
            return this.useInCompiler;
        }

        public boolean isTestDependency() {
            return this.testDependency;
        }

        public void setTestDependency(boolean isTestDependency) {
            this.testDependency = isTestDependency;
        }

        public String getClusterName() {
            return this.clusterName;
        }
    }
}

