/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.core.SQLOptions;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.loader.Bundle;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="sql.source", iconBase="org/netbeans/modules/db/sql/loader/resources/sql16.png", persistenceType=1)
public final class SQLCloneableEditor
extends CloneableEditor
implements MultiViewElement {
    private transient JSplitPane splitter;
    private transient Integer splitterLastPosition;
    private transient JTabbedPane resultComponent;
    private transient JPopupMenu resultPopupMenu;
    private transient Action closeTabAction;
    private transient Action closeOtherTabsAction;
    private transient Action closeAllTabsAction;
    private transient Action closePreviousTabsAction;
    private transient Component editor;
    private transient List<Component> currentResultTabs;
    private transient SQLExecutionImpl sqlExecution;
    private transient Lookup originalLookup;
    private transient InstanceContent instanceContent = new InstanceContent();
    private transient Lookup ourLookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private transient SQLCloneableEditorLookup resultingLookup;
    private MultiViewElementCallback callback;
    private transient JToolBar bar;

    public SQLCloneableEditor() {
        super(null);
        this.putClientProperty("oldInitialize", Boolean.TRUE);
    }

    public SQLCloneableEditor(Lookup context) {
        super((CloneableEditorSupport)context.lookup(SQLEditorSupport.class));
        SQLEditorSupport support = (SQLEditorSupport)context.lookup(SQLEditorSupport.class);
        this.setActivatedNodes(new Node[]{support.getDataObject().getNodeDelegate()});
        this.putClientProperty("oldInitialize", Boolean.TRUE);
        this.initialize();
    }

    void setResults(List<Component> results) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.resultComponent == null && results != null) {
            this.createResultComponent();
        }
        if (this.resultComponent != null) {
            this.populateResults(results);
        }
    }

    private void populateResults(List<Component> components) {
        if (this.currentResultTabs != null && this.closePreviousTabsAction != null) {
            this.closePreviousTabsAction.setEnabled(true);
        } else {
            this.closePreviousTabsAction.setEnabled(false);
        }
        if (components == null) {
            return;
        }
        this.currentResultTabs = components;
        if (!SQLOptions.getDefault().isKeepOldResultTabs()) {
            this.resultComponent.removeAll();
        }
        for (int i = 0; i < components.size(); ++i) {
            Component comp = components.get(i);
            this.resultComponent.add(comp);
            String tooltip = null;
            if (comp instanceof JComponent) {
                tooltip = ((JComponent)comp).getToolTipText();
            }
            this.resultComponent.setToolTipTextAt(this.resultComponent.getTabCount() - 1, tooltip);
        }
        if (components.size() > 0) {
            this.resultComponent.setSelectedComponent(components.get(0));
        }
        this.showResultComponent();
    }

    private void createResultComponent() {
        JPanel container = this.findContainer((Component)((Object)this));
        if (container == null) {
            return;
        }
        this.resultComponent = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.createResultPopupMenu();
        this.editor = container.getComponent(0);
        container.removeAll();
        this.splitter = new JSplitPane(0, this.editor, this.resultComponent);
        this.splitter.setBorder(null);
        container.add(this.splitter);
        if (this.splitterLastPosition != null && this.splitterLastPosition < container.getHeight() - 20) {
            this.splitter.setDividerLocation(this.splitterLastPosition);
        } else {
            this.splitter.setDividerLocation(Math.min(container.getHeight() / 2, 250));
        }
        this.splitter.setDividerSize(7);
        container.invalidate();
        container.validate();
        container.repaint();
        this.showResultComponent();
        this.getActionMap().setParent(new DelegateActionMap(this.getActionMap().getParent(), this.getEditorPane()));
        if (((Object)((Object)this)).equals(TopComponent.getRegistry().getActivated())) {
            this.requestFocusInWindow();
        }
    }

    private void createResultPopupMenu() {
        this.closeTabAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_TAB_ACTION", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLCloneableEditor.this.resultComponent.remove(SQLCloneableEditor.this.resultComponent.getSelectedComponent());
                SQLCloneableEditor.this.enableTabActions();
                if (SQLCloneableEditor.this.resultComponent.getTabCount() == 0) {
                    SQLCloneableEditor.this.hideResultComponent();
                }
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.closeOtherTabsAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_OTHER_TABS_ACTION", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component component : SQLCloneableEditor.this.resultComponent.getComponents()) {
                    if (component instanceof UIResource || component.equals(SQLCloneableEditor.this.resultComponent.getSelectedComponent())) continue;
                    SQLCloneableEditor.this.resultComponent.remove(component);
                    SQLCloneableEditor.this.enableTabActions();
                }
                this.setEnabled(false);
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.closePreviousTabsAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_PREVIOUS_TABS_ACTION", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component component : SQLCloneableEditor.this.resultComponent.getComponents()) {
                    if (component instanceof UIResource || SQLCloneableEditor.this.currentResultTabs == null || SQLCloneableEditor.this.currentResultTabs.contains(component)) continue;
                    SQLCloneableEditor.this.resultComponent.remove(component);
                    SQLCloneableEditor.this.enableTabActions();
                }
                this.setEnabled(false);
                if (SQLCloneableEditor.this.resultComponent.getTabCount() == 0) {
                    SQLCloneableEditor.this.hideResultComponent();
                }
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.closeAllTabsAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_ALL_TABS_ACTION", new String[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLCloneableEditor.this.resultComponent.removeAll();
                SQLCloneableEditor.this.hideResultComponent();
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.resultPopupMenu = new JPopupMenu();
        this.resultPopupMenu.add(this.closeTabAction);
        this.resultPopupMenu.add(this.closeOtherTabsAction);
        this.resultPopupMenu.add(this.closePreviousTabsAction);
        this.resultPopupMenu.add(this.closeAllTabsAction);
        this.resultComponent.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent evt) {
                SQLCloneableEditor.this.resultPopupMenu.show(SQLCloneableEditor.this.resultComponent, evt.getX(), evt.getY());
            }
        });
        this.resultComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SQLCloneableEditor.this.enableTabActions();
            }
        });
        this.resultComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("close".equals(evt.getPropertyName())) {
                    int selected = SQLCloneableEditor.this.resultComponent.getSelectedIndex();
                    SQLCloneableEditor.this.resultComponent.remove((Component)evt.getNewValue());
                    SQLCloneableEditor.this.enableTabActions();
                    int tabCount = SQLCloneableEditor.this.resultComponent.getTabCount();
                    if (selected > 0) {
                        --selected;
                    }
                    if (selected >= 0 && selected < tabCount) {
                        SQLCloneableEditor.this.resultComponent.setSelectedIndex(selected);
                    }
                    if (tabCount == 0) {
                        SQLCloneableEditor.this.hideResultComponent();
                    }
                    SQLCloneableEditor.this.revalidate();
                }
            }
        });
    }

    private void enableTabActions() {
        int numtabs = this.resultComponent.getTabCount();
        if (numtabs == 0) {
            this.hideResultComponent();
        } else if (numtabs == 1) {
            this.closeAllTabsAction.setEnabled(true);
            this.closeOtherTabsAction.setEnabled(false);
            this.closePreviousTabsAction.setEnabled(false);
        } else {
            this.closeAllTabsAction.setEnabled(true);
            this.closeOtherTabsAction.setEnabled(true);
        }
    }

    private static String getMessage(String key, String ... params) {
        return NbBundle.getMessage(SQLCloneableEditor.class, (String)key, (Object[])params);
    }

    private void hideResultComponent() {
        if (this.splitter == null) {
            return;
        }
        this.splitterLastPosition = this.splitter.getDividerLocation();
        this.splitter.setBottomComponent(null);
    }

    private void showResultComponent() {
        JPanel container = this.findContainer((Component)((Object)this));
        if (container == null) {
            return;
        }
        if (this.splitter == null) {
            return;
        }
        if (this.splitter.getBottomComponent() == null) {
            this.splitter.setBottomComponent(this.resultComponent);
            if (this.splitterLastPosition != null && this.splitterLastPosition < container.getHeight() - 20) {
                this.splitter.setDividerLocation(this.splitterLastPosition);
            } else {
                this.splitter.setDividerLocation(Math.min(container.getHeight() / 2, 250));
            }
            this.splitter.setDividerSize(7);
            container.invalidate();
            container.validate();
            container.repaint();
        }
        this.enableTabActions();
    }

    private JPanel findContainer(Component parent) {
        if (!(parent instanceof JComponent)) {
            return null;
        }
        Component[] components = ((JComponent)parent).getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof JPanel && "sqlEditorContainer".equals(component.getName())) {
                return (JPanel)component;
            }
            JPanel container = this.findContainer(component);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    public synchronized Lookup getLookup() {
        Lookup currentLookup = super.getLookup();
        if (currentLookup != this.originalLookup) {
            this.originalLookup = currentLookup;
            if (this.resultingLookup == null) {
                this.resultingLookup = new SQLCloneableEditorLookup();
            }
            this.resultingLookup.updateLookups(new Lookup[]{this.originalLookup, this.ourLookup});
        }
        return this.resultingLookup;
    }

    public void componentDeactivated() {
        SQLEditorSupport sqlEditorSupport = this.sqlEditorSupport();
        if (sqlEditorSupport.isConsole() && sqlEditorSupport.isValid()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        super.componentDeactivated();
    }

    public void componentClosed() {
        if (this.sqlExecution != null) {
            this.sqlExecution.editorClosed();
        }
        super.componentClosed();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.sqlEditorSupport().isConsole()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        super.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    void initialize() {
        this.sqlExecution = new SQLExecutionImpl();
        this.instanceContent.add((Object)this.sqlExecution);
        this.instanceContent.add((Object)this);
    }

    private SQLEditorSupport sqlEditorSupport() {
        return (SQLEditorSupport)this.cloneableEditorSupport();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        Document doc = this.getEditorPane().getDocument();
        if (doc instanceof NbDocument.CustomToolbar && this.bar == null) {
            this.bar = ((NbDocument.CustomToolbar)doc).createToolbar(this.getEditorPane());
        }
        if (this.bar == null) {
            this.bar = new JToolBar();
        }
        return this.bar;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
        this.updateName();
    }

    public CloseOperationState canCloseElement() {
        Savable sav;
        if (this.sqlEditorSupport().isConsole()) {
            return CloseOperationState.STATE_OK;
        }
        DataObject sqlDO = this.sqlEditorSupport().getDataObject();
        FileObject sqlFO = this.sqlEditorSupport().getDataObject().getPrimaryFile();
        if (sqlDO.isModified() && sqlFO.canWrite() && (sav = (Savable)sqlDO.getLookup().lookup(Savable.class)) != null) {
            AbstractAction save = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SQLCloneableEditor.this.sqlEditorSupport().saveDocument();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            save.putValue("LongDescription", Bundle.MSG_SaveModified(sqlFO.getNameExt()));
            return MultiViewFactory.createUnsafeCloseState((String)"editor", (Action)save, null);
        }
        return CloseOperationState.STATE_OK;
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        if (this.callback != null) {
            this.updateName();
        }
        super.componentShowing();
    }

    public void requestVisible() {
        if (this.callback != null) {
            this.callback.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.callback != null) {
            this.callback.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void updateName() {
        super.updateName();
        if (this.callback != null) {
            TopComponent tc = this.callback.getTopComponent();
            tc.setHtmlDisplayName(this.getHtmlDisplayName());
            tc.setDisplayName(this.getDisplayName());
            tc.setName(this.getName());
            tc.setToolTipText(this.getToolTipText());
        }
    }

    public void open() {
        if (this.callback != null) {
            this.callback.requestVisible();
        } else {
            super.open();
        }
    }

    protected boolean closeLast() {
        return super.closeLast(false);
    }

    private final class SQLExecutionImpl
    implements SQLExecution,
    PropertyChangeListener {
        private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

        public SQLExecutionImpl() {
            SQLCloneableEditor.this.sqlEditorSupport().addSQLPropertyChangeListener(this);
        }

        private void editorClosed() {
            SQLCloneableEditor.this.sqlEditorSupport().removeSQLPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            this.propChangeSupport.firePropertyChange(event);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propChangeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propChangeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public DatabaseConnection getDatabaseConnection() {
            return SQLCloneableEditor.this.sqlEditorSupport().getDatabaseConnection();
        }

        @Override
        public void setDatabaseConnection(DatabaseConnection dbconn) {
            SQLCloneableEditor.this.sqlEditorSupport().setDatabaseConnection(dbconn);
        }

        @Override
        public void execute() {
            String text = (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    return SQLExecutionImpl.this.getText(SQLCloneableEditor.this.getEditorPane());
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(text, 0, text.length(), SQLCloneableEditor.this);
        }

        @Override
        public void executeSelection() {
            final int[] offsets = new int[2];
            String text = (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    int endOffset;
                    JEditorPane editorPane = SQLCloneableEditor.this.getEditorPane();
                    int startOffset = editorPane.getSelectionStart();
                    if (startOffset == (endOffset = editorPane.getSelectionEnd())) {
                        offsets[0] = editorPane.getCaretPosition();
                        offsets[1] = offsets[0];
                    } else {
                        offsets[0] = startOffset;
                        offsets[1] = endOffset;
                    }
                    return SQLExecutionImpl.this.getText(editorPane);
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(text, offsets[0], offsets[1], SQLCloneableEditor.this);
        }

        @Override
        public boolean isExecuting() {
            return SQLCloneableEditor.this.sqlEditorSupport().isExecuting();
        }

        @Override
        public boolean isSelection() {
            Boolean result = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    JEditorPane editorPane = SQLCloneableEditor.this.getEditorPane();
                    if (editorPane == null) {
                        return false;
                    }
                    return editorPane.getSelectionStart() < editorPane.getSelectionEnd();
                }
            });
            return result;
        }

        public String toString() {
            return "SQLExecution[support=" + SQLCloneableEditor.this.sqlEditorSupport().messageName() + ", dbconn=" + SQLCloneableEditor.this.sqlEditorSupport().getDatabaseConnection() + "]";
        }

        private String getText(JEditorPane editorPane) {
            Document doc = editorPane.getDocument();
            try {
                return doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
                return "";
            }
        }

        @Override
        public void showHistory() {
            SQLCloneableEditor.this.getComponent().setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SQLHistoryPanel panel = new SQLHistoryPanel(SQLCloneableEditor.this.getEditorPane());
                        Object[] options = new Object[]{DialogDescriptor.CLOSED_OPTION};
                        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(SQLCloneableEditor.class, (String)"LBL_SQL_HISTORY_TITLE"), false, options, DialogDescriptor.CLOSED_OPTION, 0, new HelpCtx("sql_history"), null);
                        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                        dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLCloneableEditor.class, (String)"ACSD_DLG"));
                        dlg.setVisible(true);
                    }
                    finally {
                        SQLCloneableEditor.this.getComponent().setCursor(null);
                    }
                }
            });
        }
    }

    private static final class SQLCloneableEditorLookup
    extends ProxyLookup {
        public SQLCloneableEditorLookup() {
            super(new Lookup[0]);
        }

        public void updateLookups(Lookup[] lookups) {
            this.setLookups(lookups);
        }
    }

    private static final class DelegateActionMap
    extends ActionMap {
        private ActionMap delegate;
        private JEditorPane editorPane;

        public DelegateActionMap(ActionMap delegate, JEditorPane editorPane) {
            this.delegate = delegate;
            this.editorPane = editorPane;
        }

        @Override
        public void remove(Object key) {
            super.remove(key);
        }

        @Override
        public Action get(Object key) {
            boolean isEditorPaneFocused;
            boolean bl = isEditorPaneFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this.editorPane;
            if (isEditorPaneFocused) {
                return this.delegate.get(key);
            }
            return null;
        }

        @Override
        public void put(Object key, Action action) {
            this.delegate.put(key, action);
        }

        @Override
        public void setParent(ActionMap map) {
            this.delegate.setParent(map);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Object[] keys() {
            return this.delegate.keys();
        }

        @Override
        public ActionMap getParent() {
            return this.delegate.getParent();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Object[] allKeys() {
            return this.delegate.allKeys();
        }
    }
}

