/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.credentials;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.docker.api.Credentials;
import org.netbeans.modules.docker.api.CredentialsManager;
import org.netbeans.modules.docker.ui.credentials.CredentialsUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CredentialsListPanel
extends JPanel {
    private final DefaultListModel<CredentialsItem> model = new DefaultListModel();
    private JButton addButton;
    private JList<CredentialsItem> credentialsList;
    private JButton editButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;

    public CredentialsListPanel() {
        this.initComponents();
        CredentialsManager manager = CredentialsManager.getDefault();
        try {
            for (Credentials c : manager.getAllCredentials()) {
                this.model.addElement(new CredentialsItem(c));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.credentialsList.setModel(this.model);
    }

    private Set<String> getRegistries() {
        HashSet<String> ret = new HashSet<String>(this.model.size());
        Enumeration<CredentialsItem> e = this.model.elements();
        while (e.hasMoreElements()) {
            CredentialsItem i = e.nextElement();
            ret.add(i.getCredentials().getRegistry());
        }
        return ret;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.credentialsList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.credentialsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CredentialsListPanel.this.credentialsListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.credentialsList);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CredentialsListPanel.class, (String)"CredentialsListPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CredentialsListPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CredentialsListPanel.class, (String)"CredentialsListPanel.removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CredentialsListPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CredentialsListPanel.class, (String)"CredentialsListPanel.editButton.text"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CredentialsListPanel.this.editButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 481, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.editButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Credentials credentials = CredentialsUtils.editCredentials(null, this.getRegistries());
        if (credentials != null) {
            this.model.addElement(new CredentialsItem(credentials));
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int index = this.credentialsList.getSelectedIndex();
        Credentials credentials = CredentialsUtils.editCredentials(this.credentialsList.getSelectedValue().getCredentials(), Collections.emptySet());
        if (credentials != null) {
            this.model.setElementAt(new CredentialsItem(credentials), index);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        for (CredentialsItem i : this.credentialsList.getSelectedValuesList()) {
            try {
                CredentialsManager.getDefault().removeCredentials(i.getCredentials());
                this.model.removeElement(i);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void credentialsListValueChanged(ListSelectionEvent evt) {
        boolean enable = !this.credentialsList.isSelectionEmpty();
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
    }

    private static class CredentialsItem {
        private final Credentials credentials;

        public CredentialsItem(Credentials credentials) {
            this.credentials = credentials;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public String toString() {
            return this.credentials.getRegistry();
        }
    }
}

