/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.layout.TableLayout;
import org.netbeans.modules.websvc.design.view.widget.TableModel;

public class TableWidget
extends Widget {
    private static final Color HEADER_COLOR = new Color(217, 235, 255);
    private static final Color CELL_COLOR = Color.WHITE;
    private static final Color BORDER_COLOR = new Color(169, 197, 235);
    private static final Color SELECTED_BORDER_COLOR = new Color(255, 153, 0);
    private TableModel model;
    private static final int COLUMN_WIDTH = 100;

    public TableWidget(Scene scene, TableModel model) {
        super(scene);
        this.model = model;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.createTableHeader();
        this.createTable();
    }

    private void createTableHeader() {
        Scene scene = this.getScene();
        int noCols = this.model.getColumnCount();
        RowWidget headerWidget = new RowWidget(scene, noCols, null);
        this.addChild(headerWidget);
        for (int i = 0; i < noCols; ++i) {
            LabelWidget columnHeader = new LabelWidget(scene, this.model.getColumnName(i));
            if (i != 0) {
                columnHeader.setBorder((Border)new LineBorder(0, 1, 0, 0, BORDER_COLOR));
            }
            columnHeader.setAlignment(LabelWidget.Alignment.CENTER);
            columnHeader.setBackground((Paint)HEADER_COLOR);
            columnHeader.setOpaque(true);
            headerWidget.addChild((Widget)columnHeader);
        }
    }

    private void createTable() {
        Scene scene = this.getScene();
        int noCols = this.model.getColumnCount();
        for (int j = 0; j < this.model.getRowCount(); ++j) {
            RowWidget rowWidget = new RowWidget(scene, noCols, this.model.getUserObject(j));
            this.addChild(rowWidget);
            for (int i = 0; i < noCols; ++i) {
                final int ii = i;
                final LabelWidget cellWidget = new LabelWidget(scene, this.model.getValueAt(j, i)){
                    private Object key;
                    {
                        super(scene, label);
                        this.key = new Object();
                    }

                    protected void notifyAdded() {
                        super.notifyAdded();
                        ObjectScene scene = (ObjectScene)this.getScene();
                        scene.addObject(this.key, new Widget[]{this});
                    }

                    protected void notifyRemoved() {
                        super.notifyRemoved();
                        ObjectScene scene = (ObjectScene)this.getScene();
                        scene.removeObject(this.key);
                    }

                    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
                        if (previousState.isSelected() != state.isSelected() || previousState.isFocused() != state.isFocused()) {
                            this.setBorder((Border)(state.isSelected() ? (state.isFocused() ? BorderFactory.createDashedBorder((Color)SELECTED_BORDER_COLOR, (int)2, (int)2, (boolean)true) : BorderFactory.createLineBorder((int)1, (Color)SELECTED_BORDER_COLOR)) : (state.isFocused() ? BorderFactory.createDashedBorder((Color)BORDER_COLOR, (int)2, (int)2, (boolean)true) : new LineBorder(0, ii != 0 ? 1 : 0, 0, 0, BORDER_COLOR))));
                            this.revalidate(true);
                        }
                    }
                };
                if (i != 0) {
                    cellWidget.setBorder((Border)new LineBorder(0, 1, 0, 0, BORDER_COLOR));
                }
                cellWidget.setFont(this.getScene().getFont().deriveFont(1));
                cellWidget.setBackground((Paint)CELL_COLOR);
                cellWidget.setOpaque(true);
                cellWidget.setAlignment(LabelWidget.Alignment.CENTER);
                if (this.model.isCellEditable(j, i)) {
                    final int row = j;
                    final int column = i;
                    cellWidget.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new TextFieldInplaceEditor(){

                        public boolean isEnabled(Widget widget) {
                            return true;
                        }

                        public String getText(Widget widget) {
                            return TableWidget.this.model.getValueAt(row, column);
                        }

                        public void setText(Widget widget, String text) {
                            TableWidget.this.model.setValueAt(text, row, column);
                            cellWidget.setLabel(text);
                        }
                    }));
                }
                rowWidget.addChild((Widget)cellWidget);
            }
        }
    }

    private static class LineBorder
    implements Border {
        private Insets insets;
        private Color drawColor;

        public LineBorder(int top, int left, int bottom, int right, Color drawColor) {
            this.insets = new Insets(top, left, bottom, right);
            this.drawColor = drawColor;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void paint(Graphics2D gr, Rectangle bounds) {
            Paint oldPaint = gr.getPaint();
            gr.setPaint(this.drawColor);
            if (this.insets.top > 0) {
                gr.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
            }
            if (this.insets.left > 0) {
                gr.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
            }
            if (this.insets.bottom > 0) {
                gr.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
            }
            if (this.insets.right > 0) {
                gr.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
            }
            gr.setPaint(oldPaint);
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static class RowWidget
    extends Widget {
        private Object userObject;

        RowWidget(Scene scene, int columns, Object userObject) {
            super(scene);
            this.setLayout(new TableLayout(columns, 0, 0, 100));
            this.userObject = userObject;
            if (this.getScene() instanceof ObjectScene && userObject != null) {
                this.getActions().addAction(((ObjectScene)this.getScene()).createSelectAction());
                this.setBorder(new LineBorder(1, 0, 0, 0, BORDER_COLOR));
            }
        }

        protected void notifyAdded() {
            super.notifyAdded();
            if (this.getScene() instanceof ObjectScene && this.userObject != null) {
                ObjectScene scene = (ObjectScene)this.getScene();
                ArrayList<RowWidget> widgets = scene.findWidgets(this.userObject);
                if (widgets == null || widgets.isEmpty()) {
                    scene.addObject(this.userObject, new Widget[]{this});
                } else {
                    scene.removeObject(this.userObject);
                    widgets = new ArrayList<RowWidget>(widgets);
                    widgets.add(this);
                    scene.addObject(this.userObject, widgets.toArray(new Widget[widgets.size()]));
                }
            }
        }

        protected void notifyRemoved() {
            ObjectScene scene;
            ArrayList widgets;
            super.notifyRemoved();
            if (this.getScene() instanceof ObjectScene && this.userObject != null && (widgets = (scene = (ObjectScene)this.getScene()).findWidgets(this.userObject)) != null && widgets.contains((Object)this)) {
                if (widgets.size() == 1) {
                    scene.removeObject(this.userObject);
                } else {
                    widgets = new ArrayList(widgets);
                    widgets.remove((Object)this);
                    scene.removeObject(this.userObject);
                    scene.addObject(this.userObject, widgets.toArray(new Widget[widgets.size()]));
                }
            }
        }

        protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
            if (previousState.isSelected() != state.isSelected() || previousState.isFocused() != state.isFocused()) {
                this.setBorder((Border)(state.isSelected() ? (state.isFocused() ? BorderFactory.createDashedBorder((Color)SELECTED_BORDER_COLOR, (int)2, (int)2, (boolean)true) : BorderFactory.createLineBorder((int)1, (Color)SELECTED_BORDER_COLOR)) : (state.isFocused() ? BorderFactory.createDashedBorder((Color)BORDER_COLOR, (int)2, (int)2, (boolean)true) : new LineBorder(1, 0, 0, 0, BORDER_COLOR))));
                this.revalidate(true);
            }
        }
    }
}

