/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.VMCannotBeModifiedException;
import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackNodeModel;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.util.Exceptions;

public final class JPDADVFrame
implements DebuggingView.DVFrame {
    private final DebuggingView.DVThread thread;
    private final CallStackFrame stackFrame;

    JPDADVFrame(DebuggingView.DVThread thread, CallStackFrame stackFrame) {
        this.thread = thread;
        this.stackFrame = stackFrame;
    }

    public CallStackFrame getCallStackFrame() {
        return this.stackFrame;
    }

    public String getName() {
        String name = CallStackNodeModel.getCSFName(((JPDAThreadImpl)this.stackFrame.getThread()).getDebugger().getSession(), this.stackFrame, false);
        int colon = name.lastIndexOf(58);
        if (colon > 0 && JPDADVFrame.hasDigitsOnly(name.substring(colon + 1))) {
            name = name.substring(0, colon);
        }
        name = name + "()";
        return name;
    }

    private static boolean hasDigitsOnly(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return !string.isEmpty();
    }

    public DebuggingView.DVThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        this.stackFrame.makeCurrent();
    }

    public URI getSourceURI() {
        JPDADebuggerImpl debugger = ((JPDAThreadImpl)this.stackFrame.getThread()).getDebugger();
        Session session = debugger.getSession();
        String language = session.getCurrentLanguage();
        SourcePath sourcePath = debugger.getEngineContext();
        String url = null;
        try {
            url = sourcePath.getURL(this.stackFrame, language);
        }
        catch (InternalExceptionWrapper | InvalidStackFrameExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
            // empty catch block
        }
        if (url != null) {
            try {
                return new URI(url);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public int getLine() {
        return this.stackFrame.getLineNumber(this.stackFrame.getDefaultStratum());
    }

    public int getColumn() {
        return -1;
    }

    public void popOff() throws DebuggingView.PopException {
        try {
            this.stackFrame.popFrame();
        }
        catch (VMCannotBeModifiedException ex) {
            throw new UnsupportedOperationException(ex.getLocalizedMessage());
        }
        catch (InvalidStackFrameException | NativeMethodException | IllegalArgumentException ex) {
            throw new DebuggingView.PopException(ex.getLocalizedMessage());
        }
    }
}

