/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.impl.indexing.DefaultCacheFolderProvider;
import org.netbeans.modules.parsing.impl.indexing.implspi.CacheFolderProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class CacheFolder {
    private static final Logger LOG = Logger.getLogger(CacheFolder.class.getName());
    private static final Set<CacheFolderProvider.Kind> EVERYTHING = Collections.unmodifiableSet(EnumSet.allOf(CacheFolderProvider.Kind.class));

    public static URL getSourceRootForDataFolder(FileObject dataFolder) {
        try {
            return CacheFolderProvider.getRootForCacheFolder(dataFolder);
        }
        catch (IOException ioe) {
            LOG.log(Level.FINE, null, ioe);
            return null;
        }
    }

    public static FileObject getDataFolder(URL root) throws IOException {
        return CacheFolder.getDataFolder(root, false);
    }

    @CheckForNull
    public static FileObject getDataFolder(URL root, boolean onlyIfAlreadyExists) throws IOException {
        return CacheFolder.getDataFolder(root, EVERYTHING, onlyIfAlreadyExists ? CacheFolderProvider.Mode.EXISTENT : CacheFolderProvider.Mode.CREATE);
    }

    @CheckForNull
    public static FileObject getDataFolder(@NonNull URL root, @NonNull Set<CacheFolderProvider.Kind> kinds, @NonNull CacheFolderProvider.Mode mode) throws IOException {
        return CacheFolderProvider.getCacheFolderForRoot(root, kinds, mode);
    }

    @NonNull
    public static Iterable<? extends FileObject> findRootsWithCacheUnderFolder(@NonNull FileObject folder) throws IOException {
        HashSet<FileObject> roots = new HashSet<FileObject>();
        for (URL uRL : CacheFolderProvider.getRootsInFolder(folder.toURL())) {
            FileObject fo = URLMapper.findFileObject((URL)uRL);
            if (fo == null) continue;
            roots.add(fo);
        }
        return roots;
    }

    @NonNull
    public static FileObject getCacheFolder() {
        return DefaultCacheFolderProvider.getInstance().getCacheFolder();
    }

    public static void setCacheFolder(FileObject folder) {
        DefaultCacheFolderProvider.getInstance().setCacheFolder(folder);
    }

    private CacheFolder() {
        throw new IllegalStateException("No instance allowed");
    }
}

