/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.ui.copy.CreateCopyPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateCopy
extends CopyDialog
implements DocumentListener,
FocusListener,
ActionListener,
PropertyChangeListener {
    private final RepositoryPaths copyToRepositoryPaths;
    private final RepositoryPaths copyFromRepositoryPaths;
    private final File localeFile;
    private final RepositoryFile repositoryFile;
    private final boolean localChanges;

    public CreateCopy(RepositoryFile repositoryFile, File localeFile, boolean localChanges) {
        super(new CreateCopyPanel(), NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyDialog_Prompt", (Object)localeFile.getName()), NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyDialog_Title"));
        this.localeFile = localeFile;
        this.repositoryFile = repositoryFile;
        this.localChanges = localChanges;
        CreateCopyPanel panel = this.getCreateCopyPanel();
        panel.localRadioButton.addActionListener(this);
        panel.remoteRadioButton.addActionListener(this);
        panel.skipCheckBox.addActionListener(this);
        panel.copyFromLocalTextField.setText(localeFile.getAbsolutePath());
        panel.copyFromRemoteTextField.setText(SvnUtils.decodeToString(repositoryFile.getFileUrl()));
        this.copyFromRepositoryPaths = new RepositoryPaths(repositoryFile, panel.copyFromRemoteTextField, null, panel.copyFromRevisionTextField, panel.searchButton);
        this.copyFromRepositoryPaths.setupBehavior(null, 0, null, "org.netbeans.modules.subversion.ui.search.update");
        if (localeFile.isFile()) {
            Mnemonics.setLocalizedText((AbstractButton)panel.localRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromLocalFile"));
            Mnemonics.setLocalizedText((AbstractButton)panel.remoteRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromRemoteFile"));
            panel.skipCheckBox.setEnabled(false);
        } else {
            Mnemonics.setLocalizedText((AbstractButton)panel.localRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromLocalFolder"));
            Mnemonics.setLocalizedText((AbstractButton)panel.remoteRadioButton, (String)NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyForm_fromRemoteFolder"));
        }
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateCopy.class, (String)"CTL_CopyDialog_Title"));
        this.copyToRepositoryPaths = new RepositoryPaths(repositoryFile, (JTextComponent)panel.urlComboBox.getEditor().getEditorComponent(), panel.browseRepositoryButton, null, null);
        String browserPurposeMessage = "";
        browserPurposeMessage = localeFile.isFile() ? NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageCopyFile") : NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageCopyFolder");
        String defaultFolderName = localeFile.isFile() ? "" : localeFile.getName();
        int browserMode = 2;
        this.copyToRepositoryPaths.setupBehavior(browserPurposeMessage, browserMode, new BrowserAction[]{new CreateFolderAction(defaultFolderName)}, "org.netbeans.modules.subversion.ui.browser.copy", null);
        this.copyToRepositoryPaths.addPropertyChangeListener(this);
        this.setupUrlComboBox(repositoryFile, panel.urlComboBox, false);
        panel.messageTextArea.getDocument().addDocumentListener(this);
        ((JTextComponent)panel.urlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.setFromLocal();
        this.validateUserInput();
    }

    protected void validateUserInput() {
        String text = this.getCreateCopyPanel().messageTextArea.getText();
        try {
            RepositoryFile[] rf = this.copyToRepositoryPaths.getRepositoryFiles();
            if (rf == null || rf.length == 0) {
                this.setErrorText(NbBundle.getMessage(CreateCopy.class, (String)"LBL_MISSING_REPOSITORY_FOLDER"));
                this.getOKButton().setEnabled(false);
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.setErrorText(ex.getLocalizedMessage());
            this.getOKButton().setEnabled(false);
            return;
        }
        catch (MalformedURLException ex) {
            this.setErrorText(ex.getLocalizedMessage());
            this.getOKButton().setEnabled(false);
            return;
        }
        if (text == null || text.length() == 0) {
            this.setErrorText(NbBundle.getMessage(CreateCopy.class, (String)"LBL_MISSING_COPY_MESSAGE"));
            this.getOKButton().setEnabled(false);
            return;
        }
        this.resetErrorText();
        this.getOKButton().setEnabled(true);
    }

    void setErrorText(String txt) {
        CreateCopyPanel panel = this.getCreateCopyPanel();
        panel.invalidValuesLabel.setVisible(true);
        panel.invalidValuesLabel.setText(txt);
    }

    private void resetErrorText() {
        CreateCopyPanel panel = this.getCreateCopyPanel();
        panel.invalidValuesLabel.setVisible(false);
        panel.invalidValuesLabel.setText("");
    }

    CreateCopyPanel getCreateCopyPanel() {
        return (CreateCopyPanel)this.getPanel();
    }

    RepositoryFile getToRepositoryFile() {
        try {
            return this.getToRepositoryFileIntern();
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (NumberFormatException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    private RepositoryFile getToRepositoryFileIntern() throws NumberFormatException, MalformedURLException {
        RepositoryFile[] toRepositoryFiles = this.copyToRepositoryPaths.getRepositoryFiles();
        if (toRepositoryFiles.length > 0) {
            RepositoryFile toRepositoryFile = toRepositoryFiles[0];
            if (this.skipContents()) {
                return toRepositoryFile;
            }
            if (this.isLocal()) {
                return toRepositoryFile.appendPath(this.localeFile.getName());
            }
            return toRepositoryFile.appendPath(this.repositoryFile.getFileUrl().getLastPathSegment());
        }
        return null;
    }

    String getMessage() {
        return SvnUtils.fixLineEndings(this.getCreateCopyPanel().messageTextArea.getText());
    }

    boolean isLocal() {
        return this.getCreateCopyPanel().localRadioButton.isSelected();
    }

    File getLocalFile() {
        return this.localeFile;
    }

    RepositoryFile getFromRepositoryFile() {
        try {
            return this.copyFromRepositoryPaths.getRepositoryFiles()[0];
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (NumberFormatException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    boolean switchTo() {
        return this.getCreateCopyPanel().switchToCheckBox.isSelected();
    }

    boolean skipContents() {
        return this.getCreateCopyPanel().skipCheckBox.isSelected();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
        this.setPreview();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
        this.setPreview();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
        this.setPreview();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateUserInput();
        this.setPreview();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            boolean valid = (Boolean)evt.getNewValue();
            if (valid) {
                this.validateUserInput();
            } else {
                this.getOKButton().setEnabled(valid);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.getCreateCopyPanel().localRadioButton) {
            this.setFromLocal();
            this.setPreview();
        } else if (evt.getSource() == this.getCreateCopyPanel().remoteRadioButton) {
            this.selectFromRemote();
            this.setPreview();
        } else if (evt.getSource() == this.getCreateCopyPanel().skipCheckBox) {
            this.setPreview();
        }
    }

    private void setFromLocal() {
        CreateCopyPanel panel = this.getCreateCopyPanel();
        panel.copyFromLocalTextField.setEnabled(true);
        panel.copyFromRemoteTextField.setEnabled(false);
        panel.copyFromRevisionTextField.setEnabled(false);
        panel.searchButton.setEnabled(false);
        panel.warningLabel.setVisible(this.localChanges);
    }

    private void selectFromRemote() {
        CreateCopyPanel panel = this.getCreateCopyPanel();
        panel.copyFromLocalTextField.setEnabled(false);
        panel.copyFromRemoteTextField.setEnabled(true);
        panel.copyFromRevisionTextField.setEnabled(true);
        panel.searchButton.setEnabled(true);
        panel.warningLabel.setVisible(false);
    }

    private void setPreview() {
        try {
            RepositoryFile repositoryFile = this.getToRepositoryFileIntern();
            if (repositoryFile != null) {
                this.getCreateCopyPanel().previewTextField.setText(SvnUtils.decodeToString(repositoryFile.getFileUrl()));
            } else {
                this.getCreateCopyPanel().previewTextField.setText("");
            }
        }
        catch (NumberFormatException ex) {
            this.getCreateCopyPanel().previewTextField.setText("");
        }
        catch (MalformedURLException ex) {
            this.getCreateCopyPanel().previewTextField.setText("");
        }
    }
}

