/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.xml.XMLDataObjectLook;
import org.netbeans.modules.xml.cookies.CookieFactoryCreator;
import org.netbeans.modules.xml.cookies.CookieManager;
import org.netbeans.modules.xml.cookies.DataObjectCookieManager;
import org.netbeans.modules.xml.sync.DTDSyncSupport;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.actions.EditAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.xml.sax.InputSource;

public final class DTDDataObject
extends MultiDataObject
implements XMLDataObjectLook {
    public static final String DTD_MIME_TYPE = "text/x-dtd";
    private static final long serialVersionUID = 2890472952957502631L;
    private Reference<Synchronizator> refSync;
    private final DataObjectCookieManager cookieManager;

    public DTDDataObject(FileObject obj, UniFileLoader loader) throws DataObjectExistsException {
        super(obj, (MultiFileLoader)loader);
        CookieSet set = this.getCookieSet();
        this.cookieManager = new DataObjectCookieManager((DataObject)this, set);
        set.add((Node.Cookie)this.cookieManager);
        final TextEditorSupport.TextEditorSupportFactory editorFactory = TextEditorSupport.findEditorSupportFactory(this, "application/xml-dtd");
        editorFactory.registerCookies(set);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        set.add((Node.Cookie)new CheckXMLSupport(in, 2));
        new CookieManager((DataObject)this, set, DTDCookieFactoryCreator.class);
        set.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                editorFactory.createEditor().saveAs(folder, fileName);
            }
        }});
    }

    public static MultiViewEditorElement createMultiViewDTDElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    protected int associateLookup() {
        return 1;
    }

    protected Node createNodeDelegate() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("--> DTDDataObject.createNodeDelegate: this = " + this);
        }
        DataNodeCreator dataNodeCreator = (DataNodeCreator)Lookup.getDefault().lookup(DataNodeCreator.class);
        Object dataNode = null;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-*- DTDD   O     .createNodeDelegate: dataNodeCreator = " + dataNodeCreator);
        }
        dataNode = dataNodeCreator != null ? dataNodeCreator.createDataNode(this) : new DTDDataNode(this);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("<-- DTDDataObject.createNodeDelegate: dataNode = " + dataNode);
        }
        return dataNode;
    }

    private synchronized Synchronizator getSyncIfAvailable() {
        if (this.refSync == null) {
            return null;
        }
        return this.refSync.get();
    }

    @Override
    public synchronized Synchronizator getSyncInterface() {
        Synchronizator sync = null;
        if (this.refSync != null) {
            sync = this.refSync.get();
        }
        if (sync != null) {
            return sync;
        }
        sync = new DTDSyncSupport(this);
        this.refSync = new WeakReference<Synchronizator>(sync);
        return sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node.Cookie getCookie(Class klass) {
        Node.Cookie cake = null;
        boolean change = false;
        DTDDataObject dTDDataObject = this;
        synchronized (dTDDataObject) {
            cake = super.getCookie(klass);
            if (cake == null && CloneableOpenSupport.class == klass) {
                cake = super.getCookie(OpenCookie.class);
            }
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DTD cookie query " + klass + " => " + cake);
        }
        return cake;
    }

    @Override
    public DataObjectCookieManager getCookieManager() {
        return this.cookieManager;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static interface DTDCookieFactoryCreator
    extends CookieFactoryCreator {
    }

    public static interface DataNodeCreator {
        public DataNode createDataNode(DTDDataObject var1);
    }

    private static class DTDDataNode
    extends DataNode {
        public DTDDataNode(DTDDataObject obj) {
            super((DataObject)obj, Children.LEAF);
            this.setDefaultAction(SystemAction.get(EditAction.class));
            this.setIconBase("org/netbeans/modules/xml/resources/dtdObject");
            this.setShortDescription(Util.THIS.getString(DTDDataObject.class, "PROP_DTDDataNode_description"));
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

