/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.util.Elements;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Embeddable;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Entity;
import org.netbeans.modules.j2ee.persistence.spi.jpql.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeRepository;

public class ManagedTypeProvider
implements IManagedTypeProvider {
    private final Project project;
    private Map<String, IManagedType> managedTypes;
    private Map<String, IEntity> entities;
    private Map<String, IMappedSuperclass> mSuperclasses;
    private Map<String, IEmbeddable> embeddables;
    private ITypeRepository typeRepository;
    private final EntityMappings mappings;
    private boolean valid = true;
    private final Elements elements;

    public ManagedTypeProvider(Project project, EntityMappingsMetadata metaData, Elements elements) {
        this.project = project;
        this.mappings = metaData.getRoot();
        this.elements = elements;
    }

    public ManagedTypeProvider(Project project, EntityMappings mappings, Elements elements) {
        this.project = project;
        this.mappings = mappings;
        this.elements = elements;
    }

    public IManagedType getManagedType(IType itype) {
        this.initializeManagedTypes();
        for (IManagedType mt : this.managedTypes.values()) {
            if (!this.isValid() || mt.getType() == null || !mt.getType().equals(itype)) continue;
            return mt;
        }
        return null;
    }

    public IManagedType getManagedType(String name) {
        this.initializeManagedTypes();
        return this.managedTypes.get(name);
    }

    public ITypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new TypeRepository(this.project, this, this.elements);
        }
        return this.typeRepository;
    }

    public Iterable<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return Collections.unmodifiableCollection(this.managedTypes.values());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
        if (this.typeRepository != null) {
            ((TypeRepository)this.typeRepository).invalidate();
            this.typeRepository = null;
        }
    }

    public Iterable<IEntity> entities() {
        this.initializeManagedTypes();
        return this.entities.values();
    }

    public IEmbeddable getEmbeddable(IType itype) {
        this.initializeManagedTypes();
        return this.getEmbeddable(itype.getName());
    }

    public IEmbeddable getEmbeddable(String tName) {
        this.initializeManagedTypes();
        if (tName == null) {
            return null;
        }
        int lst = tName.lastIndexOf(46);
        String supposeName = lst > -1 ? tName.substring(lst + 1) : tName;
        IEmbeddable ret = this.embeddables.get(supposeName);
        if (ret == null) {
            for (IEmbeddable ent : this.embeddables.values()) {
                if (!tName.equals(ent.getType().getName())) continue;
                ret = ent;
                break;
            }
        }
        return ret;
    }

    public IEntity getEntity(IType itype) {
        this.initializeManagedTypes();
        return this.getEntity(itype.getName());
    }

    public IEntity getEntity(String tName) {
        this.initializeManagedTypes();
        if (tName == null) {
            return null;
        }
        int lst = tName.lastIndexOf(46);
        String supposeName = lst > -1 ? tName.substring(lst + 1) : tName;
        IEntity ret = this.entities.get(supposeName);
        if (ret == null) {
            for (IEntity ent : this.entities.values()) {
                if (!tName.equals(ent.getType().getName())) continue;
                ret = ent;
                break;
            }
        }
        return ret;
    }

    public IEntity getEntityNamed(String name) {
        this.initializeManagedTypes();
        return this.entities.get(name);
    }

    public IMappedSuperclass getMappedSuperclass(IType itype) {
        this.initializeManagedTypes();
        return this.getMappedSuperclass(itype.getName());
    }

    public IMappedSuperclass getMappedSuperclass(String tName) {
        this.initializeManagedTypes();
        if (tName == null) {
            return null;
        }
        int lst = tName.lastIndexOf(46);
        String supposeName = lst > -1 ? tName.substring(lst + 1) : tName;
        IMappedSuperclass ret = this.mSuperclasses.get(supposeName);
        if (ret == null) {
            for (IMappedSuperclass ent : this.mSuperclasses.values()) {
                if (!tName.equals(ent.getType().getName())) continue;
                ret = ent;
                break;
            }
        }
        return ret;
    }

    private void initializeManagedTypes() {
        if (this.managedTypes == null) {
            String name;
            this.entities = new HashMap<String, IEntity>();
            this.embeddables = new HashMap<String, IEmbeddable>();
            this.mSuperclasses = new HashMap<String, IMappedSuperclass>();
            this.managedTypes = new HashMap<String, IManagedType>();
            for (org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity entity : this.mappings.getEntity()) {
                if (entity == null || this.managedTypes.containsKey(name = entity.getName())) continue;
                Entity ent = new Entity(entity, (IManagedTypeProvider)this);
                this.managedTypes.put(name, ent);
                this.entities.put(name, ent);
            }
            for (org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity entity : this.mappings.getEmbeddable()) {
                if (entity == null || this.managedTypes.containsKey(name = entity.getClass2())) continue;
                Embeddable emb = new Embeddable((org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable)entity, (IManagedTypeProvider)this);
                this.managedTypes.put(name, emb);
                this.embeddables.put(name, emb);
            }
            for (org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity entity : this.mappings.getMappedSuperclass()) {
                if (entity == null || this.managedTypes.containsKey(name = entity.getClass2())) continue;
                MappedSuperclass msc = new MappedSuperclass((org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass)entity, (IManagedTypeProvider)this);
                this.managedTypes.put(name, msc);
                this.mSuperclasses.put(name, msc);
            }
        }
    }
}

