/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.Pair;

public class ResourceCache {
    private static final Logger LOG = Logger.getLogger(ResourceCache.class.getName());
    private static final int DEFAULT_NON_EXISTENT_CACHE_SIZE = 10000;
    private static final int NON_EXISTENT_CACHE_SIZE = Integer.getInteger("groovy.editor.ClassNodeCache.nonExistent.size", 10000);
    private static final URL PLACEHOLDER;
    private static final URL MULTIPLE;
    private final ClassPath path;
    private final Map<String, Map<String, URL>> folderContents = new HashMap<String, Map<String, URL>>();
    private final Map<CharSequence, Void> nonExistent = new LinkedHashMap<CharSequence, Void>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<CharSequence, Void> eldest) {
            if (this.size() > NON_EXISTENT_CACHE_SIZE) {
                LOG.log(Level.FINE, "Non existent cache full, removing : {0}", eldest.getKey());
                return true;
            }
            return false;
        }
    };

    public ResourceCache(ClassPath path) {
        this.path = path;
    }

    public ClassPath getPath() {
        return this.path;
    }

    protected boolean isNonExistentResource(String name) {
        return this.nonExistent.containsKey(name);
    }

    protected boolean isNonExistent(String name) {
        return false;
    }

    protected void addNonExistentResource(String name) {
        this.nonExistent.putIfAbsent(name, null);
    }

    private Pair<String, Map<String, URL>> loadFolder(String resourceName) {
        int lastSlash = resourceName.lastIndexOf(47);
        String folderName = lastSlash == -1 ? "" : resourceName.substring(0, lastSlash);
        Map<String, URL> contents = this.folderContents.get(folderName);
        String rest = resourceName.substring(lastSlash + 1);
        if (this.isNonExistentResource(folderName)) {
            return Pair.of((Object)rest, Collections.emptyMap());
        }
        if (contents != null) {
            return Pair.of((Object)rest, contents);
        }
        LinkedHashMap<String, URL> lhm = new LinkedHashMap<String, URL>();
        boolean empty = true;
        for (FileObject parent : this.path.findAllResources(folderName)) {
            for (FileObject f : parent.getChildren()) {
                if (lhm.putIfAbsent(f.getNameExt(), PLACEHOLDER) != null) {
                    lhm.put(f.getNameExt(), MULTIPLE);
                }
                empty = false;
            }
        }
        this.folderContents.put(folderName, lhm);
        if (empty) {
            this.addNonExistentResource(folderName);
        }
        return Pair.of((Object)rest, lhm);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isNonExistentResource(name)) {
            return Enumerations.empty();
        }
        Pair<String, Map<String, URL>> fl = this.loadFolder(name);
        URL res = (URL)((Map)fl.second()).get(fl.first());
        if (res == null) {
            return Collections.emptyEnumeration();
        }
        if (res == MULTIPLE) {
            List l = this.path.findAllResources(name);
            ArrayList<URL> converted = new ArrayList<URL>(l.size());
            for (FileObject f : l) {
                URL u = URLMapper.findURL((FileObject)f, (int)0);
                if (u == null) continue;
                converted.add(u);
            }
            return Collections.enumeration(converted);
        }
        if (res == PLACEHOLDER) {
            List l = this.path.findAllResources(name);
            if (l.isEmpty()) {
                this.addNonExistentResource(name);
                return null;
            }
            res = URLMapper.findURL((FileObject)((FileObject)l.get(0)), (int)0);
            if (res == null) {
                this.addNonExistentResource(name);
                return null;
            }
            ((Map)fl.second()).put((String)fl.first(), res);
        }
        return Enumerations.singleton((Object)res);
    }

    private URL doGetResource(String name) {
        Pair<String, Map<String, URL>> fl = this.loadFolder(name);
        URL res = (URL)((Map)fl.second()).get(fl.first());
        if (res == null) {
            return null;
        }
        if (res == MULTIPLE) {
            FileObject f = this.path.findResource(name);
            return URLMapper.findURL((FileObject)f, (int)0);
        }
        if (res == PLACEHOLDER) {
            FileObject f = this.path.findResource(name);
            res = URLMapper.findURL((FileObject)f, (int)0);
            ((Map)fl.second()).put((String)fl.first(), res);
            return res;
        }
        return res;
    }

    public URL getResource(String name) {
        if (this.isNonExistentResource(name)) {
            return null;
        }
        URL u = this.doGetResource(name);
        return u;
    }

    static {
        try {
            PLACEHOLDER = new URL("file:///");
            MULTIPLE = new URL("file:///");
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }
}

