/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import groovy.lang.GroovyClassLoader;
import groovy.transform.CompilationUnitAware;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.netbeans.modules.groovy.editor.compiler.ParsingCompilerCustomizer;
import org.netbeans.modules.groovy.editor.utils.GroovyUtils;

public final class SimpleTransformationCustomizer
implements ParsingCompilerCustomizer {
    private static final Logger LOG = Logger.getLogger(SimpleTransformationCustomizer.class.getName());
    public static final String PARSING_COMPILER_CONFIG = "Parser/Transformations";
    private final Cfg indexing = new Cfg();
    private final Cfg parsing = new Cfg();
    private static final String ATTR_MODE = "apply";
    private static final String VALUE_MODE_INDEXING = "index";
    private static final String VALUE_MODE_PARSING = "parse";
    private static final String ATTR_DISABLE_TRANSFORMATIONS = "disable";
    private static final String ATTR_ENABLE_TRANSFORMATIONS = "enable";

    private SimpleTransformationCustomizer() {
    }

    @Override
    public CompilerConfiguration configureParsingCompiler(ParsingCompilerCustomizer.Context ctx, CompilerConfiguration cfg) {
        Cfg c;
        Cfg cfg2 = c = GroovyUtils.isIndexingTask(ctx.getConsumerTask()) ? this.indexing : this.parsing;
        if (!c.disableTransformations.isEmpty()) {
            HashSet disabled = cfg.getDisabledGlobalASTTransformations();
            disabled = disabled == null ? new HashSet() : new HashSet(disabled);
            disabled.addAll(c.disableTransformations);
            cfg.setDisabledGlobalASTTransformations(disabled);
        }
        return cfg;
    }

    @Override
    public void decorateCompilation(ParsingCompilerCustomizer.Context ctx, CompilationUnit cu) {
        Cfg c = GroovyUtils.isIndexingTask(ctx.getConsumerTask()) ? this.indexing : this.parsing;
        GroovyClassLoader transformLoader = cu.getTransformLoader();
        Collection clist = c.addTransformations;
        if (clist == null || clist.isEmpty()) {
            return;
        }
        for (String cn : clist) {
            try {
                Class gTransClass = transformLoader.loadClass(cn, false, true, false);
                GroovyASTTransformation transformAnnotation = gTransClass.getAnnotation(GroovyASTTransformation.class);
                if (transformAnnotation == null) {
                    LOG.log(Level.WARNING, "Transform Class {0} is not annotated by {1}", new Object[]{gTransClass.getName(), GroovyASTTransformation.class.getName()});
                    continue;
                }
                if (ASTTransformation.class.isAssignableFrom(gTransClass)) {
                    ASTTransformation instance = (ASTTransformation)gTransClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (instance instanceof CompilationUnitAware) {
                        ((CompilationUnitAware)instance).setCompilationUnit(cu);
                    }
                    CompilationUnit.ISourceUnitOperation suOp = source -> instance.visit(new ASTNode[]{source.getAST()}, source);
                    cu.addNewPhaseOperation(suOp, transformAnnotation.phase().getPhaseNumber());
                    continue;
                }
                LOG.log(Level.WARNING, "Transform Class {0} is not ASTTransformation", gTransClass.getName());
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | CompilationFailedException ex) {
                LOG.log(Level.WARNING, "Failed to load transformation: {0}", cn);
                LOG.log(Level.WARNING, "Class load failed with the following error:", ex);
            }
        }
    }

    public static SimpleTransformationCustomizer fromLayer(Map<String, Object> values) {
        SimpleTransformationCustomizer instance = new SimpleTransformationCustomizer();
        Object o = values.get(ATTR_MODE);
        boolean applied = false;
        if (o instanceof String) {
            boolean warn = false;
            block8: for (String v : o.toString().split(",")) {
                switch (v = v.trim()) {
                    case "index": {
                        SimpleTransformationCustomizer.processMap(values, instance.indexing);
                        applied = true;
                        continue block8;
                    }
                    case "parse": {
                        SimpleTransformationCustomizer.processMap(values, instance.parsing);
                        applied = true;
                        continue block8;
                    }
                    default: {
                        applied = true;
                        if (warn) continue block8;
                        warn = true;
                        LOG.log(Level.WARNING, "Unexpected value of 'apply': {1}", v);
                    }
                }
            }
        } else if (o != null) {
            LOG.log(Level.WARNING, "Unexpected contents of 'apply': {0}", o);
            applied = true;
        }
        if (!applied) {
            SimpleTransformationCustomizer.processMap(values, instance.parsing);
        }
        return instance;
    }

    static void processMap(Map<String, Object> map, Cfg target) {
        Collection<String> enable;
        Collection<String> disable = SimpleTransformationCustomizer.findNames(map.get(ATTR_DISABLE_TRANSFORMATIONS));
        if (disable != null) {
            target.disableTransformations.addAll(disable);
            target.addTransformations.removeAll(disable);
        }
        if ((enable = SimpleTransformationCustomizer.findNames(map.get(ATTR_ENABLE_TRANSFORMATIONS))) != null) {
            target.addTransformations.addAll(enable);
        }
        if (disable == null && enable == null) {
            LOG.log(Level.WARNING, "Entry does not disable or enable transformation: {0}", map);
        }
    }

    static Collection<String> findNames(Object o) {
        LinkedHashSet<String> dtnames = new LinkedHashSet<String>();
        if (o instanceof Collection) {
            dtnames.addAll((Collection)o);
        } else if (o instanceof String) {
            for (String s : o.toString().split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                dtnames.add(s);
            }
        } else {
            return null;
        }
        return dtnames;
    }

    private static class Cfg {
        private final Set<String> disableTransformations = new HashSet<String>();
        private final Collection<String> addTransformations = new LinkedHashSet<String>();

        private Cfg() {
        }
    }
}

