/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.completion.BaseCompletion;
import org.netbeans.modules.groovy.editor.completion.SpockUtils;

public class SpockMethodParamCompletion
extends BaseCompletion {
    private static final String UNROLL_CLASS = "spock.lang.Unroll";

    @Override
    public boolean complete(Map<Object, CompletionProposal> proposals, CompletionContext request, int anchor) {
        boolean updated = false;
        if ((request.location == CaretLocation.INSIDE_METHOD || request.location == CaretLocation.INSIDE_CLOSURE) && SpockUtils.isInSpecificationClass(request)) {
            ListIterator<ASTNode> leafToRoot = request.path.leafToRoot();
            MethodNode methodNode = null;
            while (leafToRoot.hasNext()) {
                ASTNode next = leafToRoot.next();
                if (!(next instanceof MethodNode)) continue;
                methodNode = (MethodNode)next;
                break;
            }
            String name = null;
            if (methodNode != null) {
                Expression valueMember;
                List annotations;
                GroovyParserResult gpr;
                ClassNode unrollCN;
                AnnotationNode unroll = null;
                ParserResult pr = request.getParserResult();
                if (pr instanceof GroovyParserResult && (unrollCN = (gpr = (GroovyParserResult)request.getParserResult()).resolveClassName(UNROLL_CLASS)) != null && (annotations = methodNode.getAnnotations()) != null && !annotations.isEmpty()) {
                    for (AnnotationNode annotation : annotations) {
                        if (!annotation.getClassNode().isDerivedFrom(gpr.resolveClassName(UNROLL_CLASS))) continue;
                        unroll = annotation;
                        break;
                    }
                }
                if (unroll != null && (valueMember = unroll.getMember("value")) != null) {
                    name = valueMember.getText();
                }
                if (name == null || !name.contains("#")) {
                    name = methodNode.getName();
                }
            }
            if (name != null && name.contains("#")) {
                String[] parts = name.split("#");
                for (int i = 1; i < parts.length; ++i) {
                    String part = parts[i].trim();
                    if (part.isEmpty()) continue;
                    int index = part.indexOf(32);
                    if (index > 0) {
                        part = part.substring(0, index);
                    }
                    if ((index = part.indexOf(".")) > 0) {
                        part = part.substring(0, index);
                    }
                    if (part.isEmpty() || !part.startsWith(request.getPrefix())) continue;
                    proposals.put("local:" + part, (CompletionProposal)new CompletionItem.LocalVarItem(new SpockParameter(part), anchor));
                    updated = true;
                }
            }
        }
        return updated;
    }

    private static class SpockParameter
    implements Variable {
        private final String name;

        public SpockParameter(String name) {
            this.name = name;
        }

        public ClassNode getType() {
            return ClassHelper.DYNAMIC_TYPE;
        }

        public ClassNode getOriginType() {
            return ClassHelper.GROOVY_OBJECT_TYPE;
        }

        public String getName() {
            return this.name;
        }

        public Expression getInitialExpression() {
            return null;
        }

        public boolean hasInitialExpression() {
            return false;
        }

        public boolean isInStaticContext() {
            return false;
        }

        public boolean isDynamicTyped() {
            return true;
        }

        public boolean isClosureSharedVariable() {
            return false;
        }

        public void setClosureSharedVariable(boolean bln) {
        }

        public int getModifiers() {
            return 0;
        }
    }
}

