/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.TreeGraphLayoutAlignment;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.TreeGraphLayout;

public final class TreeGraphLayout<N, E>
extends GraphLayout<N, E> {
    private int originX;
    private int originY;
    private int verticalGap;
    private int horizontalGap;
    private boolean vertical;
    private boolean minimizeGap;
    private TreeGraphLayoutAlignment alignment;
    private N rootNode;

    public TreeGraphLayout(int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        this.originX = originX;
        this.originY = originY;
        this.verticalGap = verticalGap;
        this.horizontalGap = horizontalGap;
        this.vertical = vertical;
        this.minimizeGap = false;
        this.alignment = TreeGraphLayoutAlignment.TOP;
    }

    public TreeGraphLayout(int originX, int originY, int verticalGap, int horizontalGap, boolean vertical, boolean minimizeGap, TreeGraphLayoutAlignment alignment) {
        this(originX, originY, verticalGap, horizontalGap, vertical);
        this.minimizeGap = minimizeGap;
        this.alignment = alignment;
    }

    public void setRootNode(N rootNode) {
        this.rootNode = rootNode;
    }

    public void setProperties(int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        if (vertical) {
            this.originX = originX;
            this.originY = originY;
            this.verticalGap = verticalGap;
            this.horizontalGap = horizontalGap;
        } else {
            this.originX = originY;
            this.originY = originX;
            this.verticalGap = horizontalGap;
            this.horizontalGap = verticalGap;
        }
        this.vertical = vertical;
        this.minimizeGap = false;
        this.alignment = TreeGraphLayoutAlignment.TOP;
    }

    public void setProperties(int originX, int originY, int verticalGap, int horizontalGap, boolean vertical, boolean minimizeGap, TreeGraphLayoutAlignment alignment) {
        this.setProperties(originX, originY, verticalGap, horizontalGap, vertical);
        this.minimizeGap = minimizeGap;
        this.alignment = alignment;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        if (this.rootNode == null) {
            return;
        }
        Collection<N> allNodes = graph.getNodes();
        if (!allNodes.contains(this.rootNode)) {
            return;
        }
        ArrayList<N> nodesToResolve = new ArrayList<N>(allNodes);
        HashSet loadedSet = new HashSet();
        Node root = new Node(graph, this.rootNode, loadedSet);
        nodesToResolve.removeAll(loadedSet);
        Map map = root.getMaxSpaceForEveryLevel(graph);
        List envelope = root.layout(this.originX, this.originY, map, 0);
        int moveDistance = Integer.MIN_VALUE;
        for (Node.LeftRight leftRight : envelope) {
            if (leftRight.getLeft() >= this.originX || this.originX - leftRight.getLeft() <= moveDistance) continue;
            moveDistance = this.originX - leftRight.getLeft();
        }
        if (moveDistance == Integer.MIN_VALUE) {
            moveDistance = 0;
        }
        if (!this.vertical) {
            root.invert(moveDistance);
        } else {
            root.relativeBoundsCorrectionX(moveDistance);
        }
        HashMap<N, Point> resultPosition = new HashMap<N, Point>();
        root.upload(resultPosition);
        for (N n : nodesToResolve) {
            Point position = new Point();
            resultPosition.put(n, position);
        }
        for (Map.Entry entry : resultPosition.entrySet()) {
            this.setResolvedNodeLocation(graph, entry.getKey(), (Point)entry.getValue());
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> nodes) {
        throw new UnsupportedOperationException();
    }

    private class Node {
        private N node;
        private ArrayList<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private Point point;

        private Node(UniversalGraph<N, E> graph, N node, HashSet<N> loadedSet) {
            this.node = node;
            loadedSet.add(node);
            this.children = new ArrayList();
            for (Object edge : graph.findNodeEdges(node, true, false)) {
                Object child = graph.getEdgeTarget(edge);
                if (child == null || loadedSet.contains(child)) continue;
                this.children.add(new Node(graph, child, loadedSet));
            }
        }

        private Map<Integer, Integer> getMaxSpaceForEveryLevel(UniversalGraph<N, E> graph) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            this.calculateMaxSpace(graph, map, 0);
            return map;
        }

        private Map<Integer, Integer> calculateMaxSpace(UniversalGraph<N, E> graph, Map<Integer, Integer> map, int lvl) {
            Widget widget = graph.getScene().findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = TreeGraphLayout.this.vertical ? this.relativeBounds.height : this.relativeBounds.width;
            if (map.get(lvl) != null) {
                if (map.get(lvl) < this.space) {
                    map.put(lvl, this.space);
                }
            } else {
                map.put(lvl, this.space);
            }
            ++lvl;
            for (Node n : this.children) {
                n.calculateMaxSpace(graph, map, lvl);
            }
            return map;
        }

        /*
         * Could not resolve type clashes
         */
        private List<org.netbeans.modules.visual.graph.layout.TreeGraphLayout$Node.LeftRight> layout(int x, int y, Map<Integer, Integer> map, int lvl) {
            List<Object> leftright = null;
            if (this.children.size() == 0) {
                leftright = new ArrayList<LeftRight>();
                y = this.doHorizontalPlacementInLevel(y, map, lvl);
                if (TreeGraphLayout.this.vertical) {
                    y -= this.relativeBounds.y;
                    leftright.add(new LeftRight(x, x + this.relativeBounds.width));
                } else {
                    y -= this.relativeBounds.x;
                    leftright.add(new LeftRight(x, x + this.relativeBounds.height));
                }
                this.point = new Point(x, y);
                return leftright;
            }
            ++lvl;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i == 0) {
                    leftright = this.children.get(i).layout(x, y + map.get(lvl - 1) + TreeGraphLayout.this.verticalGap, map, lvl);
                    continue;
                }
                List<org.netbeans.modules.visual.graph.layout.TreeGraphLayout$Node.LeftRight> secound = this.children.get(i).layout(x, y + map.get(lvl - 1) + TreeGraphLayout.this.verticalGap, map, lvl);
                int leftlength = leftright.size();
                int rightlength = secound.size();
                int diff = rightlength - leftlength;
                int moveDist = Integer.MIN_VALUE;
                if (TreeGraphLayout.this.minimizeGap) {
                    for (int k = leftlength - 1; k >= 0; --k) {
                        int tmpmaxoverlap;
                        if (k + diff < 0 || k < 0 || (tmpmaxoverlap = ((LeftRight)leftright.get(k)).right - ((LeftRight)secound.get(k + diff)).left) <= moveDist) continue;
                        moveDist = tmpmaxoverlap;
                    }
                } else {
                    int maxRight = Integer.MIN_VALUE;
                    for (LeftRight l : leftright) {
                        maxRight = Math.max(maxRight, l.right);
                    }
                    int minLeft = Integer.MAX_VALUE;
                    for (LeftRight s : secound) {
                        minLeft = Math.min(minLeft, s.left);
                    }
                    moveDist = maxRight - minLeft;
                }
                if (moveDist > Integer.MIN_VALUE) {
                    int dx = moveDist + TreeGraphLayout.this.horizontalGap;
                    this.children.get((int)i).point.x += dx;
                    this.children.get(i).moveChildrenHorizontally(dx);
                }
                for (LeftRight lr : secound) {
                    lr.setLeft(lr.getLeft() + moveDist + TreeGraphLayout.this.horizontalGap);
                    lr.setRight(lr.getRight() + moveDist + TreeGraphLayout.this.horizontalGap);
                }
                for (int j = rightlength - 1; j >= 0; --j) {
                    if (j < secound.size() - leftright.size()) {
                        leftright.add(0, (LeftRight)secound.get(j));
                        continue;
                    }
                    if (j - diff < 0 || j < 0) continue;
                    if (((LeftRight)leftright.get(j - diff)).left > ((LeftRight)secound.get(j)).left) {
                        ((LeftRight)leftright.get(j - diff)).setLeft(((LeftRight)secound.get(j)).left);
                    }
                    if (((LeftRight)leftright.get(j - diff)).right >= ((LeftRight)secound.get(j)).right) continue;
                    ((LeftRight)leftright.get(j - diff)).setRight(((LeftRight)secound.get(j)).right);
                }
            }
            int yAlignment = this.doHorizontalPlacementInLevel(y, map, --lvl);
            if (TreeGraphLayout.this.minimizeGap) {
                if (TreeGraphLayout.this.vertical) {
                    this.point = new Point((((LeftRight)leftright.get(leftright.size() - 1)).right + ((LeftRight)leftright.get(leftright.size() - 1)).left) / 2 - this.relativeBounds.width / 2, yAlignment - this.relativeBounds.y);
                    leftright.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.width));
                } else {
                    this.point = new Point((((LeftRight)leftright.get(leftright.size() - 1)).right + ((LeftRight)leftright.get(leftright.size() - 1)).left) / 2 - this.relativeBounds.height / 2, yAlignment - this.relativeBounds.x);
                    leftright.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.height));
                }
            } else {
                int leftMin = Integer.MAX_VALUE;
                int rightMax = Integer.MIN_VALUE;
                for (LeftRight l : leftright) {
                    leftMin = Math.min(leftMin, l.left);
                    rightMax = Math.max(rightMax, l.right);
                }
                assert (leftMin != Integer.MAX_VALUE) : "whether envelope was empty or it had no valid leftMin value!";
                assert (rightMax != Integer.MIN_VALUE) : "whether envelope was empty or it had no vaild rightMin value!";
                if (TreeGraphLayout.this.vertical) {
                    this.point = new Point((leftMin + rightMax) / 2 - this.relativeBounds.width / 2, yAlignment - this.relativeBounds.y);
                    leftright.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.width));
                } else {
                    this.point = new Point((leftMin + rightMax) / 2 - this.relativeBounds.height / 2, yAlignment - this.relativeBounds.x);
                    leftright.add(new LeftRight(this.point.x, this.point.x + this.relativeBounds.height));
                }
            }
            return leftright;
        }

        private void moveChildrenHorizontally(int dx) {
            for (Node n : this.children) {
                n.point.x += dx;
                n.moveChildrenHorizontally(dx);
            }
        }

        private int doHorizontalPlacementInLevel(int y, Map<Integer, Integer> map, int lvl) {
            int yAlignment = 0;
            if (TreeGraphLayout.this.alignment == TreeGraphLayoutAlignment.TOP) {
                yAlignment = y;
            } else if (TreeGraphLayout.this.alignment == TreeGraphLayoutAlignment.CENTER) {
                yAlignment = y + (map.get(lvl) - this.space) / 2;
            } else if (TreeGraphLayout.this.alignment == TreeGraphLayoutAlignment.BOTTOM) {
                yAlignment = y + (map.get(lvl) - this.space);
            }
            return yAlignment;
        }

        private void invert(int moveDistance) {
            int tmpx = this.point.x + moveDistance;
            this.point.x = this.point.y;
            this.point.y = tmpx - this.relativeBounds.y;
            for (Node n : this.children) {
                n.invert(moveDistance);
            }
        }

        private void relativeBoundsCorrectionX(int moveDistance) {
            this.point.x = this.point.x - this.relativeBounds.x + moveDistance;
            for (Node n : this.children) {
                n.relativeBoundsCorrectionX(moveDistance);
            }
        }

        private void upload(HashMap<N, Point> result) {
            result.put(this.node, this.point);
            for (Node child : this.children) {
                child.upload(result);
            }
        }

        private class LeftRight {
            private int left;
            private int right;

            public LeftRight(int left, int right) {
                this.left = left;
                this.right = right;
            }

            public int getLeft() {
                return this.left;
            }

            public int getRight() {
                return this.right;
            }

            public void setLeft(int left) {
                this.left = left;
            }

            public void setRight(int right) {
                this.right = right;
            }
        }
    }
}

