/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EjbGenerationUtil {
    private static final String[] EJB_NAME_CONTEXTS = new String[]{"Session", "Entity", "MessageDriven"};

    public static String getFullClassName(String pkg, String className) {
        return pkg == null || pkg.length() == 0 ? className : pkg + "." + className;
    }

    public static String getBaseName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public static String[] getPackages(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        TreeSet<String> pkgs = new TreeSet<String>();
        for (int i = 0; i < groups.length; ++i) {
            EjbGenerationUtil.findPackages(groups[i].getRootFolder(), "", pkgs);
        }
        return pkgs.toArray(new String[pkgs.size()]);
    }

    private static void findPackages(FileObject root, String curPkg, Set<String> pkgs) {
        for (FileObject kid : root.getChildren()) {
            String name = curPkg + (curPkg.length() != 0 ? "." : "") + kid.getName();
            pkgs.add(name);
            EjbGenerationUtil.findPackages(kid, name, pkgs);
        }
    }

    public static boolean isEjbNameInDD(String ejbName, EjbJar ejbJar) {
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        CommonDDBean ejb = null;
        if (beans != null) {
            for (int i = 0; i < EJB_NAME_CONTEXTS.length && (ejb = beans.findBeanByName(EJB_NAME_CONTEXTS[i], "EjbName", ejbName)) == null; ++i) {
            }
        }
        return beans != null && ejb != null;
    }

    public static FileObject getPackageFileObject(SourceGroup location, String pkgName, Project project) {
        String relativePkgName = pkgName.replace('.', '/');
        FileObject fileObject = null;
        fileObject = location.getRootFolder().getFileObject(relativePkgName);
        if (fileObject != null) {
            return fileObject;
        }
        File rootFile = FileUtil.toFile((FileObject)location.getRootFolder());
        File pkg = new File(rootFile, relativePkgName);
        pkg.mkdirs();
        fileObject = location.getRootFolder().getFileObject(relativePkgName);
        return fileObject;
    }

    public static String getSelectedPackageName(FileObject targetFolder) {
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replace("/", ".");
        }
        return packageName + "";
    }
}

