/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousExadataInfrastructure;
import com.oracle.bmc.database.requests.LaunchAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.responses.LaunchAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchAutonomousExadataInfrastructureConverter {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchAutonomousExadataInfrastructureConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static LaunchAutonomousExadataInfrastructureRequest interceptRequest(LaunchAutonomousExadataInfrastructureRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, LaunchAutonomousExadataInfrastructureRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getLaunchAutonomousExadataInfrastructureDetails(), (String)"launchAutonomousExadataInfrastructureDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousExadataInfrastructures");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, LaunchAutonomousExadataInfrastructureResponse> fromResponse() {
        Function<Response, LaunchAutonomousExadataInfrastructureResponse> transformer = new Function<Response, LaunchAutonomousExadataInfrastructureResponse>(){

            public LaunchAutonomousExadataInfrastructureResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.LaunchAutonomousExadataInfrastructureResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousExadataInfrastructure.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                LaunchAutonomousExadataInfrastructureResponse.Builder builder = LaunchAutonomousExadataInfrastructureResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.autonomousExadataInfrastructure((AutonomousExadataInfrastructure)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                LaunchAutonomousExadataInfrastructureResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

