/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudVmClusterSummary {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="lastUpdateHistoryEntryId")
    private final String lastUpdateHistoryEntryId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="listenerPort")
    private final Long listenerPort;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="storageSizeInGBs")
    private final Integer storageSizeInGBs;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="ocpuCount")
    private final Float ocpuCount;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="dataStoragePercentage")
    private final Integer dataStoragePercentage;
    @JsonProperty(value="isLocalBackupEnabled")
    private final Boolean isLocalBackupEnabled;
    @JsonProperty(value="cloudExadataInfrastructureId")
    private final String cloudExadataInfrastructureId;
    @JsonProperty(value="isSparseDiskgroupEnabled")
    private final Boolean isSparseDiskgroupEnabled;
    @JsonProperty(value="giVersion")
    private final String giVersion;
    @JsonProperty(value="systemVersion")
    private final String systemVersion;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="diskRedundancy")
    private final DiskRedundancy diskRedundancy;
    @JsonProperty(value="scanIpIds")
    private final List<String> scanIpIds;
    @JsonProperty(value="vipIds")
    private final List<String> vipIds;
    @JsonProperty(value="scanDnsRecordId")
    private final String scanDnsRecordId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="scanDnsName")
    private final String scanDnsName;
    @JsonProperty(value="zoneId")
    private final String zoneId;
    @JsonProperty(value="scanListenerPortTcp")
    private final Integer scanListenerPortTcp;
    @JsonProperty(value="scanListenerPortTcpSsl")
    private final Integer scanListenerPortTcpSsl;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).availabilityDomain(this.availabilityDomain).subnetId(this.subnetId).backupSubnetId(this.backupSubnetId).nsgIds(this.nsgIds).backupNetworkNsgIds(this.backupNetworkNsgIds).lastUpdateHistoryEntryId(this.lastUpdateHistoryEntryId).shape(this.shape).listenerPort(this.listenerPort).lifecycleState(this.lifecycleState).nodeCount(this.nodeCount).storageSizeInGBs(this.storageSizeInGBs).displayName(this.displayName).timeCreated(this.timeCreated).lifecycleDetails(this.lifecycleDetails).timeZone(this.timeZone).hostname(this.hostname).domain(this.domain).cpuCoreCount(this.cpuCoreCount).ocpuCount(this.ocpuCount).clusterName(this.clusterName).dataStoragePercentage(this.dataStoragePercentage).isLocalBackupEnabled(this.isLocalBackupEnabled).cloudExadataInfrastructureId(this.cloudExadataInfrastructureId).isSparseDiskgroupEnabled(this.isSparseDiskgroupEnabled).giVersion(this.giVersion).systemVersion(this.systemVersion).sshPublicKeys(this.sshPublicKeys).licenseModel(this.licenseModel).diskRedundancy(this.diskRedundancy).scanIpIds(this.scanIpIds).vipIds(this.vipIds).scanDnsRecordId(this.scanDnsRecordId).freeformTags(this.freeformTags).definedTags(this.definedTags).scanDnsName(this.scanDnsName).zoneId(this.zoneId).scanListenerPortTcp(this.scanListenerPortTcp).scanListenerPortTcpSsl(this.scanListenerPortTcpSsl);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getLastUpdateHistoryEntryId() {
        return this.lastUpdateHistoryEntryId;
    }

    public String getShape() {
        return this.shape;
    }

    public Long getListenerPort() {
        return this.listenerPort;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Integer getStorageSizeInGBs() {
        return this.storageSizeInGBs;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Float getOcpuCount() {
        return this.ocpuCount;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getDataStoragePercentage() {
        return this.dataStoragePercentage;
    }

    public Boolean getIsLocalBackupEnabled() {
        return this.isLocalBackupEnabled;
    }

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public Boolean getIsSparseDiskgroupEnabled() {
        return this.isSparseDiskgroupEnabled;
    }

    public String getGiVersion() {
        return this.giVersion;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public DiskRedundancy getDiskRedundancy() {
        return this.diskRedundancy;
    }

    public List<String> getScanIpIds() {
        return this.scanIpIds;
    }

    public List<String> getVipIds() {
        return this.vipIds;
    }

    public String getScanDnsRecordId() {
        return this.scanDnsRecordId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getScanDnsName() {
        return this.scanDnsName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Integer getScanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    public Integer getScanListenerPortTcpSsl() {
        return this.scanListenerPortTcpSsl;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudVmClusterSummary)) {
            return false;
        }
        CloudVmClusterSummary other = (CloudVmClusterSummary)o;
        Long this$listenerPort = this.getListenerPort();
        Long other$listenerPort = other.getListenerPort();
        if (this$listenerPort == null ? other$listenerPort != null : !((Object)this$listenerPort).equals(other$listenerPort)) {
            return false;
        }
        Integer this$nodeCount = this.getNodeCount();
        Integer other$nodeCount = other.getNodeCount();
        if (this$nodeCount == null ? other$nodeCount != null : !((Object)this$nodeCount).equals(other$nodeCount)) {
            return false;
        }
        Integer this$storageSizeInGBs = this.getStorageSizeInGBs();
        Integer other$storageSizeInGBs = other.getStorageSizeInGBs();
        if (this$storageSizeInGBs == null ? other$storageSizeInGBs != null : !((Object)this$storageSizeInGBs).equals(other$storageSizeInGBs)) {
            return false;
        }
        Integer this$cpuCoreCount = this.getCpuCoreCount();
        Integer other$cpuCoreCount = other.getCpuCoreCount();
        if (this$cpuCoreCount == null ? other$cpuCoreCount != null : !((Object)this$cpuCoreCount).equals(other$cpuCoreCount)) {
            return false;
        }
        Float this$ocpuCount = this.getOcpuCount();
        Float other$ocpuCount = other.getOcpuCount();
        if (this$ocpuCount == null ? other$ocpuCount != null : !((Object)this$ocpuCount).equals(other$ocpuCount)) {
            return false;
        }
        Integer this$dataStoragePercentage = this.getDataStoragePercentage();
        Integer other$dataStoragePercentage = other.getDataStoragePercentage();
        if (this$dataStoragePercentage == null ? other$dataStoragePercentage != null : !((Object)this$dataStoragePercentage).equals(other$dataStoragePercentage)) {
            return false;
        }
        Boolean this$isLocalBackupEnabled = this.getIsLocalBackupEnabled();
        Boolean other$isLocalBackupEnabled = other.getIsLocalBackupEnabled();
        if (this$isLocalBackupEnabled == null ? other$isLocalBackupEnabled != null : !((Object)this$isLocalBackupEnabled).equals(other$isLocalBackupEnabled)) {
            return false;
        }
        Boolean this$isSparseDiskgroupEnabled = this.getIsSparseDiskgroupEnabled();
        Boolean other$isSparseDiskgroupEnabled = other.getIsSparseDiskgroupEnabled();
        if (this$isSparseDiskgroupEnabled == null ? other$isSparseDiskgroupEnabled != null : !((Object)this$isSparseDiskgroupEnabled).equals(other$isSparseDiskgroupEnabled)) {
            return false;
        }
        Integer this$scanListenerPortTcp = this.getScanListenerPortTcp();
        Integer other$scanListenerPortTcp = other.getScanListenerPortTcp();
        if (this$scanListenerPortTcp == null ? other$scanListenerPortTcp != null : !((Object)this$scanListenerPortTcp).equals(other$scanListenerPortTcp)) {
            return false;
        }
        Integer this$scanListenerPortTcpSsl = this.getScanListenerPortTcpSsl();
        Integer other$scanListenerPortTcpSsl = other.getScanListenerPortTcpSsl();
        if (this$scanListenerPortTcpSsl == null ? other$scanListenerPortTcpSsl != null : !((Object)this$scanListenerPortTcpSsl).equals(other$scanListenerPortTcpSsl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        if (this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain)) {
            return false;
        }
        String this$subnetId = this.getSubnetId();
        String other$subnetId = other.getSubnetId();
        if (this$subnetId == null ? other$subnetId != null : !this$subnetId.equals(other$subnetId)) {
            return false;
        }
        String this$backupSubnetId = this.getBackupSubnetId();
        String other$backupSubnetId = other.getBackupSubnetId();
        if (this$backupSubnetId == null ? other$backupSubnetId != null : !this$backupSubnetId.equals(other$backupSubnetId)) {
            return false;
        }
        List<String> this$nsgIds = this.getNsgIds();
        List<String> other$nsgIds = other.getNsgIds();
        if (this$nsgIds == null ? other$nsgIds != null : !((Object)this$nsgIds).equals(other$nsgIds)) {
            return false;
        }
        List<String> this$backupNetworkNsgIds = this.getBackupNetworkNsgIds();
        List<String> other$backupNetworkNsgIds = other.getBackupNetworkNsgIds();
        if (this$backupNetworkNsgIds == null ? other$backupNetworkNsgIds != null : !((Object)this$backupNetworkNsgIds).equals(other$backupNetworkNsgIds)) {
            return false;
        }
        String this$lastUpdateHistoryEntryId = this.getLastUpdateHistoryEntryId();
        String other$lastUpdateHistoryEntryId = other.getLastUpdateHistoryEntryId();
        if (this$lastUpdateHistoryEntryId == null ? other$lastUpdateHistoryEntryId != null : !this$lastUpdateHistoryEntryId.equals(other$lastUpdateHistoryEntryId)) {
            return false;
        }
        String this$shape = this.getShape();
        String other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !this$shape.equals(other$shape)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        String this$lifecycleDetails = this.getLifecycleDetails();
        String other$lifecycleDetails = other.getLifecycleDetails();
        if (this$lifecycleDetails == null ? other$lifecycleDetails != null : !this$lifecycleDetails.equals(other$lifecycleDetails)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$cloudExadataInfrastructureId = this.getCloudExadataInfrastructureId();
        String other$cloudExadataInfrastructureId = other.getCloudExadataInfrastructureId();
        if (this$cloudExadataInfrastructureId == null ? other$cloudExadataInfrastructureId != null : !this$cloudExadataInfrastructureId.equals(other$cloudExadataInfrastructureId)) {
            return false;
        }
        String this$giVersion = this.getGiVersion();
        String other$giVersion = other.getGiVersion();
        if (this$giVersion == null ? other$giVersion != null : !this$giVersion.equals(other$giVersion)) {
            return false;
        }
        String this$systemVersion = this.getSystemVersion();
        String other$systemVersion = other.getSystemVersion();
        if (this$systemVersion == null ? other$systemVersion != null : !this$systemVersion.equals(other$systemVersion)) {
            return false;
        }
        List<String> this$sshPublicKeys = this.getSshPublicKeys();
        List<String> other$sshPublicKeys = other.getSshPublicKeys();
        if (this$sshPublicKeys == null ? other$sshPublicKeys != null : !((Object)this$sshPublicKeys).equals(other$sshPublicKeys)) {
            return false;
        }
        LicenseModel this$licenseModel = this.getLicenseModel();
        LicenseModel other$licenseModel = other.getLicenseModel();
        if (this$licenseModel == null ? other$licenseModel != null : !((Object)((Object)this$licenseModel)).equals((Object)other$licenseModel)) {
            return false;
        }
        DiskRedundancy this$diskRedundancy = this.getDiskRedundancy();
        DiskRedundancy other$diskRedundancy = other.getDiskRedundancy();
        if (this$diskRedundancy == null ? other$diskRedundancy != null : !((Object)((Object)this$diskRedundancy)).equals((Object)other$diskRedundancy)) {
            return false;
        }
        List<String> this$scanIpIds = this.getScanIpIds();
        List<String> other$scanIpIds = other.getScanIpIds();
        if (this$scanIpIds == null ? other$scanIpIds != null : !((Object)this$scanIpIds).equals(other$scanIpIds)) {
            return false;
        }
        List<String> this$vipIds = this.getVipIds();
        List<String> other$vipIds = other.getVipIds();
        if (this$vipIds == null ? other$vipIds != null : !((Object)this$vipIds).equals(other$vipIds)) {
            return false;
        }
        String this$scanDnsRecordId = this.getScanDnsRecordId();
        String other$scanDnsRecordId = other.getScanDnsRecordId();
        if (this$scanDnsRecordId == null ? other$scanDnsRecordId != null : !this$scanDnsRecordId.equals(other$scanDnsRecordId)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        String this$scanDnsName = this.getScanDnsName();
        String other$scanDnsName = other.getScanDnsName();
        if (this$scanDnsName == null ? other$scanDnsName != null : !this$scanDnsName.equals(other$scanDnsName)) {
            return false;
        }
        String this$zoneId = this.getZoneId();
        String other$zoneId = other.getZoneId();
        if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $listenerPort = this.getListenerPort();
        result = result * 59 + ($listenerPort == null ? 43 : ((Object)$listenerPort).hashCode());
        Integer $nodeCount = this.getNodeCount();
        result = result * 59 + ($nodeCount == null ? 43 : ((Object)$nodeCount).hashCode());
        Integer $storageSizeInGBs = this.getStorageSizeInGBs();
        result = result * 59 + ($storageSizeInGBs == null ? 43 : ((Object)$storageSizeInGBs).hashCode());
        Integer $cpuCoreCount = this.getCpuCoreCount();
        result = result * 59 + ($cpuCoreCount == null ? 43 : ((Object)$cpuCoreCount).hashCode());
        Float $ocpuCount = this.getOcpuCount();
        result = result * 59 + ($ocpuCount == null ? 43 : ((Object)$ocpuCount).hashCode());
        Integer $dataStoragePercentage = this.getDataStoragePercentage();
        result = result * 59 + ($dataStoragePercentage == null ? 43 : ((Object)$dataStoragePercentage).hashCode());
        Boolean $isLocalBackupEnabled = this.getIsLocalBackupEnabled();
        result = result * 59 + ($isLocalBackupEnabled == null ? 43 : ((Object)$isLocalBackupEnabled).hashCode());
        Boolean $isSparseDiskgroupEnabled = this.getIsSparseDiskgroupEnabled();
        result = result * 59 + ($isSparseDiskgroupEnabled == null ? 43 : ((Object)$isSparseDiskgroupEnabled).hashCode());
        Integer $scanListenerPortTcp = this.getScanListenerPortTcp();
        result = result * 59 + ($scanListenerPortTcp == null ? 43 : ((Object)$scanListenerPortTcp).hashCode());
        Integer $scanListenerPortTcpSsl = this.getScanListenerPortTcpSsl();
        result = result * 59 + ($scanListenerPortTcpSsl == null ? 43 : ((Object)$scanListenerPortTcpSsl).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        String $subnetId = this.getSubnetId();
        result = result * 59 + ($subnetId == null ? 43 : $subnetId.hashCode());
        String $backupSubnetId = this.getBackupSubnetId();
        result = result * 59 + ($backupSubnetId == null ? 43 : $backupSubnetId.hashCode());
        List<String> $nsgIds = this.getNsgIds();
        result = result * 59 + ($nsgIds == null ? 43 : ((Object)$nsgIds).hashCode());
        List<String> $backupNetworkNsgIds = this.getBackupNetworkNsgIds();
        result = result * 59 + ($backupNetworkNsgIds == null ? 43 : ((Object)$backupNetworkNsgIds).hashCode());
        String $lastUpdateHistoryEntryId = this.getLastUpdateHistoryEntryId();
        result = result * 59 + ($lastUpdateHistoryEntryId == null ? 43 : $lastUpdateHistoryEntryId.hashCode());
        String $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : $shape.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        String $lifecycleDetails = this.getLifecycleDetails();
        result = result * 59 + ($lifecycleDetails == null ? 43 : $lifecycleDetails.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $cloudExadataInfrastructureId = this.getCloudExadataInfrastructureId();
        result = result * 59 + ($cloudExadataInfrastructureId == null ? 43 : $cloudExadataInfrastructureId.hashCode());
        String $giVersion = this.getGiVersion();
        result = result * 59 + ($giVersion == null ? 43 : $giVersion.hashCode());
        String $systemVersion = this.getSystemVersion();
        result = result * 59 + ($systemVersion == null ? 43 : $systemVersion.hashCode());
        List<String> $sshPublicKeys = this.getSshPublicKeys();
        result = result * 59 + ($sshPublicKeys == null ? 43 : ((Object)$sshPublicKeys).hashCode());
        LicenseModel $licenseModel = this.getLicenseModel();
        result = result * 59 + ($licenseModel == null ? 43 : ((Object)((Object)$licenseModel)).hashCode());
        DiskRedundancy $diskRedundancy = this.getDiskRedundancy();
        result = result * 59 + ($diskRedundancy == null ? 43 : ((Object)((Object)$diskRedundancy)).hashCode());
        List<String> $scanIpIds = this.getScanIpIds();
        result = result * 59 + ($scanIpIds == null ? 43 : ((Object)$scanIpIds).hashCode());
        List<String> $vipIds = this.getVipIds();
        result = result * 59 + ($vipIds == null ? 43 : ((Object)$vipIds).hashCode());
        String $scanDnsRecordId = this.getScanDnsRecordId();
        result = result * 59 + ($scanDnsRecordId == null ? 43 : $scanDnsRecordId.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        String $scanDnsName = this.getScanDnsName();
        result = result * 59 + ($scanDnsName == null ? 43 : $scanDnsName.hashCode());
        String $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "CloudVmClusterSummary(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", availabilityDomain=" + this.getAvailabilityDomain() + ", subnetId=" + this.getSubnetId() + ", backupSubnetId=" + this.getBackupSubnetId() + ", nsgIds=" + this.getNsgIds() + ", backupNetworkNsgIds=" + this.getBackupNetworkNsgIds() + ", lastUpdateHistoryEntryId=" + this.getLastUpdateHistoryEntryId() + ", shape=" + this.getShape() + ", listenerPort=" + this.getListenerPort() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", nodeCount=" + this.getNodeCount() + ", storageSizeInGBs=" + this.getStorageSizeInGBs() + ", displayName=" + this.getDisplayName() + ", timeCreated=" + this.getTimeCreated() + ", lifecycleDetails=" + this.getLifecycleDetails() + ", timeZone=" + this.getTimeZone() + ", hostname=" + this.getHostname() + ", domain=" + this.getDomain() + ", cpuCoreCount=" + this.getCpuCoreCount() + ", ocpuCount=" + this.getOcpuCount() + ", clusterName=" + this.getClusterName() + ", dataStoragePercentage=" + this.getDataStoragePercentage() + ", isLocalBackupEnabled=" + this.getIsLocalBackupEnabled() + ", cloudExadataInfrastructureId=" + this.getCloudExadataInfrastructureId() + ", isSparseDiskgroupEnabled=" + this.getIsSparseDiskgroupEnabled() + ", giVersion=" + this.getGiVersion() + ", systemVersion=" + this.getSystemVersion() + ", sshPublicKeys=" + this.getSshPublicKeys() + ", licenseModel=" + (Object)((Object)this.getLicenseModel()) + ", diskRedundancy=" + (Object)((Object)this.getDiskRedundancy()) + ", scanIpIds=" + this.getScanIpIds() + ", vipIds=" + this.getVipIds() + ", scanDnsRecordId=" + this.getScanDnsRecordId() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", scanDnsName=" + this.getScanDnsName() + ", zoneId=" + this.getZoneId() + ", scanListenerPortTcp=" + this.getScanListenerPortTcp() + ", scanListenerPortTcpSsl=" + this.getScanListenerPortTcpSsl() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "availabilityDomain", "subnetId", "backupSubnetId", "nsgIds", "backupNetworkNsgIds", "lastUpdateHistoryEntryId", "shape", "listenerPort", "lifecycleState", "nodeCount", "storageSizeInGBs", "displayName", "timeCreated", "lifecycleDetails", "timeZone", "hostname", "domain", "cpuCoreCount", "ocpuCount", "clusterName", "dataStoragePercentage", "isLocalBackupEnabled", "cloudExadataInfrastructureId", "isSparseDiskgroupEnabled", "giVersion", "systemVersion", "sshPublicKeys", "licenseModel", "diskRedundancy", "scanIpIds", "vipIds", "scanDnsRecordId", "freeformTags", "definedTags", "scanDnsName", "zoneId", "scanListenerPortTcp", "scanListenerPortTcpSsl"})
    @Deprecated
    public CloudVmClusterSummary(String id, String compartmentId, String availabilityDomain, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String lastUpdateHistoryEntryId, String shape, Long listenerPort, LifecycleState lifecycleState, Integer nodeCount, Integer storageSizeInGBs, String displayName, Date timeCreated, String lifecycleDetails, String timeZone, String hostname, String domain, Integer cpuCoreCount, Float ocpuCount, String clusterName, Integer dataStoragePercentage, Boolean isLocalBackupEnabled, String cloudExadataInfrastructureId, Boolean isSparseDiskgroupEnabled, String giVersion, String systemVersion, List<String> sshPublicKeys, LicenseModel licenseModel, DiskRedundancy diskRedundancy, List<String> scanIpIds, List<String> vipIds, String scanDnsRecordId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String scanDnsName, String zoneId, Integer scanListenerPortTcp, Integer scanListenerPortTcpSsl) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
        this.shape = shape;
        this.listenerPort = listenerPort;
        this.lifecycleState = lifecycleState;
        this.nodeCount = nodeCount;
        this.storageSizeInGBs = storageSizeInGBs;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.timeZone = timeZone;
        this.hostname = hostname;
        this.domain = domain;
        this.cpuCoreCount = cpuCoreCount;
        this.ocpuCount = ocpuCount;
        this.clusterName = clusterName;
        this.dataStoragePercentage = dataStoragePercentage;
        this.isLocalBackupEnabled = isLocalBackupEnabled;
        this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
        this.giVersion = giVersion;
        this.systemVersion = systemVersion;
        this.sshPublicKeys = sshPublicKeys;
        this.licenseModel = licenseModel;
        this.diskRedundancy = diskRedundancy;
        this.scanIpIds = scanIpIds;
        this.vipIds = vipIds;
        this.scanDnsRecordId = scanDnsRecordId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.scanDnsName = scanDnsName;
        this.zoneId = zoneId;
        this.scanListenerPortTcp = scanListenerPortTcp;
        this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
    }

    public static enum DiskRedundancy {
        High("HIGH"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiskRedundancy> map;

        private DiskRedundancy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiskRedundancy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiskRedundancy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiskRedundancy.class);
            map = new HashMap<String, DiskRedundancy>();
            for (DiskRedundancy v : DiskRedundancy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LicenseModel {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="lastUpdateHistoryEntryId")
        private String lastUpdateHistoryEntryId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="listenerPort")
        private Long listenerPort;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="storageSizeInGBs")
        private Integer storageSizeInGBs;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="ocpuCount")
        private Float ocpuCount;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="dataStoragePercentage")
        private Integer dataStoragePercentage;
        @JsonProperty(value="isLocalBackupEnabled")
        private Boolean isLocalBackupEnabled;
        @JsonProperty(value="cloudExadataInfrastructureId")
        private String cloudExadataInfrastructureId;
        @JsonProperty(value="isSparseDiskgroupEnabled")
        private Boolean isSparseDiskgroupEnabled;
        @JsonProperty(value="giVersion")
        private String giVersion;
        @JsonProperty(value="systemVersion")
        private String systemVersion;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="diskRedundancy")
        private DiskRedundancy diskRedundancy;
        @JsonProperty(value="scanIpIds")
        private List<String> scanIpIds;
        @JsonProperty(value="vipIds")
        private List<String> vipIds;
        @JsonProperty(value="scanDnsRecordId")
        private String scanDnsRecordId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="scanDnsName")
        private String scanDnsName;
        @JsonProperty(value="zoneId")
        private String zoneId;
        @JsonProperty(value="scanListenerPortTcp")
        private Integer scanListenerPortTcp;
        @JsonProperty(value="scanListenerPortTcpSsl")
        private Integer scanListenerPortTcpSsl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
            this.__explicitlySet__.add("lastUpdateHistoryEntryId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder listenerPort(Long listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder storageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
            this.__explicitlySet__.add("storageSizeInGBs");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder ocpuCount(Float ocpuCount) {
            this.ocpuCount = ocpuCount;
            this.__explicitlySet__.add("ocpuCount");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder dataStoragePercentage(Integer dataStoragePercentage) {
            this.dataStoragePercentage = dataStoragePercentage;
            this.__explicitlySet__.add("dataStoragePercentage");
            return this;
        }

        public Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            this.__explicitlySet__.add("isLocalBackupEnabled");
            return this;
        }

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            this.__explicitlySet__.add("cloudExadataInfrastructureId");
            return this;
        }

        public Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            this.__explicitlySet__.add("isSparseDiskgroupEnabled");
            return this;
        }

        public Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            this.__explicitlySet__.add("giVersion");
            return this;
        }

        public Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            this.__explicitlySet__.add("systemVersion");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            this.__explicitlySet__.add("diskRedundancy");
            return this;
        }

        public Builder scanIpIds(List<String> scanIpIds) {
            this.scanIpIds = scanIpIds;
            this.__explicitlySet__.add("scanIpIds");
            return this;
        }

        public Builder vipIds(List<String> vipIds) {
            this.vipIds = vipIds;
            this.__explicitlySet__.add("vipIds");
            return this;
        }

        public Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            this.__explicitlySet__.add("scanDnsRecordId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            this.__explicitlySet__.add("scanDnsName");
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            this.__explicitlySet__.add("zoneId");
            return this;
        }

        public Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            this.__explicitlySet__.add("scanListenerPortTcp");
            return this;
        }

        public Builder scanListenerPortTcpSsl(Integer scanListenerPortTcpSsl) {
            this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
            this.__explicitlySet__.add("scanListenerPortTcpSsl");
            return this;
        }

        public CloudVmClusterSummary build() {
            CloudVmClusterSummary __instance__ = new CloudVmClusterSummary(this.id, this.compartmentId, this.availabilityDomain, this.subnetId, this.backupSubnetId, this.nsgIds, this.backupNetworkNsgIds, this.lastUpdateHistoryEntryId, this.shape, this.listenerPort, this.lifecycleState, this.nodeCount, this.storageSizeInGBs, this.displayName, this.timeCreated, this.lifecycleDetails, this.timeZone, this.hostname, this.domain, this.cpuCoreCount, this.ocpuCount, this.clusterName, this.dataStoragePercentage, this.isLocalBackupEnabled, this.cloudExadataInfrastructureId, this.isSparseDiskgroupEnabled, this.giVersion, this.systemVersion, this.sshPublicKeys, this.licenseModel, this.diskRedundancy, this.scanIpIds, this.vipIds, this.scanDnsRecordId, this.freeformTags, this.definedTags, this.scanDnsName, this.zoneId, this.scanListenerPortTcp, this.scanListenerPortTcpSsl);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CloudVmClusterSummary o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).availabilityDomain(o.getAvailabilityDomain()).subnetId(o.getSubnetId()).backupSubnetId(o.getBackupSubnetId()).nsgIds(o.getNsgIds()).backupNetworkNsgIds(o.getBackupNetworkNsgIds()).lastUpdateHistoryEntryId(o.getLastUpdateHistoryEntryId()).shape(o.getShape()).listenerPort(o.getListenerPort()).lifecycleState(o.getLifecycleState()).nodeCount(o.getNodeCount()).storageSizeInGBs(o.getStorageSizeInGBs()).displayName(o.getDisplayName()).timeCreated(o.getTimeCreated()).lifecycleDetails(o.getLifecycleDetails()).timeZone(o.getTimeZone()).hostname(o.getHostname()).domain(o.getDomain()).cpuCoreCount(o.getCpuCoreCount()).ocpuCount(o.getOcpuCount()).clusterName(o.getClusterName()).dataStoragePercentage(o.getDataStoragePercentage()).isLocalBackupEnabled(o.getIsLocalBackupEnabled()).cloudExadataInfrastructureId(o.getCloudExadataInfrastructureId()).isSparseDiskgroupEnabled(o.getIsSparseDiskgroupEnabled()).giVersion(o.getGiVersion()).systemVersion(o.getSystemVersion()).sshPublicKeys(o.getSshPublicKeys()).licenseModel(o.getLicenseModel()).diskRedundancy(o.getDiskRedundancy()).scanIpIds(o.getScanIpIds()).vipIds(o.getVipIds()).scanDnsRecordId(o.getScanDnsRecordId()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).scanDnsName(o.getScanDnsName()).zoneId(o.getZoneId()).scanListenerPortTcp(o.getScanListenerPortTcp()).scanListenerPortTcpSsl(o.getScanListenerPortTcpSsl());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CloudVmClusterSummary.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", availabilityDomain=" + this.availabilityDomain + ", subnetId=" + this.subnetId + ", backupSubnetId=" + this.backupSubnetId + ", nsgIds=" + this.nsgIds + ", backupNetworkNsgIds=" + this.backupNetworkNsgIds + ", lastUpdateHistoryEntryId=" + this.lastUpdateHistoryEntryId + ", shape=" + this.shape + ", listenerPort=" + this.listenerPort + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", nodeCount=" + this.nodeCount + ", storageSizeInGBs=" + this.storageSizeInGBs + ", displayName=" + this.displayName + ", timeCreated=" + this.timeCreated + ", lifecycleDetails=" + this.lifecycleDetails + ", timeZone=" + this.timeZone + ", hostname=" + this.hostname + ", domain=" + this.domain + ", cpuCoreCount=" + this.cpuCoreCount + ", ocpuCount=" + this.ocpuCount + ", clusterName=" + this.clusterName + ", dataStoragePercentage=" + this.dataStoragePercentage + ", isLocalBackupEnabled=" + this.isLocalBackupEnabled + ", cloudExadataInfrastructureId=" + this.cloudExadataInfrastructureId + ", isSparseDiskgroupEnabled=" + this.isSparseDiskgroupEnabled + ", giVersion=" + this.giVersion + ", systemVersion=" + this.systemVersion + ", sshPublicKeys=" + this.sshPublicKeys + ", licenseModel=" + (Object)((Object)this.licenseModel) + ", diskRedundancy=" + (Object)((Object)this.diskRedundancy) + ", scanIpIds=" + this.scanIpIds + ", vipIds=" + this.vipIds + ", scanDnsRecordId=" + this.scanDnsRecordId + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", scanDnsName=" + this.scanDnsName + ", zoneId=" + this.zoneId + ", scanListenerPortTcp=" + this.scanListenerPortTcp + ", scanListenerPortTcpSsl=" + this.scanListenerPortTcpSsl + ")";
        }
    }
}

