/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbSystemUpgradeHistoryEntryRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String upgradeHistoryEntryId;
    private String opcRequestId;

    @ConstructorProperties(value={"dbSystemId", "upgradeHistoryEntryId", "opcRequestId"})
    GetDbSystemUpgradeHistoryEntryRequest(String dbSystemId, String upgradeHistoryEntryId, String opcRequestId) {
        this.dbSystemId = dbSystemId;
        this.upgradeHistoryEntryId = upgradeHistoryEntryId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).upgradeHistoryEntryId(this.upgradeHistoryEntryId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetDbSystemUpgradeHistoryEntryRequest(super=" + super.toString() + ", dbSystemId=" + this.getDbSystemId() + ", upgradeHistoryEntryId=" + this.getUpgradeHistoryEntryId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDbSystemUpgradeHistoryEntryRequest)) {
            return false;
        }
        GetDbSystemUpgradeHistoryEntryRequest other = (GetDbSystemUpgradeHistoryEntryRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$upgradeHistoryEntryId = this.getUpgradeHistoryEntryId();
        String other$upgradeHistoryEntryId = other.getUpgradeHistoryEntryId();
        if (this$upgradeHistoryEntryId == null ? other$upgradeHistoryEntryId != null : !this$upgradeHistoryEntryId.equals(other$upgradeHistoryEntryId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDbSystemUpgradeHistoryEntryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $upgradeHistoryEntryId = this.getUpgradeHistoryEntryId();
        result = result * 59 + ($upgradeHistoryEntryId == null ? 43 : $upgradeHistoryEntryId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getUpgradeHistoryEntryId() {
        return this.upgradeHistoryEntryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemUpgradeHistoryEntryRequest, Void> {
        private String dbSystemId;
        private String upgradeHistoryEntryId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemUpgradeHistoryEntryRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.upgradeHistoryEntryId(o.getUpgradeHistoryEntryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemUpgradeHistoryEntryRequest build() {
            GetDbSystemUpgradeHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder upgradeHistoryEntryId(String upgradeHistoryEntryId) {
            this.upgradeHistoryEntryId = upgradeHistoryEntryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDbSystemUpgradeHistoryEntryRequest buildWithoutInvocationCallback() {
            return new GetDbSystemUpgradeHistoryEntryRequest(this.dbSystemId, this.upgradeHistoryEntryId, this.opcRequestId);
        }

        public String toString() {
            return "GetDbSystemUpgradeHistoryEntryRequest.Builder(dbSystemId=" + this.dbSystemId + ", upgradeHistoryEntryId=" + this.upgradeHistoryEntryId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

