/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAutonomousDbVersionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private AutonomousDatabaseSummary.DbWorkload dbWorkload;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "opcRequestId", "dbWorkload", "sortOrder"})
    ListAutonomousDbVersionsRequest(String compartmentId, Integer limit, String page, String opcRequestId, AutonomousDatabaseSummary.DbWorkload dbWorkload, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.dbWorkload = dbWorkload;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).dbWorkload(this.dbWorkload).sortOrder(this.sortOrder);
    }

    public String toString() {
        return "ListAutonomousDbVersionsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", opcRequestId=" + this.getOpcRequestId() + ", dbWorkload=" + (Object)((Object)this.getDbWorkload()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListAutonomousDbVersionsRequest)) {
            return false;
        }
        ListAutonomousDbVersionsRequest other = (ListAutonomousDbVersionsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        AutonomousDatabaseSummary.DbWorkload this$dbWorkload = this.getDbWorkload();
        AutonomousDatabaseSummary.DbWorkload other$dbWorkload = other.getDbWorkload();
        if (this$dbWorkload == null ? other$dbWorkload != null : !((Object)((Object)this$dbWorkload)).equals((Object)other$dbWorkload)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        return !(this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListAutonomousDbVersionsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        AutonomousDatabaseSummary.DbWorkload $dbWorkload = this.getDbWorkload();
        result = result * 59 + ($dbWorkload == null ? 43 : ((Object)((Object)$dbWorkload)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutonomousDatabaseSummary.DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousDbVersionsRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private AutonomousDatabaseSummary.DbWorkload dbWorkload;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousDbVersionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.dbWorkload(o.getDbWorkload());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousDbVersionsRequest build() {
            ListAutonomousDbVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dbWorkload(AutonomousDatabaseSummary.DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListAutonomousDbVersionsRequest buildWithoutInvocationCallback() {
            return new ListAutonomousDbVersionsRequest(this.compartmentId, this.limit, this.page, this.opcRequestId, this.dbWorkload, this.sortOrder);
        }

        public String toString() {
            return "ListAutonomousDbVersionsRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", dbWorkload=" + (Object)((Object)this.dbWorkload) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

