/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DbHomeSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDbHomesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String dbSystemId;
    private String vmClusterId;
    private String backupId;
    private String dbVersion;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private DbHomeSummary.LifecycleState lifecycleState;
    private String displayName;

    @ConstructorProperties(value={"compartmentId", "dbSystemId", "vmClusterId", "backupId", "dbVersion", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "displayName"})
    ListDbHomesRequest(String compartmentId, String dbSystemId, String vmClusterId, String backupId, String dbVersion, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, DbHomeSummary.LifecycleState lifecycleState, String displayName) {
        this.compartmentId = compartmentId;
        this.dbSystemId = dbSystemId;
        this.vmClusterId = vmClusterId;
        this.backupId = backupId;
        this.dbVersion = dbVersion;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).dbSystemId(this.dbSystemId).vmClusterId(this.vmClusterId).backupId(this.backupId).dbVersion(this.dbVersion).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).displayName(this.displayName);
    }

    public String toString() {
        return "ListDbHomesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", dbSystemId=" + this.getDbSystemId() + ", vmClusterId=" + this.getVmClusterId() + ", backupId=" + this.getBackupId() + ", dbVersion=" + this.getDbVersion() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", displayName=" + this.getDisplayName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDbHomesRequest)) {
            return false;
        }
        ListDbHomesRequest other = (ListDbHomesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$vmClusterId = this.getVmClusterId();
        String other$vmClusterId = other.getVmClusterId();
        if (this$vmClusterId == null ? other$vmClusterId != null : !this$vmClusterId.equals(other$vmClusterId)) {
            return false;
        }
        String this$backupId = this.getBackupId();
        String other$backupId = other.getBackupId();
        if (this$backupId == null ? other$backupId != null : !this$backupId.equals(other$backupId)) {
            return false;
        }
        String this$dbVersion = this.getDbVersion();
        String other$dbVersion = other.getDbVersion();
        if (this$dbVersion == null ? other$dbVersion != null : !this$dbVersion.equals(other$dbVersion)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        DbHomeSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        DbHomeSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDbHomesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $vmClusterId = this.getVmClusterId();
        result = result * 59 + ($vmClusterId == null ? 43 : $vmClusterId.hashCode());
        String $backupId = this.getBackupId();
        result = result * 59 + ($backupId == null ? 43 : $backupId.hashCode());
        String $dbVersion = this.getDbVersion();
        result = result * 59 + ($dbVersion == null ? 43 : $dbVersion.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        DbHomeSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public DbHomeSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbHomesRequest, Void> {
        private String compartmentId;
        private String dbSystemId;
        private String vmClusterId;
        private String backupId;
        private String dbVersion;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private DbHomeSummary.LifecycleState lifecycleState;
        private String displayName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbHomesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.dbSystemId(o.getDbSystemId());
            this.vmClusterId(o.getVmClusterId());
            this.backupId(o.getBackupId());
            this.dbVersion(o.getDbVersion());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbHomesRequest build() {
            ListDbHomesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(DbHomeSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ListDbHomesRequest buildWithoutInvocationCallback() {
            return new ListDbHomesRequest(this.compartmentId, this.dbSystemId, this.vmClusterId, this.backupId, this.dbVersion, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.displayName);
        }

        public String toString() {
            return "ListDbHomesRequest.Builder(compartmentId=" + this.compartmentId + ", dbSystemId=" + this.dbSystemId + ", vmClusterId=" + this.vmClusterId + ", backupId=" + this.backupId + ", dbVersion=" + this.dbVersion + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

