/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDbVersionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String dbSystemShape;
    private String dbSystemId;
    private DbSystemOptions.StorageManagement storageManagement;
    private Boolean isUpgradeSupported;
    private Boolean isDatabaseSoftwareImageSupported;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "dbSystemShape", "dbSystemId", "storageManagement", "isUpgradeSupported", "isDatabaseSoftwareImageSupported"})
    ListDbVersionsRequest(String compartmentId, Integer limit, String page, String dbSystemShape, String dbSystemId, DbSystemOptions.StorageManagement storageManagement, Boolean isUpgradeSupported, Boolean isDatabaseSoftwareImageSupported) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.dbSystemShape = dbSystemShape;
        this.dbSystemId = dbSystemId;
        this.storageManagement = storageManagement;
        this.isUpgradeSupported = isUpgradeSupported;
        this.isDatabaseSoftwareImageSupported = isDatabaseSoftwareImageSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).dbSystemShape(this.dbSystemShape).dbSystemId(this.dbSystemId).storageManagement(this.storageManagement).isUpgradeSupported(this.isUpgradeSupported).isDatabaseSoftwareImageSupported(this.isDatabaseSoftwareImageSupported);
    }

    public String toString() {
        return "ListDbVersionsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", dbSystemShape=" + this.getDbSystemShape() + ", dbSystemId=" + this.getDbSystemId() + ", storageManagement=" + (Object)((Object)this.getStorageManagement()) + ", isUpgradeSupported=" + this.getIsUpgradeSupported() + ", isDatabaseSoftwareImageSupported=" + this.getIsDatabaseSoftwareImageSupported() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDbVersionsRequest)) {
            return false;
        }
        ListDbVersionsRequest other = (ListDbVersionsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$isUpgradeSupported = this.getIsUpgradeSupported();
        Boolean other$isUpgradeSupported = other.getIsUpgradeSupported();
        if (this$isUpgradeSupported == null ? other$isUpgradeSupported != null : !((Object)this$isUpgradeSupported).equals(other$isUpgradeSupported)) {
            return false;
        }
        Boolean this$isDatabaseSoftwareImageSupported = this.getIsDatabaseSoftwareImageSupported();
        Boolean other$isDatabaseSoftwareImageSupported = other.getIsDatabaseSoftwareImageSupported();
        if (this$isDatabaseSoftwareImageSupported == null ? other$isDatabaseSoftwareImageSupported != null : !((Object)this$isDatabaseSoftwareImageSupported).equals(other$isDatabaseSoftwareImageSupported)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$dbSystemShape = this.getDbSystemShape();
        String other$dbSystemShape = other.getDbSystemShape();
        if (this$dbSystemShape == null ? other$dbSystemShape != null : !this$dbSystemShape.equals(other$dbSystemShape)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        DbSystemOptions.StorageManagement this$storageManagement = this.getStorageManagement();
        DbSystemOptions.StorageManagement other$storageManagement = other.getStorageManagement();
        return !(this$storageManagement == null ? other$storageManagement != null : !((Object)((Object)this$storageManagement)).equals((Object)other$storageManagement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDbVersionsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $isUpgradeSupported = this.getIsUpgradeSupported();
        result = result * 59 + ($isUpgradeSupported == null ? 43 : ((Object)$isUpgradeSupported).hashCode());
        Boolean $isDatabaseSoftwareImageSupported = this.getIsDatabaseSoftwareImageSupported();
        result = result * 59 + ($isDatabaseSoftwareImageSupported == null ? 43 : ((Object)$isDatabaseSoftwareImageSupported).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $dbSystemShape = this.getDbSystemShape();
        result = result * 59 + ($dbSystemShape == null ? 43 : $dbSystemShape.hashCode());
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        DbSystemOptions.StorageManagement $storageManagement = this.getStorageManagement();
        result = result * 59 + ($storageManagement == null ? 43 : ((Object)((Object)$storageManagement)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDbSystemShape() {
        return this.dbSystemShape;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public DbSystemOptions.StorageManagement getStorageManagement() {
        return this.storageManagement;
    }

    public Boolean getIsUpgradeSupported() {
        return this.isUpgradeSupported;
    }

    public Boolean getIsDatabaseSoftwareImageSupported() {
        return this.isDatabaseSoftwareImageSupported;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbVersionsRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private String dbSystemShape;
        private String dbSystemId;
        private DbSystemOptions.StorageManagement storageManagement;
        private Boolean isUpgradeSupported;
        private Boolean isDatabaseSoftwareImageSupported;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbVersionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.dbSystemShape(o.getDbSystemShape());
            this.dbSystemId(o.getDbSystemId());
            this.storageManagement(o.getStorageManagement());
            this.isUpgradeSupported(o.getIsUpgradeSupported());
            this.isDatabaseSoftwareImageSupported(o.getIsDatabaseSoftwareImageSupported());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbVersionsRequest build() {
            ListDbVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder dbSystemShape(String dbSystemShape) {
            this.dbSystemShape = dbSystemShape;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder storageManagement(DbSystemOptions.StorageManagement storageManagement) {
            this.storageManagement = storageManagement;
            return this;
        }

        public Builder isUpgradeSupported(Boolean isUpgradeSupported) {
            this.isUpgradeSupported = isUpgradeSupported;
            return this;
        }

        public Builder isDatabaseSoftwareImageSupported(Boolean isDatabaseSoftwareImageSupported) {
            this.isDatabaseSoftwareImageSupported = isDatabaseSoftwareImageSupported;
            return this;
        }

        public ListDbVersionsRequest buildWithoutInvocationCallback() {
            return new ListDbVersionsRequest(this.compartmentId, this.limit, this.page, this.dbSystemShape, this.dbSystemId, this.storageManagement, this.isUpgradeSupported, this.isDatabaseSoftwareImageSupported);
        }

        public String toString() {
            return "ListDbVersionsRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", dbSystemShape=" + this.dbSystemShape + ", dbSystemId=" + this.dbSystemId + ", storageManagement=" + (Object)((Object)this.storageManagement) + ", isUpgradeSupported=" + this.isUpgradeSupported + ", isDatabaseSoftwareImageSupported=" + this.isDatabaseSoftwareImageSupported + ")";
        }
    }
}

