/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.RestoreDatabaseDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RestoreDatabaseRequest
extends BmcRequest<RestoreDatabaseDetails> {
    private String databaseId;
    private RestoreDatabaseDetails restoreDatabaseDetails;
    private String ifMatch;

    @InternalSdk
    public RestoreDatabaseDetails getBody$() {
        return this.restoreDatabaseDetails;
    }

    @ConstructorProperties(value={"databaseId", "restoreDatabaseDetails", "ifMatch"})
    RestoreDatabaseRequest(String databaseId, RestoreDatabaseDetails restoreDatabaseDetails, String ifMatch) {
        this.databaseId = databaseId;
        this.restoreDatabaseDetails = restoreDatabaseDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).restoreDatabaseDetails(this.restoreDatabaseDetails).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "RestoreDatabaseRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", restoreDatabaseDetails=" + this.getRestoreDatabaseDetails() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestoreDatabaseRequest)) {
            return false;
        }
        RestoreDatabaseRequest other = (RestoreDatabaseRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        RestoreDatabaseDetails this$restoreDatabaseDetails = this.getRestoreDatabaseDetails();
        RestoreDatabaseDetails other$restoreDatabaseDetails = other.getRestoreDatabaseDetails();
        if (this$restoreDatabaseDetails == null ? other$restoreDatabaseDetails != null : !((Object)this$restoreDatabaseDetails).equals(other$restoreDatabaseDetails)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestoreDatabaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        RestoreDatabaseDetails $restoreDatabaseDetails = this.getRestoreDatabaseDetails();
        result = result * 59 + ($restoreDatabaseDetails == null ? 43 : ((Object)$restoreDatabaseDetails).hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public RestoreDatabaseDetails getRestoreDatabaseDetails() {
        return this.restoreDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreDatabaseRequest, RestoreDatabaseDetails> {
        private String databaseId;
        private RestoreDatabaseDetails restoreDatabaseDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.restoreDatabaseDetails(o.getRestoreDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreDatabaseRequest build() {
            RestoreDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RestoreDatabaseDetails body) {
            this.restoreDatabaseDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder restoreDatabaseDetails(RestoreDatabaseDetails restoreDatabaseDetails) {
            this.restoreDatabaseDetails = restoreDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public RestoreDatabaseRequest buildWithoutInvocationCallback() {
            return new RestoreDatabaseRequest(this.databaseId, this.restoreDatabaseDetails, this.ifMatch);
        }

        public String toString() {
            return "RestoreDatabaseRequest.Builder(databaseId=" + this.databaseId + ", restoreDatabaseDetails=" + this.restoreDatabaseDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

