/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.EditRootAction;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.api.common.project.ui.ShowJavadocAction;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
    private static final String MODULE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/module.png";
    private final PlatformProvider pp;

    private PlatformNode(PlatformProvider pp, ClassPathSupport cs) {
        super((Children)new PlatformContentChildren(cs), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{new PlatformEditable(pp), new JavadocProvider(pp), new PathFinder()}), new PlatformFolderLookup(new InstanceContent(), pp)}));
        this.pp = pp;
        this.pp.addChangeListener(this);
        this.setIconBaseWithExtension(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String platformId;
        Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
        if (platHolder == null) {
            return NbBundle.getMessage(PlatformNode.class, (String)"TXT_UnknownPlatform");
        }
        JavaPlatform jp = (JavaPlatform)platHolder.second();
        String name = jp != null ? (jp.isValid() ? jp.getDisplayName() : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), jp.getDisplayName())) : ((platformId = (String)platHolder.first()) == null ? NbBundle.getMessage(PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), platformId));
        return name;
    }

    public String getHtmlDisplayName() {
        Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
        if (platHolder == null) {
            return null;
        }
        JavaPlatform jp = (JavaPlatform)platHolder.second();
        if (jp == null || !jp.isValid()) {
            String displayName = this.getDisplayName();
            try {
                displayName = XMLUtil.toElementContent((String)displayName);
            }
            catch (CharConversionException ex) {
                return null;
            }
            return "<font color=\"#A40000\">" + displayName + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(ShowJavadocAction.class), SystemAction.get(EditRootAction.class)};
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        LibrariesNode.rp.post(new Runnable(){

            @Override
            public void run() {
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    public String getShortDescription() {
        Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
        if (platHolder != null && platHolder.second() != null && !((JavaPlatform)platHolder.second()).getInstallFolders().isEmpty()) {
            FileObject installFolder = (FileObject)((JavaPlatform)platHolder.second()).getInstallFolders().iterator().next();
            return FileUtil.getFileDisplayName((FileObject)installFolder);
        }
        return super.getShortDescription();
    }

    public static PlatformNode create(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull Pair<Pair<String, String>, ClassPath> boot, @NonNull ClassPathSupport cs) {
        PlatformProvider pp = new PlatformProvider(project, eval, boot);
        return new PlatformNode(pp, cs);
    }

    private static final class PathFinder
    implements org.netbeans.spi.project.ui.PathFinder {
        PathFinder() {
        }

        public Node findPath(Node root, Object target) {
            Node node;
            org.netbeans.spi.project.ui.PathFinder pf;
            Node result = null;
            Node[] nodeArray = root.getChildren().getNodes(true);
            int n = nodeArray.length;
            for (int i = 0; i < n && ((pf = (org.netbeans.spi.project.ui.PathFinder)(node = nodeArray[i]).getLookup().lookup(org.netbeans.spi.project.ui.PathFinder.class)) == null || (result = pf.findPath(node, target)) == null); ++i) {
            }
            return result;
        }
    }

    private static class PlatformFolderLookup
    extends AbstractLookup {
        private final InstanceContent content;
        private final PlatformProvider platformProvider;

        PlatformFolderLookup(InstanceContent content, PlatformProvider platformProvider) {
            super((AbstractLookup.Content)content);
            this.content = content;
            this.platformProvider = platformProvider;
        }

        protected void beforeLookup(Lookup.Template<?> template) {
            super.beforeLookup(template);
            if (template.getType() == FileObject.class) {
                FileObject fo;
                Collection folders;
                ArrayList<DataObject> toAdd = new ArrayList<DataObject>(1);
                Pair<String, JavaPlatform> platHolder = this.platformProvider.getPlatform();
                if (platHolder != null && platHolder.second() != null && !(folders = ((JavaPlatform)platHolder.second()).getInstallFolders()).isEmpty() && (fo = (FileObject)folders.iterator().next()).isValid() && fo.isFolder()) {
                    try {
                        toAdd.add(DataFolder.find((FileObject)fo));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        // empty catch block
                    }
                }
                this.content.set(toAdd, null);
            }
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        @Override
        public boolean hasJavadoc() {
            Pair<String, JavaPlatform> platHolder = this.platformProvider.getPlatform();
            if (platHolder == null || platHolder.second() == null) {
                return false;
            }
            URL[] javadocRoots = JavadocProvider.getJavadocRoots((JavaPlatform)platHolder.second());
            return javadocRoots.length > 0;
        }

        @Override
        public void showJavadoc() {
            Pair<String, JavaPlatform> platHolder = this.platformProvider.getPlatform();
            if (platHolder != null && platHolder.second() != null) {
                JavaPlatform platform = (JavaPlatform)platHolder.second();
                URL[] javadocRoots = JavadocProvider.getJavadocRoots(platform);
                URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", javadocRoots);
                if (pageURL == null) {
                    pageURL = ShowJavadocAction.findJavadoc("index.html", javadocRoots);
                }
                ShowJavadocAction.showJavaDoc(pageURL, platform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform platform) {
            HashSet<URL> result = new HashSet<URL>();
            List l = platform.getBootstrapLibraries().entries();
            for (ClassPath.Entry e : l) {
                result.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)e.getURL()).getRoots()));
            }
            return result.toArray(new URL[result.size()]);
        }
    }

    private static final class PlatformProvider
    implements PropertyChangeListener {
        private static final Pair<String, JavaPlatform> BUSY = Pair.of(null, null);
        private static final RequestProcessor RP = new RequestProcessor(PlatformProvider.class);
        private final Project project;
        private final PropertyEvaluator evaluator;
        private final Pair<Pair<String, String>, ClassPath> boot;
        private final AtomicReference<Pair<String, JavaPlatform>> platformCache = new AtomicReference();
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public PlatformProvider(@NonNull Project project, @NonNull PropertyEvaluator evaluator, @NonNull Pair<Pair<String, String>, ClassPath> boot) {
            this.project = project;
            this.evaluator = evaluator;
            this.boot = boot;
            JavaPlatformManager jps = JavaPlatformManager.getDefault();
            jps.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jps));
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
            if (this.boot.second() != null) {
                ((ClassPath)this.boot.second()).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.boot.second()));
            }
        }

        @CheckForNull
        public Pair<String, JavaPlatform> getPlatform() {
            Pair<String, JavaPlatform> res;
            if (this.platformCache.compareAndSet(null, BUSY)) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        String platformId = evaluator.getProperty((String)((Pair)boot.first()).first());
                        JavaPlatform platform = CommonProjectUtils.getActivePlatform(platformId, (String)((Pair)boot.first()).second());
                        if (platform == null) {
                            platform = ProjectPlatform.forProject((Project)project, (PropertyEvaluator)evaluator, (String)"j2se");
                        }
                        platformCache.set(Pair.of((Object)platformId, (Object)platform));
                        changeSupport.fireChange();
                    }
                });
            }
            return (res = this.platformCache.get()) == BUSY ? null : res;
        }

        @NonNull
        public FileObject[] getBootstrapLibraries() {
            Pair<String, JavaPlatform> jp = this.getPlatform();
            if (jp == null || jp.second() == null) {
                return new FileObject[0];
            }
            ClassPath cp = (ClassPath)this.boot.second();
            if (cp == null) {
                cp = ((JavaPlatform)jp.second()).getBootstrapLibraries();
            }
            return cp.getRoots();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (((String)((Pair)this.boot.first()).first()).equals(propName) || "roots".equals(propName) || "installedPlatforms".equals(propName)) {
                this.platformCache.set(null);
                this.getPlatform();
            }
        }
    }

    private static class PlatformEditable
    implements EditRootAction.Editable {
        private final PlatformProvider pp;

        private PlatformEditable(@NonNull PlatformProvider pp) {
            Parameters.notNull((CharSequence)"pp", (Object)pp);
            this.pp = pp;
        }

        @Override
        public boolean canEdit() {
            Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
            return platHolder != null && platHolder.second() != null;
        }

        @Override
        public void edit() {
            Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
            if (platHolder != null && platHolder.second() != null) {
                PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)platHolder.second()));
            }
        }
    }

    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        PlatformContentChildren(ClassPathSupport cs) {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            Node[] nodeArray;
            FilterNode afn = ActionFilterNode.forPackage(PackageView.createPackageView((SourceGroup)sg));
            if (afn == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = afn;
            }
            return nodeArray;
        }

        private List<SourceGroup> getKeys() {
            FileObject[] roots = ((PlatformNode)this.getNode()).pp.getBootstrapLibraries();
            if (roots.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(roots.length);
            for (FileObject root : roots) {
                ImageIcon icon;
                ImageIcon openedIcon;
                FileObject file;
                switch (root.toURL().getProtocol()) {
                    case "jar": {
                        file = FileUtil.getArchiveFile((FileObject)root);
                        icon = openedIcon = ImageUtilities.loadImageIcon((String)PlatformNode.ARCHIVE_ICON, (boolean)false);
                        break;
                    }
                    case "nbjrt": {
                        file = root;
                        icon = openedIcon = ImageUtilities.loadImageIcon((String)PlatformNode.MODULE_ICON, (boolean)false);
                        break;
                    }
                    default: {
                        file = root;
                        openedIcon = null;
                        icon = null;
                    }
                }
                if (!file.isValid()) continue;
                result.add(new LibrariesSourceGroup(root, file.getNameExt(), icon, openedIcon));
            }
            return result;
        }
    }
}

