/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openide.util.Utilities;

public final class Path {
    private static ArrayList<String> list = new ArrayList();
    private static String pathName = null;

    private Path() {
    }

    public static ArrayList<String> getPath() {
        return new ArrayList<String>(list);
    }

    public static String getPathAsString() {
        StringBuilder buf = new StringBuilder();
        for (String dir : list) {
            buf.append(dir);
            buf.append(File.pathSeparator);
        }
        return buf.substring(0, buf.length() - 1);
    }

    public static String getPathName() {
        if (pathName == null) {
            if (Utilities.isWindows()) {
                for (String key : System.getenv().keySet()) {
                    if (!key.equalsIgnoreCase("path")) continue;
                    pathName = key.substring(0, 4);
                    return pathName;
                }
            }
            pathName = "PATH";
        }
        return pathName;
    }

    public static String findCommand(String cmd) {
        String cmd2 = null;
        if (cmd.length() > 0) {
            if (Utilities.isWindows() && !cmd.endsWith(".exe")) {
                cmd2 = cmd + ".exe";
            }
            for (String dir : list) {
                File file2;
                File file = dir.equals(".") ? new File(cmd) : new File(dir, cmd);
                if (file.exists() && !file.isDirectory()) {
                    return file.getAbsolutePath();
                }
                if (Utilities.isWindows() && cmd.endsWith(".exe") && (file2 = new File(dir, cmd + ".lnk")).exists() && !file.isDirectory()) {
                    return file.getAbsolutePath();
                }
                if (cmd2 == null) continue;
                file = new File(dir, cmd2);
                if (file.exists() && !file.isDirectory()) {
                    return file.getAbsolutePath();
                }
                file2 = new File(dir, cmd2 + ".lnk");
                if (!file2.exists() || file.isDirectory()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    static {
        String path = System.getenv("PATH");
        if (Boolean.getBoolean("cnd.debug.use_altpath")) {
            path = System.getProperty("cnd.debug.altpath", path);
        }
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String dir = st.nextToken();
                list.add(dir);
            }
        } else if (Utilities.isUnix()) {
            list.add("/bin");
            list.add("/usr/bin");
            list.add("/sbin");
            list.add("/usr/sbin");
        } else if (Utilities.isWindows()) {
            list.add("C:/WINDOWS/System32");
            list.add("C:/WINDOWS");
            list.add("C:/WINDOWS/System32/WBem");
        }
    }
}

