/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform.palette;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.nbform.palette.AddToPaletteWizard;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

class ChooseProjectWizardPanel
implements WizardDescriptor.Panel<AddToPaletteWizard> {
    private JFileChooser projectChooser;
    private static String lastDirectoryUsed;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    ChooseProjectWizardPanel() {
    }

    public Component getComponent() {
        if (this.projectChooser == null) {
            this.projectChooser = ProjectChooser.projectChooser();
            this.projectChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.projectChooser.setName(PaletteUtils.getBundleString((String)"CTL_SelectProject_Caption"));
            this.projectChooser.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            if (lastDirectoryUsed != null) {
                this.projectChooser.setCurrentDirectory(new File(lastDirectoryUsed));
            }
            this.projectChooser.setControlButtonsAreShown(false);
            this.projectChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    String propName = ev.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(propName) || "directoryChanged".equals(propName)) {
                        ChooseProjectWizardPanel.this.cs.fireChange();
                    }
                }
            });
        }
        return this.projectChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        FileObject projectDir;
        File file;
        if (this.projectChooser != null && (file = this.projectChooser.getSelectedFile()) != null && (projectDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(projectDir);
                if (project != null) {
                    lastDirectoryUsed = this.projectChooser.getCurrentDirectory().getAbsolutePath();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void readSettings(AddToPaletteWizard settings) {
    }

    public void storeSettings(AddToPaletteWizard settings) {
        if (this.projectChooser == null) {
            return;
        }
        File file = this.projectChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        FileObject projectDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (projectDir == null) {
            return;
        }
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(projectDir);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (project == null) {
            return;
        }
        ArrayList<ClassSourceResolver.ProjectEntry> entries = new ArrayList<ClassSourceResolver.ProjectEntry>();
        entries.add(new ClassSourceResolver.ProjectEntry(project));
        settings.setJARFiles(entries);
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }
}

