/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.env;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jdk.jshell.spi.ExecutionControlProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.nbjshell.LaunchJDIAgent;
import org.netbeans.modules.jshell.env.Bundle;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellEvent;
import org.netbeans.modules.jshell.env.ShellListener;
import org.netbeans.modules.jshell.env.ShellStatus;
import org.netbeans.modules.jshell.launch.ShellOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.Places;
import org.openide.util.BaseUtilities;

public class ShellRegistry {
    private static final Logger LOG = Logger.getLogger(ShellRegistry.class.getName());
    private static final String WORKAREA_PREFIX = "junk";
    private static ShellRegistry INSTANCE = new ShellRegistry();
    private FileObject trashRoot;
    private Set<String> ignoreNames = new HashSet<String>();
    private Map<Project, JShellEnvironment> projectSessions = new HashMap<Project, JShellEnvironment>();
    private Map<FileObject, Reference<JShellEnvironment>> fileIndex = new HashMap<FileObject, Reference<JShellEnvironment>>();
    private JShellEnvironment defaultSession;
    private final Collection<ShellListener> shellListeners = new ArrayList<ShellListener>();
    private ShellOptions options = ShellOptions.get();

    private ShellRegistry() {
    }

    private void createAndCleanTrashArea() throws IOException {
        if (this.trashRoot != null) {
            return;
        }
        FileObject r = FileUtil.toFileObject((File)Places.getCacheSubdirectory((String)"jshell"));
        if (r == null) {
            throw new IOException("Unable to create cache for generated snippets");
        }
        LOG.log(Level.FINE, "Clearing trash area");
        this.trashRoot = r;
        for (FileObject f : r.getChildren()) {
            LOG.log(Level.FINE, "Deleting: {0}", f);
            try {
                f.delete();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not delete Java Shell work area {0}: {1}", new Object[]{f, ex});
                this.ignoreNames.add(f.getNameExt());
            }
        }
    }

    public static ShellRegistry get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEnvCreated(JShellEnvironment env) {
        ArrayList<ShellListener> ll;
        Collection<ShellListener> collection = this.shellListeners;
        synchronized (collection) {
            if (this.shellListeners.isEmpty()) {
                return;
            }
            ll = new ArrayList<ShellListener>(this.shellListeners);
        }
        ShellEvent ev = new ShellEvent(env);
        for (ShellListener l : ll) {
            l.shellCreated(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShellListener(ShellListener ll) {
        Collection<ShellListener> collection = this.shellListeners;
        synchronized (collection) {
            if (!this.shellListeners.contains(ll)) {
                this.shellListeners.add(ll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShellListener(ShellListener ll) {
        Collection<ShellListener> collection = this.shellListeners;
        synchronized (collection) {
            this.shellListeners.remove(ll);
        }
    }

    private FileObject createCacheRoot() throws IOException {
        List roots = this.fileIndex.keySet().stream().map(f -> f.getParent()).collect(Collectors.toList());
        HashSet<FileObject> existing = new HashSet<FileObject>(Arrays.asList(this.trashRoot.getChildren()));
        existing.removeAll(roots);
        existing.removeAll(this.ignoreNames);
        if (!existing.isEmpty()) {
            FileObject r = (FileObject)existing.iterator().next();
            for (FileObject c : r.getChildren()) {
                c.delete();
            }
            return r;
        }
        while (true) {
            String n = FileUtil.findFreeFolderName((FileObject)this.trashRoot, (String)WORKAREA_PREFIX);
            try {
                return this.trashRoot.createFolder(n);
            }
            catch (IOException ex) {
                if (this.trashRoot.getFileObject(n) != null) continue;
                throw ex;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCacheRoot(Reference<JShellEnvironment> ref, FileObject f) {
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            if (this.fileIndex.get(f) != ref) {
                return;
            }
            this.fileIndex.remove(f);
            try {
                f.delete();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not delete work root {0}: {1}", new Object[]{f, ex});
                this.ignoreNames.add(f.getNameExt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellEnvironment openProjectSession(Project p) throws IOException {
        JShellEnvironment s;
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            s = this.projectSessions.get(p);
            if (s != null) {
                return s;
            }
            String dispName = Bundle.ShellSession_CleanProject(ProjectUtils.getInformation((Project)p).getDisplayName());
            s = new LaunchJShellEnv(p, dispName);
            this.register(s);
            this.projectSessions.put(p, s);
        }
        this.fireEnvCreated(s);
        s.start();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project findProject(FileObject consoleFile) {
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            Reference<JShellEnvironment> refEnv = this.fileIndex.get(consoleFile);
            if (refEnv == null) {
                return null;
            }
            JShellEnvironment env = refEnv.get();
            if (env == null) {
                return null;
            }
            return env.getProject();
        }
    }

    public void startJShell(JShellEnvironment env) throws IOException {
        this.register(env);
        this.fireEnvCreated(env);
        env.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(JShellEnvironment env) throws IOException {
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            this.createAndCleanTrashArea();
            FileObject r = this.createCacheRoot();
            env.init(r);
            this.fileIndex.put(env.getConsoleFile(), new CLR(r, env));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellEnvironment get(FileObject consoleFile) {
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            Reference<JShellEnvironment> ref = this.fileIndex.get(consoleFile);
            return ref == null ? null : ref.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closed(JShellEnvironment env) {
        Project p = env.getProject();
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            Reference<JShellEnvironment> ref = this.fileIndex.get(env.getConsoleFile());
            if (ref == null || ref.get() != env) {
                return;
            }
            this.fileIndex.remove(env.getConsoleFile());
            this.projectSessions.remove(p);
        }
        GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{env.getSnippetClassPath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellEnvironment openDefaultSession(JavaPlatform platform) throws IOException {
        JShellEnvironment current;
        boolean forceClose = false;
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            current = this.defaultSession;
            if (current != null) {
                if (current.getPlatform() != platform) {
                    forceClose = true;
                    this.defaultSession = null;
                } else if (current.getStatus() == ShellStatus.SHUTDOWN || current.getStatus() == ShellStatus.DISCONNECTED) {
                    forceClose = true;
                    this.defaultSession = null;
                }
            }
        }
        if (forceClose) {
            current.closeEditor();
        } else if (current != null) {
            return current;
        }
        String dispName = Bundle.TITLE_PlatformShell(platform.getDisplayName());
        LaunchJShellEnv s = new LaunchJShellEnv(platform, dispName);
        ShellRegistry shellRegistry2 = this;
        synchronized (shellRegistry2) {
            if (this.defaultSession != null) {
                return this.defaultSession;
            }
            this.register(s);
            this.defaultSession = s;
        }
        this.fireEnvCreated(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellEnvironment getOwnerEnvironment(FileObject f) {
        ArrayList<JShellEnvironment> env;
        if (this.trashRoot == null || !FileUtil.isParentOf((FileObject)this.trashRoot, (FileObject)f)) {
            return null;
        }
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            env = new ArrayList<JShellEnvironment>(this.fileIndex.size());
            Iterator<Reference<JShellEnvironment>> it = this.fileIndex.values().iterator();
            while (it.hasNext()) {
                Reference<JShellEnvironment> ref = it.next();
                JShellEnvironment e = ref.get();
                if (e != null) {
                    env.add(e);
                    continue;
                }
                it.remove();
            }
        }
        for (JShellEnvironment e : env) {
            FileObject wr = e.getWorkRoot();
            if (wr != f && !FileUtil.isParentOf((FileObject)e.getWorkRoot(), (FileObject)f)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JShellEnvironment> openedShells(Project filter) {
        ArrayList<JShellEnvironment> ret;
        ShellRegistry shellRegistry = this;
        synchronized (shellRegistry) {
            ret = new ArrayList<JShellEnvironment>(this.fileIndex.size());
            for (Reference<JShellEnvironment> ref : this.fileIndex.values()) {
                JShellEnvironment e = ref.get();
                if (e == null || filter != null && filter != e.getProject()) continue;
                ret.add(e);
            }
        }
        return ret;
    }

    private class CLR
    extends WeakReference<JShellEnvironment>
    implements Runnable {
        private final FileObject workRoot;

        public CLR(FileObject workRoot, JShellEnvironment referent) {
            super(referent, BaseUtilities.activeReferenceQueue());
            this.workRoot = workRoot;
        }

        @Override
        public void run() {
            LOG.log(Level.FINE, "Work root {0} expired, trying to delete.", this.workRoot);
            ShellRegistry.this.deleteCacheRoot(this, this.workRoot);
        }
    }

    private static class LaunchJShellEnv
    extends JShellEnvironment {
        private JavaPlatform platform;

        public LaunchJShellEnv(Project project, String displayName) {
            super(project, displayName);
        }

        public LaunchJShellEnv(JavaPlatform platform, String displayName) {
            super(null, displayName);
            this.platform = platform;
        }

        @Override
        public JavaPlatform getPlatform() {
            if (this.platform != null) {
                return this.platform;
            }
            return super.getPlatform();
        }

        @Override
        public ExecutionControlProvider createExecutionEnv() {
            return LaunchJDIAgent.launch(this.getPlatform());
        }

        private String createClasspathString(String dummy) {
            File remoteProbeJar = InstalledFileLocator.getDefault().locate("modules/ext/nb-custom-jshell-probe.jar", "org.netbeans.libs.jshell", false);
            File replJar = InstalledFileLocator.getDefault().locate("modules/ext/nb-jshell.jar", "org.netbeans.libs.jshell", false);
            File toolsJar = null;
            for (FileObject jdkInstallDir : this.getPlatform().getInstallFolders()) {
                FileObject toolsJarFO = jdkInstallDir.getFileObject("lib/tools.jar");
                if (toolsJarFO == null) {
                    toolsJarFO = jdkInstallDir.getFileObject("../lib/tools.jar");
                }
                if (toolsJarFO == null) continue;
                toolsJar = FileUtil.toFile((FileObject)toolsJarFO);
            }
            ClassPath compilePath = this.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
            FileObject[] roots = compilePath.getRoots();
            File[] urlFiles = new File[roots.length];
            int index = 0;
            for (FileObject fo : roots) {
                File f = FileUtil.toFile((FileObject)fo);
                if (f == null) continue;
                urlFiles[index++] = f;
            }
            String cp = LaunchJShellEnv.addClassPath(toolsJar != null ? LaunchJShellEnv.toClassPath(remoteProbeJar, toolsJar) : LaunchJShellEnv.toClassPath(remoteProbeJar), urlFiles) + System.getProperty("path.separator") + " ";
            return "-classpath " + cp;
        }

        private static String addClassPath(String prefix, File ... files) {
            String suffix = LaunchJShellEnv.toClassPath(files);
            if (prefix != null && !prefix.isEmpty()) {
                return prefix + System.getProperty("path.separator") + suffix;
            }
            return suffix;
        }

        private static String toClassPath(File ... files) {
            String sep = "";
            StringBuilder cp = new StringBuilder();
            for (File f : files) {
                if (f == null) continue;
                cp.append(sep);
                cp.append(f.getAbsolutePath());
                sep = System.getProperty("path.separator");
            }
            return cp.toString();
        }
    }
}

